/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.larkdown;

import com.neep.meatlib.larkdown.LarkdownContent;
import com.neep.meatlib.larkdown.LarkdownParseException;
import com.neep.meatlib.larkdown.command.LarkdownCommands;
import com.neep.meatlib.larkdown.content.BulletLarkdownContent;
import com.neep.meatlib.larkdown.content.CodeLarkdownContent;
import com.neep.meatlib.larkdown.content.HeadingLarkdownContent;
import com.neep.meatlib.larkdown.parser.LineCommandParser;
import com.neep.meatlib.larkdown.parser.TextContentParser;
import com.neep.meatlib.util.StringTokenView;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class LarkdownParser {
    private final List<ContentParser> parsers;
    private boolean parsed = false;
    @Nullable
    private List<LarkdownContent> contents;
    private Map<String, String> preamble = new HashMap<String, String>();
    private final Reader inputReader;

    public LarkdownParser(Reader stream) {
        this(stream, List.of(new HeadingContentParser(), new BulletContentParser(), new CodeContentParser(), new LineCommandParser(LarkdownCommands.DEFAULT), new TextContentParser()));
    }

    public LarkdownParser(Reader stream, List<ContentParser> parsers) {
        this.inputReader = stream;
        this.parsers = parsers;
    }

    public void parse() throws IOException, LarkdownParseException {
        this.parsed = true;
        this.contents = new ObjectArrayList();
        try (BufferedReader reader = this.readLines();){
            String line;
            reader.mark(1000);
            String firstLine = reader.readLine();
            reader.reset();
            if (firstLine.startsWith("---")) {
                reader.readLine();
                this.preamble = this.readPreamble(reader);
            }
            block5: do {
                reader.mark(10000);
                line = reader.readLine();
                reader.reset();
                if (line == null) continue;
                for (ContentParser parser : this.parsers) {
                    if (!parser.matches(line)) continue;
                    parser.parse(reader, this::acceptContent);
                    continue block5;
                }
            } while (line != null);
        }
    }

    private void acceptContent(LarkdownContent content) {
        this.contents.add(content);
    }

    public Map<String, String> getPreamble() throws IOException, LarkdownParseException {
        if (!this.parsed) {
            this.parse();
        }
        return this.preamble;
    }

    public List<LarkdownContent> getContents() throws IOException, LarkdownParseException {
        if (!this.parsed) {
            this.parse();
        }
        return this.contents;
    }

    private Map<String, String> readPreamble(BufferedReader reader) throws IOException {
        String line;
        HashMap<String, String> preamble = new HashMap<String, String>();
        do {
            if ((line = reader.readLine()) == null) continue;
            if (line.startsWith("---")) {
                return preamble;
            }
            StringTokenView view = new StringTokenView(line);
            Pair<String, String> pair = this.readKeyValue(view);
            if (pair == null) continue;
            preamble.put((String)pair.key(), (String)pair.value());
        } while (line != null);
        return preamble;
    }

    @Nullable
    private Pair<String, String> readKeyValue(StringTokenView view) {
        try (StringTokenView.Mark entry = view.mark();){
            String key = view.nextIdentifier();
            if (!key.isEmpty() && view.nextThing() == ':') {
                StringBuilder sb = new StringBuilder();
                while (!view.lineEnded()) {
                    sb.append(view.next());
                }
                entry.commit();
                Pair pair = Pair.of((Object)key, (Object)sb.toString().strip());
                return pair;
            }
        }
        return null;
    }

    private BufferedReader readLines() throws IOException {
        return new BufferedReader(this.inputReader);
    }

    public static class HeadingContentParser
    implements ContentParser {
        @Override
        public boolean matches(String line) {
            return line.startsWith("#");
        }

        @Override
        public void parse(BufferedReader reader, ContentAcceptor acceptor) throws IOException {
            int level = 0;
            reader.mark(1);
            int cp = reader.read();
            while (cp == 35) {
                ++level;
                cp = reader.read();
            }
            String text = reader.readLine();
            acceptor.accept(new HeadingLarkdownContent(text, level));
        }
    }

    public static class BulletContentParser
    implements ContentParser {
        @Override
        public boolean matches(String line) {
            if (line.length() > 3) {
                char c0 = line.charAt(0);
                char c1 = line.charAt(1);
                return (c0 == '-' || c0 == '+') && Character.isWhitespace(c1);
            }
            return false;
        }

        @Override
        public void parse(BufferedReader reader, ContentAcceptor acceptor) throws IOException {
            for (int i = 0; i < 2; ++i) {
                reader.read();
            }
            acceptor.accept(new BulletLarkdownContent(reader.readLine()));
        }
    }

    public static class CodeContentParser
    implements ContentParser {
        @Override
        public boolean matches(String line) {
            return line.startsWith("```");
        }

        @Override
        public void parse(BufferedReader reader, ContentAcceptor acceptor) throws IOException {
            String line = reader.readLine();
            ObjectArrayList codeLines = new ObjectArrayList();
            do {
                if ((line = reader.readLine()) == null || line.startsWith("```")) continue;
                codeLines.add(line);
            } while (line != null && !line.startsWith("```"));
            acceptor.accept(new CodeLarkdownContent((List<String>)codeLines));
        }
    }

    public static interface ContentParser {
        public boolean matches(String var1);

        public void parse(BufferedReader var1, ContentAcceptor var2) throws IOException, LarkdownParseException;
    }

    public static interface ContentAcceptor {
        public void accept(LarkdownContent var1);
    }

    @FunctionalInterface
    public static interface ContentFunction<T extends LarkdownContent> {
        public void apply(T var1);
    }

    public static interface Visitor {
        public void visit(LarkdownContent var1);

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private final Map<Class<? extends LarkdownContent>, ContentFunction<LarkdownContent>> map = new IdentityHashMap<Class<? extends LarkdownContent>, ContentFunction<LarkdownContent>>();

            private Builder() {
            }

            public <T extends LarkdownContent> Builder type(Class<T> clazz, ContentFunction<T> function) {
                this.map.put(clazz, function);
                return this;
            }

            public Visitor build() {
                return content -> this.map.getOrDefault(content.getClass(), c -> {}).apply(content);
            }
        }
    }
}

