/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.item;

import com.neep.meatlib.block.MeatlibBlock;
import com.neep.meatlib.item.BaseBlockItem;
import com.neep.meatlib.item.TooltipSupplier;
import com.neep.meatlib.registry.RegistrationContext;
import com.neep.neepmeat.api.plc.PLCCols;
import net.minecraft.class_1747;
import net.minecraft.class_2248;
import net.minecraft.class_2561;

public class ItemSettings {
    public int maxCount = 64;
    protected TooltipSupplier tooltipSupplier = TooltipSupplier.BLANK;
    protected MeatlibBlock.ItemFactory factory;
    public static final TooltipSupplier REQUIRES_MOTOR = (stack, tooltip) -> tooltip.add(class_2561.method_43471((String)"tooltip.neepmeat.requires_motor").method_10862(PLCCols.EMPHASIS_TEXT));
    public static final TooltipSupplier REQUIRES_VASCULAR = (stack, tooltip) -> tooltip.add(class_2561.method_43471((String)"tooltip.neepmeat.requires_vascular").method_10862(PLCCols.EMPHASIS_TEXT));
    public static final TooltipSupplier REQUIRES_ICHOR = (stack, tooltip) -> tooltip.add(class_2561.method_43471((String)"tooltip.neepmeat.requires_ichor").method_10862(PLCCols.EMPHASIS_TEXT));
    public static final TooltipSupplier PLC_COMPATIBLE = (stack, tooltip) -> tooltip.add(class_2561.method_43471((String)"tooltip.neepmeat.plc_compatible").method_10862(PLCCols.EMPHASIS_TEXT));
    public static final TooltipSupplier PLC_INTERRUPT = (stack, tooltip) -> tooltip.add(class_2561.method_43471((String)"tooltip.neepmeat.plc_interrupt").method_10862(PLCCols.EMPHASIS_TEXT));
    public static final TooltipSupplier PLC_ACTUATOR = (stack, tooltip) -> tooltip.add(class_2561.method_43471((String)"tooltip.neepmeat.plc_actuator").method_10862(PLCCols.EMPHASIS_TEXT));
    public static final TooltipSupplier NEEPBUS_PART = (stack, tooltip) -> tooltip.add(class_2561.method_43471((String)"tooltip.neepmeat.neepbus_part").method_10862(PLCCols.EMPHASIS_TEXT));
    public static final TooltipSupplier RETAINS_INVENTORY = (stack, tooltip) -> tooltip.add(class_2561.method_43471((String)"tooltip.neepmeat.retains_inventory").method_10862(PLCCols.EMPHASIS_TEXT));

    protected ItemSettings() {
    }

    public static ItemSettings block() {
        return new ItemSettings().factory(BaseBlockItem::new);
    }

    public static ItemSettings item() {
        return new ItemSettings();
    }

    public ItemSettings maxCount(int maxCount) {
        this.maxCount = maxCount;
        return this;
    }

    public ItemSettings tooltip(TooltipSupplier tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier == TooltipSupplier.BLANK ? tooltipSupplier : this.tooltipSupplier.append(tooltipSupplier);
        return this;
    }

    public ItemSettings factory(MeatlibBlock.ItemFactory factory) {
        this.factory = factory;
        return this;
    }

    public ItemSettings requiresMotor() {
        this.tooltipSupplier = TooltipSupplier.combine(this.tooltipSupplier, REQUIRES_MOTOR);
        return this;
    }

    public ItemSettings requiresVascular() {
        this.tooltipSupplier = TooltipSupplier.combine(this.tooltipSupplier, REQUIRES_VASCULAR);
        return this;
    }

    public ItemSettings requiresIchor() {
        this.tooltipSupplier = TooltipSupplier.combine(this.tooltipSupplier, REQUIRES_ICHOR);
        return this;
    }

    public ItemSettings neepbus() {
        this.tooltipSupplier = TooltipSupplier.combine(this.tooltipSupplier, NEEPBUS_PART);
        return this;
    }

    public ItemSettings retainsInv() {
        this.tooltipSupplier = TooltipSupplier.combine(this.tooltipSupplier, RETAINS_INVENTORY);
        return this;
    }

    public ItemSettings plc() {
        this.tooltipSupplier = TooltipSupplier.combine(this.tooltipSupplier, PLC_COMPATIBLE);
        return this;
    }

    public ItemSettings plcInterrupt() {
        this.tooltipSupplier = TooltipSupplier.combine(this.tooltipSupplier, PLC_INTERRUPT);
        return this;
    }

    public ItemSettings plcActuator() {
        this.tooltipSupplier = TooltipSupplier.combine(this.tooltipSupplier, PLC_ACTUATOR);
        return this;
    }

    public MeatlibBlock.ItemFactory getFactory() {
        return this.factory;
    }

    public class_1747 create(class_2248 block, RegistrationContext ctx) {
        return this.factory.create(block, ctx, this);
    }
}

