/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.client.screen.auto;

import com.neep.meatlib.client.screen.auto.Panel;
import com.neep.meatlib.client.screen.auto.ScreenInitialisable;
import com.neep.meatlib.client.screen.primitive.Point;
import com.neep.meatlib.client.screen.primitive.Rectangle;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_364;
import net.minecraft.class_4068;

public class VStackPanel
extends Panel {
    protected final int padding;
    protected final int elementPadding;
    protected final boolean centre;
    protected final boolean fitElements;
    protected final List<Point.Mutable> children = new ObjectArrayList();
    private final List<class_4068> drawables = new ObjectArrayList();
    private final List<class_364> elements = new ObjectArrayList();
    protected int elementsHeight;
    protected int sideMargin = 0;

    public VStackPanel(int padding, int elementPadding, boolean centre, boolean fitElements) {
        this.padding = padding;
        this.elementPadding = elementPadding;
        this.centre = centre;
        this.fitElements = fitElements;
    }

    public VStackPanel(int padding, int elementPadding, boolean centre) {
        this(padding, elementPadding, centre, false);
    }

    protected int fitElementsWidth() {
        int maxW = 0;
        for (Point.Mutable child : this.children) {
            if (!this.fitElements && child instanceof Rectangle.Mutable) continue;
            maxW = Math.max(((Rectangle)((Object)child)).w(), maxW);
        }
        return maxW + 2 * this.padding + this.sideMargin;
    }

    protected int fitElementsHeight() {
        int height = 0;
        for (Point.Mutable child : this.children) {
            height += ((Rectangle)((Object)child)).h();
            height += this.elementPadding;
        }
        return height + 2 * this.padding + this.sideMargin;
    }

    protected int yOffset() {
        return 0;
    }

    @Override
    public void init() {
        int yOffset = this.yOffset();
        this.elementsHeight = 0;
        if (this.fitElements) {
            this.w = this.fitElementsWidth();
        }
        for (Point.Mutable child : this.children) {
            Rectangle rectangle = (Rectangle)((Object)child);
            if (child instanceof Rectangle.Mutable) {
                Rectangle.Mutable mutable = (Rectangle.Mutable)child;
                mutable.setDims(this.x + this.padding, this.y + this.padding + yOffset, this.w - 2 * this.padding - this.sideMargin, mutable.h());
            } else if (this.centre) {
                child.setPos(this.x + this.padding + (this.w - 2 * this.padding - rectangle.w()) / 2, this.y + yOffset);
            } else {
                child.setPos(this.x + this.padding, this.y + this.padding + yOffset);
            }
            if (child instanceof ScreenInitialisable) {
                ScreenInitialisable initialisable = (ScreenInitialisable)((Object)child);
                initialisable.init();
            }
            yOffset += rectangle.h() + this.elementPadding;
            this.elementsHeight += rectangle.h() + this.elementPadding;
        }
    }

    @Override
    public int w() {
        if (this.fitElements) {
            this.w = this.fitElementsWidth();
        }
        return this.w;
    }

    @Override
    public int h() {
        if (this.h == 0) {
            this.h = this.fitElementsHeight();
        }
        return this.h;
    }

    @Override
    protected List<class_4068> drawables() {
        return this.drawables;
    }

    @Override
    public List<class_364> method_25396() {
        return this.elements;
    }

    public <T extends class_4068 & Point.Mutable & class_364> VStackPanel addChild(T widget) {
        this.children.add(widget);
        this.drawables.add(widget);
        this.elements.add(widget);
        return this;
    }

    public <T extends class_4068 & Point.Mutable & class_364> T addChildIn(T widget) {
        this.addChild(widget);
        return widget;
    }

    public void clearChildren() {
        this.children.clear();
        this.drawables.clear();
        this.elements.clear();
    }
}

