/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.client.screen.auto;

import com.neep.meatlib.client.screen.auto.Anchor;
import com.neep.meatlib.client.screen.auto.Divide;
import com.neep.meatlib.client.screen.auto.Panel;
import com.neep.meatlib.client.screen.primitive.Point;
import com.neep.meatlib.client.screen.primitive.Rectangle;
import com.neep.meatlib.client.screen.widget.ClickableWidget;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import org.jetbrains.annotations.Nullable;

public class SplitPanel
extends Panel {
    private final Split split;
    private final int padding;
    @Nullable
    protected ClickableWidget left;
    @Nullable
    protected ClickableWidget right;
    private Divide divide = null;
    private float divideFraction = 0.5f;
    protected boolean centre;
    @Nullable
    protected Fit fit;
    private int separation = 0;

    public SplitPanel(Split split, int padding, @Nullable ClickableWidget left, @Nullable ClickableWidget right) {
        this.split = split;
        this.padding = padding;
        this.left = left;
        this.right = right;
    }

    public SplitPanel(Split split, int padding) {
        this(split, padding, null, null);
    }

    @Override
    public void init() {
        if (this.divide == null) {
            this.divide = new Divide.Rel(Anchor.START, this.divideFraction);
        }
        if (this.fit != null) {
            if (this.fit == Fit.FIRST) {
                this.divide = new Divide.Abs(Anchor.START, this.split.majorDimension(this.left));
            } else if (this.fit == Fit.SECOND) {
                this.divide = new Divide.Abs(Anchor.START, this.split.majorDimension(this) - this.split.majorDimension(this.right));
            }
        }
        int div = this.divide.amount(this.split.majorDimension(this));
        int leftPanelSize = div - this.padding - this.padding / 2;
        if (this.split == Split.HORIZONTAL) {
            int rightPanelSize = this.w - div - this.padding - this.padding / 2 - this.separation;
            if (this.left != null) {
                SplitPanel.setDims(this.left, this.x + this.padding, this.y + this.padding, leftPanelSize, this.h - 2 * this.padding);
                if (this.centre) {
                    this.left.setPos(this.left.x(), this.y + this.padding + (this.h() - 2 * this.padding - this.left.h()) / 2);
                }
            }
            if (this.right != null) {
                SplitPanel.setDims(this.right, this.x + this.padding + div + this.padding / 2 + this.separation, this.y + this.padding, rightPanelSize, this.h - 2 * this.padding);
                if (this.centre) {
                    this.right.setPos(this.right.x(), this.y + this.padding + (this.h() - 2 * this.padding - this.right.h()) / 2);
                }
            }
        } else {
            int rightPanelSize = this.h - div - this.padding - this.padding / 2 - this.separation;
            if (this.left != null) {
                SplitPanel.setDims(this.left, this.x + this.padding, this.y + this.padding, this.w - 2 * this.padding, leftPanelSize);
                if (this.centre) {
                    this.left.setPos(this.x + this.padding + (this.w() - 2 * this.padding - this.left.w()) / 2, this.left.y());
                }
            }
            if (this.right != null) {
                SplitPanel.setDims(this.right, this.x + this.padding, this.y + this.padding + div + this.padding / 2 + this.separation, this.w - 2 * this.padding, rightPanelSize);
                if (this.centre) {
                    this.right.setPos(this.x + this.padding + (this.w() - 2 * this.padding - this.right.w()) / 2, this.right.y());
                }
            }
        }
    }

    protected static void setDims(class_364 element, int x, int y, int w, int h, boolean centre) {
        if (element instanceof Rectangle.Mutable) {
            Rectangle.Mutable mutable = (Rectangle.Mutable)element;
            mutable.setDims(x, y, w, h);
        } else if (element instanceof Point.Mutable) {
            Point.Mutable mutable = (Point.Mutable)element;
            mutable.setPos(x, y);
        }
    }

    @Override
    protected List<class_4068> drawables() {
        ObjectArrayList drawables = new ObjectArrayList();
        if (this.left != null) {
            drawables.add(this.left);
        }
        if (this.right != null) {
            drawables.add(this.right);
        }
        return drawables;
    }

    @Override
    public List<class_364> method_25396() {
        ObjectArrayList drawables = new ObjectArrayList();
        if (this.left != null) {
            drawables.add(this.left);
        }
        if (this.right != null) {
            drawables.add(this.right);
        }
        return drawables;
    }

    @Override
    public int h() {
        if (this.split == Split.HORIZONTAL && this.h == 0) {
            return Math.max(this.left != null ? this.left.h() : 0, this.right != null ? this.right.h() : 0);
        }
        return super.h();
    }

    @Override
    public int w() {
        if (this.split == Split.VERTICAL && this.w == 0) {
            return Math.max(this.left != null ? this.left.w() : 0, this.right != null ? this.right.w() : 0);
        }
        return super.w();
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public SplitPanel setDivide(Divide divide) {
        this.divide = divide;
        return this;
    }

    public SplitPanel setFit(Fit fit) {
        this.fit = fit;
        return this;
    }

    public SplitPanel setLeft(@Nullable ClickableWidget left) {
        this.left = left;
        return this;
    }

    public SplitPanel setRight(@Nullable ClickableWidget right) {
        this.right = right;
        return this;
    }

    public SplitPanel centre(boolean centre) {
        this.centre = centre;
        return this;
    }

    public SplitPanel separation() {
        this.separation = 1;
        return this;
    }

    public static enum Split {
        HORIZONTAL,
        VERTICAL;


        public int majorDimension(Rectangle rectangle) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case VERTICAL -> rectangle.h();
                case HORIZONTAL -> rectangle.w();
            };
        }

        public int minorDimension(Rectangle rectangle) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case VERTICAL -> rectangle.w();
                case HORIZONTAL -> rectangle.h();
            };
        }
    }

    public static enum Fit {
        FIRST,
        SECOND;

    }
}

