/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.client.screen.auto;

import com.neep.meatlib.client.screen.auto.Panel;
import com.neep.meatlib.client.screen.primitive.Point;
import com.neep.meatlib.client.screen.primitive.Rectangle;
import java.util.List;
import net.minecraft.class_364;
import net.minecraft.class_4068;

public class SnapPanel<T extends Point.Mutable & Rectangle>
extends Panel {
    private final T widget;
    private final Snap snap;

    public SnapPanel(T widget) {
        this(Snap.MIDDLE, widget);
    }

    public SnapPanel(Snap snap, T widget) {
        this.widget = widget;
        this.snap = snap;
    }

    @Override
    public void init() {
        int mx = this.x + (this.w - ((Rectangle)this.widget).w()) / 2;
        int my = this.y + (this.h - ((Rectangle)this.widget).h()) / 2;
        int ww = ((Rectangle)this.widget).w();
        int wh = ((Rectangle)this.widget).h();
        switch (this.snap) {
            case MIDDLE: {
                SnapPanel.setDims((class_364)this.widget, mx, my, ww, wh);
                break;
            }
            case BOTTOM: {
                SnapPanel.setDims((class_364)this.widget, mx, this.y2() - wh, ww, wh);
                break;
            }
            case TOP: {
                SnapPanel.setDims((class_364)this.widget, mx, this.y(), ww, wh);
                break;
            }
            case LEFT: {
                SnapPanel.setDims((class_364)this.widget, this.x(), my, ww, wh);
                break;
            }
            case RIGHT: {
                SnapPanel.setDims((class_364)this.widget, this.x2() - ww, my, ww, wh);
            }
        }
    }

    @Override
    protected List<class_4068> drawables() {
        T t = this.widget;
        if (t instanceof class_4068) {
            class_4068 drawable = (class_4068)t;
            return List.of(drawable);
        }
        return List.of();
    }

    @Override
    public List<class_364> method_25396() {
        return List.of((class_364)this.widget);
    }

    @Override
    public int w() {
        return Math.max(this.w, ((Rectangle)this.widget).w());
    }

    @Override
    public int h() {
        return Math.max(this.h, ((Rectangle)this.widget).h());
    }

    public static enum Snap {
        MIDDLE,
        TOP,
        RIGHT,
        BOTTOM,
        LEFT;

    }
}

