/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.attachment.player;

import com.google.common.collect.Maps;
import com.neep.meatlib.attachment.player.PlayerAttachment;
import java.util.Map;
import net.minecraft.class_1657;

public class PlayerAttachmentManager {
    private static final Map<String, PlayerAttachment.Factory> FACTORIES = Maps.newHashMap();
    protected final Map<String, PlayerAttachment> attachments = Maps.newHashMap();
    protected final class_1657 player;

    public PlayerAttachmentManager(class_1657 player) {
        this.player = player;
        FACTORIES.forEach((id, f) -> this.attachments.put((String)id, f.create(player)));
    }

    public void tick() {
        this.attachments.values().forEach(PlayerAttachment::tickAttachment);
    }

    public <T extends PlayerAttachment> T getAttachment(String id) {
        return (T)this.attachments.get(id);
    }

    protected void addAttachment(String id, PlayerAttachment attachment) {
        this.attachments.put(id, attachment);
    }

    public static void registerAttachment(String id, PlayerAttachment.Factory factory) {
        FACTORIES.put(id, factory);
    }

    public static void init() {
    }
}

