/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.api.network;

import com.neep.meatlib.api.network.ParamCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2540;

public class CompositeParamCodec<T>
implements ParamCodec<T> {
    private final Class<T> clazz;
    private final List<Function<T, ?>> getters;
    private final List<ParamCodec<?>> paramCodecs;
    private final Constructor<T> constructor;

    public CompositeParamCodec(Class<T> clazz, List<Function<T, ?>> getters, List<ParamCodec<?>> codecs) {
        assert (getters.size() == codecs.size());
        this.clazz = clazz;
        this.getters = getters;
        this.paramCodecs = codecs;
        Class[] parameters = (Class[])this.paramCodecs.stream().map(ParamCodec::clazz).toArray(Class[]::new);
        try {
            this.constructor = clazz.getConstructor(parameters);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Constructor not found in given class.");
        }
    }

    @Override
    public Class<T> clazz() {
        return this.clazz;
    }

    @Override
    public T decode(class_2540 buf) {
        Object[] arguments = new Object[this.paramCodecs.size()];
        for (int i = 0; i < this.paramCodecs.size(); ++i) {
            arguments[i] = this.paramCodecs.get(i).decode(buf);
        }
        try {
            return this.constructor.newInstance(arguments);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("This should probably not happen.");
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    @Override
    public void encode(T t, class_2540 buf) {
        for (int i = 0; i < this.paramCodecs.size(); ++i) {
            ParamCodec<?> codec = this.paramCodecs.get(i);
            codec.encode(this.getters.get(i).apply(t), buf);
        }
    }

    public static <T> Builder<T> builder(Class<T> clazz) {
        return new Builder<T>(clazz);
    }

    public static class Builder<T> {
        private final Class<T> clazz;
        private final List<Function<T, ?>> getters = new ObjectArrayList();
        private final List<ParamCodec<?>> codecs = new ObjectArrayList();

        private Builder(Class<T> clazz) {
            this.clazz = clazz;
        }

        public <T1> Builder<T> param(Function<T, T1> getter, ParamCodec<T1> codec) {
            this.getters.add(getter);
            this.codecs.add(codec);
            return this;
        }

        public CompositeParamCodec<T> build() {
            return new CompositeParamCodec<T>(this.clazz, this.getters, this.codecs);
        }
    }
}

