/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib;

import com.mojang.blaze3d.systems.RenderSystem;
import com.neep.meatlib.MeatLibRegistration;
import com.neep.meatlib.api.event.DataPackPostProcess;
import com.neep.meatlib.api.event.InitialTicks;
import com.neep.meatlib.graphics.GraphicsEffects;
import com.neep.meatlib.item.ScrollableItems;
import com.neep.meatlib.recipe.MeatlibRecipes;
import com.neep.meatlib.recipe.ingredient.RecipeInputs;
import com.neep.meatlib.registry.SoundRegistry;
import com.neep.meatlib.screen.ScreenReady;
import com.neep.meatlib.storage.StorageEvents;
import com.neep.meatlib.util.MeatlibItemGroups;
import com.neep.meatlib.util.ValkyrienSkiesUtil;
import com.neep.neepbus.NeepBus;
import com.neep.neepmeat.util.MinecraftServerAccess;
import java.util.HashSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class MeatLib
implements ModInitializer {
    public static final String NAMESPACE = "meatlib";
    public static final Logger LOGGER = LogManager.getLogger((String)"meatlib");
    public static String CURRENT_NAMESPACE;
    public static final String FLOAT_REGEX = "[+-]?([0-9]*[.])?[0-9]+";
    @Nullable
    public static ValkyrienSkiesUtil vsUtil;
    public static BlockApiLookup<Void, Void> VOID_LOOKUP;

    public static void assertActive(Object object) {
        if (CURRENT_NAMESPACE == null) {
            throw new IllegalStateException("MeatLib: Object '" + String.valueOf(object) + "' was queued for registration without a namespace");
        }
    }

    public static String formatEngineering(double value, int dp, boolean usePrefix, String unit) {
        if (value == 0.0) {
            return String.format("%." + dp + "f%s", 0.0, unit);
        }
        double log10 = Math.log10(Math.abs(value));
        int threes = (int)Math.floor(log10 / 3.0);
        value /= Math.pow(10.0, threes * 3);
        int idx = threes + 5;
        if (usePrefix && idx > 0 && idx < NeepBus.METRIC_PREFIXES.length) {
            return String.format("%." + dp + "f%s%s", value, NeepBus.METRIC_PREFIXES[idx], unit);
        }
        return String.format("%." + dp + "fE%d%s", value, threes * 3, unit);
    }

    public void onInitialize() {
        MinecraftServerAccess.init();
        SoundRegistry.init();
        GraphicsEffects.init();
        MeatlibRecipes.init();
        InitialTicks.init();
        StorageEvents.init();
        RecipeInputs.init();
        MeatlibItemGroups.init();
        ScrollableItems.init();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> ((DataPackPostProcess)DataPackPostProcess.AFTER_DATA_PACK_LOAD.invoker()).event(server));
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, manager, success) -> ((DataPackPostProcess)DataPackPostProcess.AFTER_DATA_PACK_LOAD.invoker()).event(server));
        DataPackPostProcess.AFTER_DATA_PACK_LOAD.register(DataPackPostProcess.END, server -> ((DataPackPostProcess.SyncToPlayers)DataPackPostProcess.SYNC.invoker()).sync(server, new HashSet<class_3222>(server.method_3760().method_14571())));
        if (FabricLoader.getInstance().isModLoaded("valkyrienskies")) {
            vsUtil = new ValkyrienSkiesUtil();
        }
        MeatLibRegistration.flush();
        ScreenReady.init();
    }

    public static boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT && RenderSystem.isOnRenderThread();
    }

    static {
        vsUtil = null;
        VOID_LOOKUP = BlockApiLookup.get((class_2960)new class_2960("neepmeat", "sided_void"), Void.class, Void.class);
    }
}

