/*
 * Decompiled with CFR 0.152.
 */
package com.akuleshov7.ktoml.tree.nodes;

import com.akuleshov7.ktoml.TomlInputConfig;
import com.akuleshov7.ktoml.exceptions.ParseException;
import com.akuleshov7.ktoml.parsers.StringUtilsKt;
import com.akuleshov7.ktoml.tree.nodes.pairs.values.TomlArray;
import com.akuleshov7.ktoml.tree.nodes.pairs.values.TomlBasicString;
import com.akuleshov7.ktoml.tree.nodes.pairs.values.TomlBoolean;
import com.akuleshov7.ktoml.tree.nodes.pairs.values.TomlDateTime;
import com.akuleshov7.ktoml.tree.nodes.pairs.values.TomlDouble;
import com.akuleshov7.ktoml.tree.nodes.pairs.values.TomlLiteralString;
import com.akuleshov7.ktoml.tree.nodes.pairs.values.TomlLong;
import com.akuleshov7.ktoml.tree.nodes.pairs.values.TomlNull;
import com.akuleshov7.ktoml.tree.nodes.pairs.values.TomlUnsignedLong;
import com.akuleshov7.ktoml.tree.nodes.pairs.values.TomlValue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001a\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t\u001a(\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u000b*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\t\u001a\u001a\u0010\f\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t\u001aA\u0010\r\u001a\u0004\u0018\u00010\u0004\"\n\b\u0000\u0010\u000e\u0018\u0001*\u00020\u000f*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u001c\u0010\u0010\u001a\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001j\u0002`\u0011H\u0082\b\u001a.\u0010\u0012\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0003H\u0002*0\b\u0002\u0010\u0000\"\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001\u00a8\u0006\u0015"}, d2={"ValueCreator", "Lkotlin/Function2;", "", "", "Lcom/akuleshov7/ktoml/tree/nodes/pairs/values/TomlValue;", "parseList", "Lcom/akuleshov7/ktoml/tree/nodes/pairs/values/TomlArray;", "lineNo", "config", "Lcom/akuleshov7/ktoml/TomlInputConfig;", "splitKeyValue", "Lkotlin/Pair;", "parseValue", "tryParseValue", "E", "", "transform", "Lcom/akuleshov7/ktoml/tree/nodes/ValueCreator;", "checkNotEmpty", "log", "content", "ktoml-core"})
@SourceDebugExtension(value={"SMAP\nTomlKeyValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TomlKeyValue.kt\ncom/akuleshov7/ktoml/tree/nodes/TomlKeyValueKt\n*L\n1#1,178:1\n153#1,5:179\n153#1,5:184\n153#1,5:189\n153#1,5:194\n*S KotlinDebug\n*F\n+ 1 TomlKeyValue.kt\ncom/akuleshov7/ktoml/tree/nodes/TomlKeyValueKt\n*L\n142#1:179,5\n143#1:184,5\n144#1:189,5\n145#1:194,5\n*E\n"})
public final class TomlKeyValueKt {
    @NotNull
    public static final TomlArray parseList(@NotNull String $this$parseList, int lineNo, @NotNull TomlInputConfig config) {
        Intrinsics.checkNotNullParameter((Object)$this$parseList, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return new TomlArray($this$parseList, lineNo, config);
    }

    @NotNull
    public static final Pair<String, String> splitKeyValue(@NotNull String $this$splitKeyValue, int lineNo, @NotNull TomlInputConfig config) {
        Intrinsics.checkNotNullParameter((Object)$this$splitKeyValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        String pair = StringUtilsKt.takeBeforeComment($this$splitKeyValue, config.getAllowEscapedQuotesInLiteralStrings());
        int firstEqualsSign = StringUtilsKt.indexOfNextOutsideQuotes$default(pair, config.getAllowEscapedQuotesInLiteralStrings(), '=', 0, 4, null);
        if (firstEqualsSign == -1) {
            throw new ParseException("Incorrect format of Key-Value pair (missing equals sign). Should be <key = value>, but was: " + $this$splitKeyValue + ". If you wanted to define table - use brackets []", lineNo);
        }
        String string = pair.substring(0, firstEqualsSign);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String key = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String string2 = pair.substring(firstEqualsSign + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String value = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        return new Pair((Object)TomlKeyValueKt.checkNotEmpty(key, "key", $this$splitKeyValue, config, lineNo), (Object)TomlKeyValueKt.checkNotEmpty(value, "value", $this$splitKeyValue, config, lineNo));
    }

    public static /* synthetic */ Pair splitKeyValue$default(String string, int n, TomlInputConfig tomlInputConfig, int n2, Object object) {
        if ((n2 & 2) != 0) {
            tomlInputConfig = new TomlInputConfig(false, false, false, false, false, false, 63, null);
        }
        return TomlKeyValueKt.splitKeyValue(string, n, tomlInputConfig);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final TomlValue parseValue(@NotNull String $this$parseValue, int lineNo, @NotNull TomlInputConfig config) {
        TomlValue tomlValue;
        Intrinsics.checkNotNullParameter((Object)$this$parseValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        block22 : switch ($this$parseValue) {
            case "inf": 
            case "+inf": {
                tomlValue = new TomlDouble(Double.POSITIVE_INFINITY);
                break;
            }
            case "-inf": {
                tomlValue = new TomlDouble(Double.NEGATIVE_INFINITY);
                break;
            }
            case "+NaN": 
            case "+nan": 
            case "-nan": 
            case "nan": 
            case "NaN": 
            case "-NaN": {
                tomlValue = new TomlDouble(Double.NaN);
                break;
            }
            case "": 
            case "NULL": 
            case "nil": 
            case "NIL": 
            case "null": {
                if (!config.getAllowNullValues()) {
                    throw new ParseException("Null values are not allowed", lineNo);
                }
                tomlValue = new TomlNull();
                break;
            }
            case "false": 
            case "true": {
                tomlValue = new TomlBoolean($this$parseValue, lineNo);
                break;
            }
            default: {
                TomlValue tomlValue2;
                TomlValue p04;
                TomlValue p022;
                TomlValue p032;
                switch (StringsKt.first((CharSequence)$this$parseValue)) {
                    case '\'': {
                        tomlValue = new TomlLiteralString($this$parseValue, lineNo, config);
                        break block22;
                    }
                    case '\"': {
                        tomlValue = new TomlBasicString($this$parseValue, lineNo);
                        break block22;
                    }
                }
                String string = $this$parseValue;
                int lineNo$iv22 = lineNo;
                boolean $i$f$tryParseValue = false;
                try {
                    void p1;
                    void $this$tryParseValue$iv;
                    int n = lineNo$iv22;
                    p032 = $this$tryParseValue$iv;
                    boolean bl = false;
                    p032 = new TomlLong((String)((Object)p032), (int)p1);
                }
                catch (Throwable e$iv) {
                    if (!(e$iv instanceof NumberFormatException)) {
                        throw e$iv;
                    }
                    p032 = null;
                }
                TomlValue tomlValue3 = p032;
                tomlValue = tomlValue3;
                if (tomlValue3 != null) break;
                String lineNo$iv22 = $this$parseValue;
                int lineNo$iv32 = lineNo;
                boolean $i$f$tryParseValue2 = false;
                try {
                    void p1;
                    void $this$tryParseValue$iv;
                    int p032 = lineNo$iv32;
                    p022 = $this$tryParseValue$iv;
                    boolean bl = false;
                    p022 = new TomlUnsignedLong((String)((Object)p022), (int)p1);
                }
                catch (Throwable e$iv) {
                    if (!(e$iv instanceof NumberFormatException)) {
                        throw e$iv;
                    }
                    p022 = null;
                }
                TomlValue tomlValue4 = p022;
                tomlValue = tomlValue4;
                if (tomlValue4 != null) break;
                String lineNo$iv32 = $this$parseValue;
                int lineNo$iv42 = lineNo;
                boolean $i$f$tryParseValue3 = false;
                try {
                    void p1;
                    void $this$tryParseValue$iv;
                    int p022 = lineNo$iv42;
                    p04 = $this$tryParseValue$iv;
                    boolean bl = false;
                    p04 = new TomlDouble((String)((Object)p04), (int)p1);
                }
                catch (Throwable e$iv) {
                    if (!(e$iv instanceof NumberFormatException)) {
                        throw e$iv;
                    }
                    p04 = null;
                }
                TomlValue tomlValue5 = p04;
                tomlValue = tomlValue5;
                if (tomlValue5 != null) break;
                String lineNo$iv42 = $this$parseValue;
                int lineNo$iv = lineNo;
                boolean $i$f$tryParseValue4 = false;
                try {
                    void p1;
                    void $this$tryParseValue$iv;
                    int p04 = lineNo$iv;
                    void p05 = $this$tryParseValue$iv;
                    boolean bl = false;
                    tomlValue2 = new TomlDateTime((String)p05, (int)p1);
                }
                catch (Throwable e$iv) {
                    if (!(e$iv instanceof IllegalArgumentException)) {
                        throw e$iv;
                    }
                    tomlValue2 = null;
                }
                TomlValue tomlValue6 = tomlValue2;
                tomlValue = tomlValue6;
                if (tomlValue6 != null) break;
                tomlValue = new TomlBasicString($this$parseValue, lineNo);
            }
        }
        return tomlValue;
    }

    private static final /* synthetic */ <E extends Throwable> TomlValue tryParseValue(String $this$tryParseValue, int lineNo, Function2<? super String, ? super Integer, ? extends TomlValue> transform) {
        TomlValue tomlValue;
        boolean $i$f$tryParseValue = false;
        try {
            tomlValue = (TomlValue)transform.invoke((Object)$this$tryParseValue, (Object)lineNo);
        }
        catch (Throwable e) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"E");
            if (!(e instanceof Throwable)) {
                throw e;
            }
            tomlValue = null;
        }
        return tomlValue;
    }

    private static final String checkNotEmpty(String $this$checkNotEmpty, String log, String content, TomlInputConfig config, int lineNo) {
        String string;
        String it = string = $this$checkNotEmpty;
        boolean bl = false;
        if ((!config.getAllowEmptyValues() || Intrinsics.areEqual((Object)log, (Object)"key")) && StringsKt.isBlank((CharSequence)it)) {
            throw new ParseException("Incorrect format of Key-Value pair. It has empty " + log + ": " + content, lineNo);
        }
        return string;
    }

    static /* synthetic */ String checkNotEmpty$default(String string, String string2, String string3, TomlInputConfig tomlInputConfig, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            tomlInputConfig = new TomlInputConfig(false, false, false, false, false, false, 63, null);
        }
        return TomlKeyValueKt.checkNotEmpty(string, string2, string3, tomlInputConfig, n);
    }
}

