/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.config;

import io.github.fabricators_of_create.porting_lib.config.ConfigTracker;
import io.github.fabricators_of_create.porting_lib.config.ConfigType;
import io.github.fabricators_of_create.porting_lib.config.ModConfig;
import io.github.fabricators_of_create.porting_lib.config.ModConfigSpec;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class ConfigRegistry {
    protected static final Map<String, EnumMap<ConfigType, ModConfig>> configs = new HashMap<String, EnumMap<ConfigType, ModConfig>>();

    public static void registerConfig(String modId, ConfigType type, ModConfigSpec spec) {
        if (spec.isEmpty()) {
            ConfigTracker.LOGGER.debug("Attempted to register an empty config for type {} on mod {}", (Object)type, (Object)modId);
            return;
        }
        configs.computeIfAbsent(modId, s -> new EnumMap(ConfigType.class)).put(type, new ModConfig(type, spec, modId));
    }

    public static void registerConfig(String modId, ConfigType type, ModConfigSpec spec, String fileName) {
        if (spec.isEmpty()) {
            ConfigTracker.LOGGER.debug("Attempted to register an empty config for type {} on mod {} using file name {}", new Object[]{type, modId, fileName});
            return;
        }
        configs.computeIfAbsent(modId, s -> new EnumMap(ConfigType.class)).put(type, new ModConfig(type, spec, modId, fileName));
    }

    public static Map<String, EnumMap<ConfigType, ModConfig>> getConfigs() {
        return configs;
    }
}

