/*
 * Decompiled with CFR 0.152.
 */
package f_baritone.utils;

import f_baritone.api.IBaritone;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1831;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2248;
import net.minecraft.class_2680;

public class ToolSet {
    private final Map<class_2248, Double> breakStrengthCache = new HashMap<class_2248, Double>();
    private final Function<class_2248, Double> backendCalculation;
    private final class_1657 player;
    private final IBaritone baritone;

    public ToolSet(class_1657 player) {
        this.player = player;
        this.baritone = (IBaritone)IBaritone.KEY.get((Object)player);
        if (this.baritone.settings().considerPotionEffects.get().booleanValue()) {
            double amplifier = this.potionAmplifier();
            Function<Double, Double> amplify = x -> amplifier * x;
            this.backendCalculation = amplify.compose(this::getBestDestructionTime);
        } else {
            this.backendCalculation = this::getBestDestructionTime;
        }
    }

    public double getStrVsBlock(class_2680 state) {
        return this.breakStrengthCache.computeIfAbsent(state.method_26204(), this.backendCalculation);
    }

    private int getMaterialCost(class_1799 itemStack) {
        return itemStack.method_7909() instanceof class_1831 ? 1 : -1;
    }

    public boolean hasSilkTouch(class_1799 stack) {
        return class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)stack) > 0;
    }

    public int getBestSlot(class_2248 b, boolean preferSilkTouch) {
        return this.getBestSlot(b, preferSilkTouch, false);
    }

    public int getBestSlot(class_2248 b, boolean preferSilkTouch, boolean pathingCalculation) {
        if (this.baritone.settings().disableAutoTool.get().booleanValue() && pathingCalculation) {
            return this.player.method_31548().field_7545;
        }
        int best = 0;
        double highestSpeed = Double.NEGATIVE_INFINITY;
        int lowestCost = Integer.MIN_VALUE;
        boolean bestSilkTouch = false;
        class_2680 blockState = b.method_9564();
        for (int i = 0; i < 9; ++i) {
            int cost;
            class_1799 itemStack = this.player.method_31548().method_5438(i);
            if (!this.baritone.settings().useSwordToMine.get().booleanValue() && itemStack.method_7909() instanceof class_1829 || this.baritone.settings().itemSaver.get().booleanValue() && itemStack.method_7919() >= itemStack.method_7936() && itemStack.method_7936() > 1) continue;
            double speed = ToolSet.calculateSpeedVsBlock(itemStack, blockState);
            boolean silkTouch = this.hasSilkTouch(itemStack);
            if (speed > highestSpeed) {
                highestSpeed = speed;
                best = i;
                lowestCost = this.getMaterialCost(itemStack);
                bestSilkTouch = silkTouch;
                continue;
            }
            if (speed != highestSpeed || ((cost = this.getMaterialCost(itemStack)) >= lowestCost || !silkTouch && bestSilkTouch) && (!preferSilkTouch || bestSilkTouch || !silkTouch)) continue;
            highestSpeed = speed;
            best = i;
            lowestCost = cost;
            bestSilkTouch = silkTouch;
        }
        return best;
    }

    private double getBestDestructionTime(class_2248 b) {
        class_1799 stack = this.player.method_31548().method_5438(this.getBestSlot(b, false, true));
        return ToolSet.calculateSpeedVsBlock(stack, b.method_9564()) * this.avoidanceMultiplier(b);
    }

    private double avoidanceMultiplier(class_2248 b) {
        return 0.0;
    }

    public static double calculateSpeedVsBlock(class_1799 item, class_2680 state) {
        int effLevel;
        float hardness = state.method_26214(null, null);
        if (hardness < 0.0f) {
            return -1.0;
        }
        float speed = item.method_7924(state);
        if (speed > 1.0f && (effLevel = class_1890.method_8225((class_1887)class_1893.field_9131, (class_1799)item)) > 0 && !item.method_7960()) {
            speed += (float)(effLevel * effLevel + 1);
        }
        speed /= hardness;
        if (!state.method_29291() || !item.method_7960() && item.method_7951(state)) {
            return speed / 30.0f;
        }
        return speed / 100.0f;
    }

    private double potionAmplifier() {
        class_1293 fatigueEffect;
        double speed = 1.0;
        class_1293 hasteEffect = this.player.method_6112(class_1294.field_5917);
        if (hasteEffect != null) {
            speed *= 1.0 + (double)(hasteEffect.method_5578() + 1) * 0.2;
        }
        if ((fatigueEffect = this.player.method_6112(class_1294.field_5901)) != null) {
            switch (fatigueEffect.method_5578()) {
                case 0: {
                    speed *= 0.3;
                    break;
                }
                case 1: {
                    speed *= 0.09;
                    break;
                }
                case 2: {
                    speed *= 0.0027;
                    break;
                }
                default: {
                    speed *= 8.1E-4;
                }
            }
        }
        return speed;
    }
}

