/*
 * Decompiled with CFR 0.152.
 */
package f_baritone.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import f_baritone.Automatone;
import f_baritone.api.pathing.goals.Goal;
import f_baritone.api.pathing.goals.GoalComposite;
import f_baritone.api.pathing.goals.GoalGetToBlock;
import f_baritone.api.pathing.goals.GoalInverted;
import f_baritone.api.pathing.goals.GoalTwoBlocks;
import f_baritone.api.pathing.goals.GoalXZ;
import f_baritone.api.pathing.goals.GoalYLevel;
import f_baritone.api.utils.interfaces.IGoalRenderPos;
import f_baritone.render.ClientPathingBehaviour;
import f_baritone.render.RenderedPath;
import f_baritone.utils.IRenderer;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_822;
import org.lwjgl.opengl.GL11;

public final class PathRenderer
implements IRenderer {
    private static final class_2960 TEXTURE_BEACON_BEAM = new class_2960("textures/entity/beacon_beam.png");

    private PathRenderer() {
    }

    public static double posX() {
        return PathRenderer.renderManager.field_4686.method_19326().field_1352;
    }

    public static double posY() {
        return PathRenderer.renderManager.field_4686.method_19326().field_1351;
    }

    public static double posZ() {
        return PathRenderer.renderManager.field_4686.method_19326().field_1350;
    }

    public static void render(WorldRenderContext event, ClientPathingBehaviour behavior) {
        class_1937 world;
        class_2874 currentRenderViewDimension;
        float partialTicks = event.tickDelta();
        Goal goal = behavior.getGoal();
        class_310 mc = class_310.method_1551();
        class_2874 thisPlayerDimension = behavior.entity.method_37908().method_8597();
        if (thisPlayerDimension != (currentRenderViewDimension = (world = (class_1937)Objects.requireNonNull(class_310.method_1551().field_1687)).method_8597())) {
            return;
        }
        class_1297 renderView = mc.method_1560();
        if (renderView.method_37908() != world) {
            Automatone.LOGGER.error("I have no idea what's going on");
            Automatone.LOGGER.error("The primary baritone is in a different world than the render view entity");
            Automatone.LOGGER.error("Not rendering the path");
            return;
        }
        if (goal != null && PathRenderer.settings.renderGoal.get().booleanValue()) {
            PathRenderer.drawDankLitGoalBox(event.matrixStack(), renderView, goal, partialTicks, PathRenderer.settings.colorGoalBox.get());
        }
        if (!PathRenderer.settings.renderPath.get().booleanValue()) {
            return;
        }
        RenderedPath current = behavior.getCurrent();
        RenderedPath next = behavior.getNext();
        if (current != null && PathRenderer.settings.renderSelectionBoxes.get().booleanValue()) {
            PathRenderer.drawManySelectionBoxes(renderView, current.toBreak(), PathRenderer.settings.colorBlocksToBreak.get());
            PathRenderer.drawManySelectionBoxes(renderView, current.toPlace(), PathRenderer.settings.colorBlocksToPlace.get());
            PathRenderer.drawManySelectionBoxes(renderView, current.toWalkInto(), PathRenderer.settings.colorBlocksToWalkInto.get());
        }
        if (current != null && current.pathPositions() != null) {
            int renderBegin = Math.max(current.getPosition() - 3, 0);
            PathRenderer.drawPath(current.pathPositions(), renderBegin, PathRenderer.settings.colorCurrentPath.get(), PathRenderer.settings.fadePath.get(), 10, 20);
        }
        if (next != null && next.pathPositions() != null) {
            PathRenderer.drawPath(next.pathPositions(), 0, PathRenderer.settings.colorNextPath.get(), PathRenderer.settings.fadePath.get(), 10, 20);
        }
        behavior.getInProgress().ifPresent(currentlyRunning -> {
            currentlyRunning.bestPathSoFar().ifPresent(p -> PathRenderer.drawPath(p.positions(), 0, PathRenderer.settings.colorBestPathSoFar.get(), PathRenderer.settings.fadePath.get(), 10, 20));
            currentlyRunning.pathToMostRecentNodeConsidered().ifPresent(mr -> {
                PathRenderer.drawPath(mr.positions(), 0, PathRenderer.settings.colorMostRecentConsidered.get(), PathRenderer.settings.fadePath.get(), 10, 20);
                PathRenderer.drawManySelectionBoxes(renderView, Collections.singletonList(mr.getDest()), PathRenderer.settings.colorMostRecentConsidered.get());
            });
        });
    }

    public static void drawPath(List<? extends class_2338> positions, int startIndex, Color color, boolean fadeOut, int fadeStart0, int fadeEnd0) {
        IRenderer.startLines(color, PathRenderer.settings.pathRenderLineWidthPixels.get().floatValue(), PathRenderer.settings.renderPathIgnoreDepth.get());
        int fadeStart = fadeStart0 + startIndex;
        int fadeEnd = fadeEnd0 + startIndex;
        int i = startIndex;
        while (i < positions.size() - 1) {
            class_2338 start = positions.get(i);
            int next = i + 1;
            class_2338 end = positions.get(next);
            int dirX = end.method_10263() - start.method_10263();
            int dirY = end.method_10264() - start.method_10264();
            int dirZ = end.method_10260() - start.method_10260();
            while (!(next + 1 >= positions.size() || fadeOut && next + 1 >= fadeStart || dirX != positions.get(next + 1).method_10263() - end.method_10263() || dirY != positions.get(next + 1).method_10264() - end.method_10264() || dirZ != positions.get(next + 1).method_10260() - end.method_10260())) {
                end = positions.get(++next);
            }
            if (fadeOut) {
                float alpha;
                if (i <= fadeStart) {
                    alpha = 0.4f;
                } else {
                    if (i > fadeEnd) break;
                    alpha = 0.4f * (1.0f - (float)(i - fadeStart) / (float)(fadeEnd - fadeStart));
                }
                IRenderer.glColor(color, alpha);
            }
            PathRenderer.drawLine(start.method_10263(), start.method_10264(), start.method_10260(), end.method_10263(), end.method_10264(), end.method_10260());
            tessellator.method_1350();
            i = next;
        }
        IRenderer.endLines(PathRenderer.settings.renderPathIgnoreDepth.get());
    }

    public static void drawLine(double x1, double y1, double z1, double x2, double y2, double z2) {
        double vpX = PathRenderer.posX();
        double vpY = PathRenderer.posY();
        double vpZ = PathRenderer.posZ();
        boolean renderPathAsFrickinThingy = PathRenderer.settings.renderPathAsLine.get() == false;
        buffer.method_1328(renderPathAsFrickinThingy ? class_293.class_5596.field_29345 : class_293.class_5596.field_29344, class_290.field_1576);
        buffer.method_22912((double)((float)(x1 + 0.5 - vpX)), (double)((float)(y1 + 0.5 - vpY)), (double)((float)(z1 + 0.5 - vpZ))).method_22915(IRenderer.State.red, IRenderer.State.green, IRenderer.State.blue, IRenderer.State.alpha).method_1344();
        buffer.method_22912((double)((float)(x2 + 0.5 - vpX)), (double)((float)(y2 + 0.5 - vpY)), (double)((float)(z2 + 0.5 - vpZ))).method_22915(IRenderer.State.red, IRenderer.State.green, IRenderer.State.blue, IRenderer.State.alpha).method_1344();
        if (renderPathAsFrickinThingy) {
            buffer.method_22912((double)((float)(x2 + 0.5 - vpX)), (double)((float)(y2 + 0.53 - vpY)), (double)((float)(z2 + 0.5 - vpZ))).method_22915(IRenderer.State.red, IRenderer.State.green, IRenderer.State.blue, IRenderer.State.alpha).method_1344();
            buffer.method_22912((double)((float)(x1 + 0.5 - vpX)), (double)((float)(y1 + 0.53 - vpY)), (double)((float)(z1 + 0.5 - vpZ))).method_22915(IRenderer.State.red, IRenderer.State.green, IRenderer.State.blue, IRenderer.State.alpha).method_1344();
            buffer.method_22912((double)((float)(x1 + 0.5 - vpX)), (double)((float)(y1 + 0.5 - vpY)), (double)((float)(z1 + 0.5 - vpZ))).method_22915(IRenderer.State.red, IRenderer.State.green, IRenderer.State.blue, IRenderer.State.alpha).method_1344();
        }
    }

    public static void drawManySelectionBoxes(class_1297 player, Collection<class_2338> positions, Color color) {
        IRenderer.startLines(color, PathRenderer.settings.pathRenderLineWidthPixels.get().floatValue(), PathRenderer.settings.renderSelectionBoxesIgnoreDepth.get());
        positions.forEach(pos -> {
            class_2680 state = player.method_37908().method_8320(pos);
            class_265 shape = state.method_26218((class_1922)player.method_37908(), pos);
            class_238 toDraw = shape.method_1110() ? class_259.method_1077().method_1107() : shape.method_1107();
            toDraw = toDraw.method_996(pos);
            IRenderer.drawAABB(toDraw, 0.002);
        });
        IRenderer.endLines(PathRenderer.settings.renderSelectionBoxesIgnoreDepth.get());
    }

    public static void drawDankLitGoalBox(class_4587 stack, class_1297 player, Goal goal, float partialTicks, Color color) {
        double maxY;
        double minY;
        double y2;
        double y1;
        double maxZ;
        double minZ;
        double maxX;
        double minX;
        double renderPosX = PathRenderer.posX();
        double renderPosY = PathRenderer.posY();
        double renderPosZ = PathRenderer.posZ();
        double y = class_3532.method_15362((float)((float)((double)((float)(System.nanoTime() / 100000L % 20000L) / 20000.0f) * Math.PI * 2.0)));
        if (goal instanceof IGoalRenderPos) {
            class_2338 goalPos = ((IGoalRenderPos)((Object)goal)).getGoalPos();
            minX = (double)goalPos.method_10263() + 0.002 - renderPosX;
            maxX = (double)(goalPos.method_10263() + 1) - 0.002 - renderPosX;
            minZ = (double)goalPos.method_10260() + 0.002 - renderPosZ;
            maxZ = (double)(goalPos.method_10260() + 1) - 0.002 - renderPosZ;
            if (goal instanceof GoalGetToBlock || goal instanceof GoalTwoBlocks) {
                y /= 2.0;
            }
            y1 = 1.0 + y + (double)goalPos.method_10264() - renderPosY;
            y2 = 1.0 - y + (double)goalPos.method_10264() - renderPosY;
            minY = (double)goalPos.method_10264() - renderPosY;
            maxY = minY + 2.0;
            if (goal instanceof GoalGetToBlock || goal instanceof GoalTwoBlocks) {
                y1 -= 0.5;
                y2 -= 0.5;
                maxY -= 1.0;
            }
        } else if (goal instanceof GoalXZ) {
            GoalXZ goalPos = (GoalXZ)goal;
            if (PathRenderer.settings.renderGoalXZBeacon.get().booleanValue()) {
                GL11.glPushAttrib((int)64);
                class_310.method_1551().method_1531().method_22813(TEXTURE_BEACON_BEAM);
                if (PathRenderer.settings.renderGoalIgnoreDepth.get().booleanValue()) {
                    RenderSystem.disableDepthTest();
                }
                stack.method_22903();
                stack.method_22904((double)goalPos.getX() - renderPosX, -renderPosY, (double)goalPos.getZ() - renderPosZ);
                class_822.method_3545((class_4587)stack, (class_4597)class_310.method_1551().method_22940().method_23000(), (class_2960)TEXTURE_BEACON_BEAM, (float)partialTicks, (float)1.0f, (long)player.method_37908().method_8510(), (int)0, (int)player.method_37908().method_31605(), (float[])color.getColorComponents(null), (float)0.2f, (float)0.25f);
                stack.method_22909();
                if (PathRenderer.settings.renderGoalIgnoreDepth.get().booleanValue()) {
                    RenderSystem.enableDepthTest();
                }
                GL11.glPopAttrib();
                return;
            }
            minX = (double)goalPos.getX() + 0.002 - renderPosX;
            maxX = (double)(goalPos.getX() + 1) - 0.002 - renderPosX;
            minZ = (double)goalPos.getZ() + 0.002 - renderPosZ;
            maxZ = (double)(goalPos.getZ() + 1) - 0.002 - renderPosZ;
            y1 = 0.0;
            y2 = 0.0;
            minY = 0.0 - renderPosY;
            maxY = (double)player.method_37908().method_31605() - renderPosY;
        } else {
            if (goal instanceof GoalComposite) {
                for (Goal g : ((GoalComposite)goal).goals()) {
                    PathRenderer.drawDankLitGoalBox(stack, player, g, partialTicks, color);
                }
                return;
            }
            if (goal instanceof GoalInverted) {
                PathRenderer.drawDankLitGoalBox(stack, player, ((GoalInverted)goal).origin, partialTicks, PathRenderer.settings.colorInvertedGoalBox.get());
                return;
            }
            if (goal instanceof GoalYLevel) {
                GoalYLevel goalpos = (GoalYLevel)goal;
                minX = player.method_23317() - PathRenderer.settings.yLevelBoxSize.get() - renderPosX;
                minZ = player.method_23321() - PathRenderer.settings.yLevelBoxSize.get() - renderPosZ;
                maxX = player.method_23317() + PathRenderer.settings.yLevelBoxSize.get() - renderPosX;
                maxZ = player.method_23321() + PathRenderer.settings.yLevelBoxSize.get() - renderPosZ;
                minY = (double)((GoalYLevel)goal).level - renderPosY;
                maxY = minY + 2.0;
                y1 = 1.0 + y + (double)goalpos.level - renderPosY;
                y2 = 1.0 - y + (double)goalpos.level - renderPosY;
            } else {
                return;
            }
        }
        IRenderer.startLines(color, PathRenderer.settings.goalRenderLineWidthPixels.get().floatValue(), PathRenderer.settings.renderGoalIgnoreDepth.get());
        PathRenderer.renderHorizontalQuad(minX, maxX, minZ, maxZ, y1);
        PathRenderer.renderHorizontalQuad(minX, maxX, minZ, maxZ, y2);
        buffer.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
        buffer.method_22912((double)((float)minX), (double)((float)minY), (double)((float)minZ)).method_22915(IRenderer.State.red, IRenderer.State.green, IRenderer.State.blue, IRenderer.State.alpha).method_1344();
        buffer.method_22912((double)((float)minX), (double)((float)maxY), (double)((float)minZ)).method_22915(IRenderer.State.red, IRenderer.State.green, IRenderer.State.blue, IRenderer.State.alpha).method_1344();
        buffer.method_22912((double)((float)maxX), (double)((float)minY), (double)((float)minZ)).method_22915(IRenderer.State.red, IRenderer.State.green, IRenderer.State.blue, IRenderer.State.alpha).method_1344();
        buffer.method_22912((double)((float)maxX), (double)((float)maxY), (double)((float)minZ)).method_22915(IRenderer.State.red, IRenderer.State.green, IRenderer.State.blue, IRenderer.State.alpha).method_1344();
        buffer.method_22912((double)((float)maxX), (double)((float)minY), (double)((float)maxZ)).method_22915(IRenderer.State.red, IRenderer.State.green, IRenderer.State.blue, IRenderer.State.alpha).method_1344();
        buffer.method_22912((double)((float)maxX), (double)((float)maxY), (double)((float)maxZ)).method_22915(IRenderer.State.red, IRenderer.State.green, IRenderer.State.blue, IRenderer.State.alpha).method_1344();
        buffer.method_22912((double)((float)minX), (double)((float)minY), (double)((float)maxZ)).method_22915(IRenderer.State.red, IRenderer.State.green, IRenderer.State.blue, IRenderer.State.alpha).method_1344();
        buffer.method_22912((double)((float)minX), (double)((float)maxY), (double)((float)maxZ)).method_22915(IRenderer.State.red, IRenderer.State.green, IRenderer.State.blue, IRenderer.State.alpha).method_1344();
        tessellator.method_1350();
        IRenderer.endLines(PathRenderer.settings.renderGoalIgnoreDepth.get());
    }

    private static void renderHorizontalQuad(double minX, double maxX, double minZ, double maxZ, double y) {
        if (y != 0.0) {
            buffer.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
            buffer.method_22912((double)((float)minX), (double)((float)y), (double)((float)minZ)).method_22915(IRenderer.State.red, IRenderer.State.green, IRenderer.State.blue, IRenderer.State.alpha).method_1344();
            buffer.method_22912((double)((float)maxX), (double)((float)y), (double)((float)minZ)).method_22915(IRenderer.State.red, IRenderer.State.green, IRenderer.State.blue, IRenderer.State.alpha).method_1344();
            buffer.method_22912((double)((float)maxX), (double)((float)y), (double)((float)maxZ)).method_22915(IRenderer.State.red, IRenderer.State.green, IRenderer.State.blue, IRenderer.State.alpha).method_1344();
            buffer.method_22912((double)((float)minX), (double)((float)y), (double)((float)maxZ)).method_22915(IRenderer.State.red, IRenderer.State.green, IRenderer.State.blue, IRenderer.State.alpha).method_1344();
            tessellator.method_1350();
        }
    }
}

