/*
 * Decompiled with CFR 0.152.
 */
package f_baritone.selection;

import f_baritone.AutomatoneClient;
import f_baritone.api.IBaritone;
import f_baritone.api.Settings;
import f_baritone.api.selection.ISelection;
import f_baritone.api.selection.ISelectionManager;
import f_baritone.api.utils.BetterBlockPos;
import f_baritone.selection.Selection;
import java.lang.invoke.LambdaMetafactory;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class SelectionManager
implements ISelectionManager {
    private final class_1297 holder;
    private final LinkedList<ISelection> selections = new LinkedList();
    private ISelection[] selectionsArr = new ISelection[0];

    public SelectionManager(class_1297 holder) {
        this.holder = holder;
    }

    private void resetSelectionsArr() {
        this.selectionsArr = this.selections.toArray(new ISelection[0]);
        KEY.sync((Object)this.holder);
    }

    @Override
    public synchronized ISelection addSelection(ISelection selection) {
        this.selections.add(selection);
        this.resetSelectionsArr();
        return selection;
    }

    @Override
    public ISelection addSelection(BetterBlockPos pos1, BetterBlockPos pos2) {
        return this.addSelection(new Selection(pos1, pos2));
    }

    @Override
    public synchronized ISelection removeSelection(ISelection selection) {
        this.selections.remove(selection);
        this.resetSelectionsArr();
        return selection;
    }

    @Override
    public synchronized ISelection[] removeAllSelections() {
        ISelection[] selectionsArr = this.getSelections();
        this.selections.clear();
        this.resetSelectionsArr();
        return selectionsArr;
    }

    @Override
    public ISelection[] getSelections() {
        return this.selectionsArr;
    }

    @Override
    public synchronized ISelection getOnlySelection() {
        if (this.selections.size() == 1) {
            return this.selections.peekFirst();
        }
        return null;
    }

    @Override
    public ISelection getLastSelection() {
        return this.selections.peekLast();
    }

    @Override
    public synchronized ISelection expand(ISelection selection, class_2350 direction, int blocks) {
        ListIterator<ISelection> it = this.selections.listIterator();
        while (it.hasNext()) {
            ISelection current = (ISelection)it.next();
            if (current != selection) continue;
            it.remove();
            it.add(current.expand(direction, blocks));
            this.resetSelectionsArr();
            return (ISelection)it.previous();
        }
        return null;
    }

    @Override
    public synchronized ISelection contract(ISelection selection, class_2350 direction, int blocks) {
        ListIterator<ISelection> it = this.selections.listIterator();
        while (it.hasNext()) {
            ISelection current = (ISelection)it.next();
            if (current != selection) continue;
            it.remove();
            it.add(current.contract(direction, blocks));
            this.resetSelectionsArr();
            return (ISelection)it.previous();
        }
        return null;
    }

    @Override
    public synchronized ISelection shift(ISelection selection, class_2350 direction, int blocks) {
        ListIterator<ISelection> it = this.selections.listIterator();
        while (it.hasNext()) {
            ISelection current = (ISelection)it.next();
            if (current != selection) continue;
            it.remove();
            it.add(current.shift(direction, blocks));
            this.resetSelectionsArr();
            return (ISelection)it.previous();
        }
        return null;
    }

    public void readFromNbt(class_2487 tag) {
    }

    public void writeToNbt(class_2487 tag) {
    }

    public boolean shouldSyncWith(class_3222 player) {
        return player == this.holder || IBaritone.KEY.maybeGet((Object)this.holder).map((Function<IBaritone, Settings>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, settings(), (Lf_baritone/api/IBaritone;)Lf_baritone/api/Settings;)()).orElseGet((Supplier<Settings>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getGlobalSettings(), ()Lf_baritone/api/Settings;)()).syncWithOps.get() != false && player.field_13995.method_3835(player.method_7334()) >= 2;
    }

    public void writeSyncPacket(class_2540 buf, class_3222 recipient) {
        buf.method_10804(this.selectionsArr.length);
        for (ISelection sel : this.selectionsArr) {
            buf.method_10807((class_2338)sel.pos1());
            buf.method_10807((class_2338)sel.pos2());
        }
    }

    public void applySyncPacket(class_2540 buf) {
        this.removeAllSelections();
        int length = buf.method_10816();
        for (int i = 0; i < length; ++i) {
            class_2338 pos1 = buf.method_10811();
            class_2338 pos2 = buf.method_10811();
            this.addSelection(new BetterBlockPos(pos1), new BetterBlockPos(pos2));
        }
        if (this.selections.isEmpty()) {
            AutomatoneClient.selectionRenderList.remove(this);
        } else {
            AutomatoneClient.selectionRenderList.add(this);
        }
    }
}

