/*
 * Decompiled with CFR 0.152.
 */
package f_baritone.selection;

import f_baritone.api.selection.ISelection;
import f_baritone.api.utils.BetterBlockPos;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;

public class Selection
implements ISelection {
    private final BetterBlockPos pos1;
    private final BetterBlockPos pos2;
    private final BetterBlockPos min;
    private final BetterBlockPos max;
    private final class_2382 size;
    private final class_238 aabb;

    public Selection(BetterBlockPos pos1, BetterBlockPos pos2) {
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.min = new BetterBlockPos(Math.min(pos1.x, pos2.x), Math.min(pos1.y, pos2.y), Math.min(pos1.z, pos2.z));
        this.max = new BetterBlockPos(Math.max(pos1.x, pos2.x), Math.max(pos1.y, pos2.y), Math.max(pos1.z, pos2.z));
        this.size = new class_2382(this.max.x - this.min.x + 1, this.max.y - this.min.y + 1, this.max.z - this.min.z + 1);
        this.aabb = new class_238((class_2338)this.min, this.max.method_10069(1, 1, 1));
    }

    @Override
    public BetterBlockPos pos1() {
        return this.pos1;
    }

    @Override
    public BetterBlockPos pos2() {
        return this.pos2;
    }

    @Override
    public BetterBlockPos min() {
        return this.min;
    }

    @Override
    public BetterBlockPos max() {
        return this.max;
    }

    @Override
    public class_2382 size() {
        return this.size;
    }

    @Override
    public class_238 aabb() {
        return this.aabb;
    }

    public int hashCode() {
        return this.pos1.hashCode() ^ this.pos2.hashCode();
    }

    public String toString() {
        return String.format("Selection{pos1=%s,pos2=%s}", new Object[]{this.pos1, this.pos2});
    }

    private boolean isPos2(class_2350 facing) {
        boolean negative = facing.method_10171().method_10181() < 0;
        switch (facing.method_10166()) {
            case field_11048: {
                return this.pos2.x > this.pos1.x ^ negative;
            }
            case field_11052: {
                return this.pos2.y > this.pos1.y ^ negative;
            }
            case field_11051: {
                return this.pos2.z > this.pos1.z ^ negative;
            }
        }
        throw new IllegalStateException("Bad Direction.Axis");
    }

    @Override
    public ISelection expand(class_2350 direction, int blocks) {
        if (this.isPos2(direction)) {
            return new Selection(this.pos1, this.pos2.offset(direction, blocks));
        }
        return new Selection(this.pos1.offset(direction, blocks), this.pos2);
    }

    @Override
    public ISelection contract(class_2350 direction, int blocks) {
        if (this.isPos2(direction)) {
            return new Selection(this.pos1.offset(direction, blocks), this.pos2);
        }
        return new Selection(this.pos1, this.pos2.offset(direction, blocks));
    }

    @Override
    public ISelection shift(class_2350 direction, int blocks) {
        return new Selection(this.pos1.offset(direction, blocks), this.pos2.offset(direction, blocks));
    }
}

