/*
 * Decompiled with CFR 0.152.
 */
package f_baritone.process;

import f_baritone.Automatone;
import f_baritone.Baritone;
import f_baritone.api.pathing.goals.Goal;
import f_baritone.api.pathing.goals.GoalBlock;
import f_baritone.api.pathing.goals.GoalComposite;
import f_baritone.api.pathing.goals.GoalGetToBlock;
import f_baritone.api.pathing.goals.GoalRunAway;
import f_baritone.api.pathing.goals.GoalTwoBlocks;
import f_baritone.api.process.IGetToBlockProcess;
import f_baritone.api.process.PathingCommand;
import f_baritone.api.process.PathingCommandType;
import f_baritone.api.utils.BetterBlockPos;
import f_baritone.api.utils.BlockOptionalMeta;
import f_baritone.api.utils.BlockOptionalMetaLookup;
import f_baritone.api.utils.Rotation;
import f_baritone.api.utils.RotationUtils;
import f_baritone.api.utils.input.Input;
import f_baritone.pathing.movement.CalculationContext;
import f_baritone.pathing.movement.MovementHelper;
import f_baritone.process.MineProcess;
import f_baritone.utils.BaritoneProcessHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;

public final class GetToBlockProcess
extends BaritoneProcessHelper
implements IGetToBlockProcess {
    private BlockOptionalMeta gettingTo;
    private List<class_2338> knownLocations;
    private List<class_2338> blacklist;
    private class_2338 start;
    private int tickCount = 0;
    private int arrivalTickCount = 0;

    public GetToBlockProcess(Baritone baritone) {
        super(baritone);
    }

    @Override
    public void getToBlock(BlockOptionalMeta block) {
        this.onLostControl();
        this.gettingTo = block;
        this.start = this.ctx.feetPos();
        this.blacklist = new ArrayList<class_2338>();
        this.arrivalTickCount = 0;
        this.rescan(new ArrayList<class_2338>(), new CalculationContext(this.baritone));
    }

    @Override
    public boolean isActive() {
        return this.gettingTo != null;
    }

    @Override
    public synchronized PathingCommand onTick(boolean calcFailed, boolean isSafeToCancel) {
        if (this.knownLocations == null) {
            this.rescan(new ArrayList<class_2338>(), new CalculationContext(this.baritone));
        }
        if (this.knownLocations.isEmpty()) {
            if (this.baritone.settings().exploreForBlocks.get().booleanValue() && !calcFailed) {
                return new PathingCommand(new GoalRunAway(1.0, new class_2338[]{this.start}){

                    @Override
                    public boolean isInGoal(int x, int y, int z) {
                        return false;
                    }

                    @Override
                    public double heuristic() {
                        return Double.NEGATIVE_INFINITY;
                    }
                }, PathingCommandType.FORCE_REVALIDATE_GOAL_AND_PATH);
            }
            this.logDirect("No known locations of " + this.gettingTo + ", canceling GetToBlock");
            if (isSafeToCancel) {
                this.onLostControl();
            }
            return new PathingCommand(null, PathingCommandType.CANCEL_AND_SET_GOAL);
        }
        GoalComposite goal = new GoalComposite((Goal[])this.knownLocations.stream().map(this::createGoal).toArray(Goal[]::new));
        if (calcFailed) {
            if (this.baritone.settings().blacklistClosestOnFailure.get().booleanValue()) {
                this.logDirect("Unable to find any path to " + this.gettingTo + ", blacklisting presumably unreachable closest instances...");
                this.blacklistClosest();
                return this.onTick(false, isSafeToCancel);
            }
            this.logDirect("Unable to find any path to " + this.gettingTo + ", canceling GetToBlock");
            if (isSafeToCancel) {
                this.onLostControl();
            }
            return new PathingCommand(goal, PathingCommandType.CANCEL_AND_SET_GOAL);
        }
        int mineGoalUpdateInterval = this.baritone.settings().mineGoalUpdateInterval.get();
        if (mineGoalUpdateInterval != 0 && this.tickCount++ % mineGoalUpdateInterval == 0) {
            ArrayList<class_2338> current = new ArrayList<class_2338>(this.knownLocations);
            CalculationContext context = new CalculationContext(this.baritone, true);
            Automatone.getExecutor().execute(() -> this.rescan(current, context));
        }
        if (goal.isInGoal(this.ctx.feetPos()) && goal.isInGoal(this.baritone.getPathingBehavior().pathStart()) && isSafeToCancel) {
            if (this.rightClickOnArrival(this.gettingTo.getBlock())) {
                if (this.rightClick()) {
                    this.onLostControl();
                    return new PathingCommand(null, PathingCommandType.CANCEL_AND_SET_GOAL);
                }
            } else {
                this.onLostControl();
                return new PathingCommand(null, PathingCommandType.CANCEL_AND_SET_GOAL);
            }
        }
        return new PathingCommand(goal, PathingCommandType.REVALIDATE_GOAL_AND_PATH);
    }

    @Override
    public synchronized boolean blacklistClosest() {
        ArrayList<class_2338> newBlacklist = new ArrayList<class_2338>();
        this.knownLocations.stream().min(Comparator.comparingDouble(arg_0 -> ((BetterBlockPos)this.ctx.feetPos()).method_10262(arg_0))).ifPresent(newBlacklist::add);
        block2: while (true) {
            block3: for (class_2338 known : this.knownLocations) {
                for (class_2338 blacklist : newBlacklist) {
                    if (!this.areAdjacent(known, blacklist)) continue;
                    newBlacklist.add(known);
                    this.knownLocations.remove(known);
                    continue block2;
                    continue block3;
                }
            }
            break;
        }
        switch (newBlacklist.size()) {
            default: 
        }
        this.baritone.logDebug("Blacklisting unreachable locations " + newBlacklist);
        this.blacklist.addAll(newBlacklist);
        return !newBlacklist.isEmpty();
    }

    private boolean areAdjacent(class_2338 posA, class_2338 posB) {
        int diffZ;
        int diffY;
        int diffX = Math.abs(posA.method_10263() - posB.method_10263());
        return diffX + (diffY = Math.abs(posA.method_10264() - posB.method_10264())) + (diffZ = Math.abs(posA.method_10260() - posB.method_10260())) == 1;
    }

    @Override
    public synchronized void onLostControl() {
        this.gettingTo = null;
        this.knownLocations = null;
        this.start = null;
        this.blacklist = null;
        this.baritone.getInputOverrideHandler().clearAllKeys();
    }

    @Override
    public String displayName0() {
        if (this.knownLocations.isEmpty()) {
            return "Exploring randomly to find " + this.gettingTo + ", no known locations";
        }
        return "Get To " + this.gettingTo + ", " + this.knownLocations.size() + " known locations";
    }

    private synchronized void rescan(List<class_2338> known, CalculationContext context) {
        List<class_2338> positions = MineProcess.searchWorld(context, new BlockOptionalMetaLookup(this.gettingTo), 64, known, this.blacklist, Collections.emptyList());
        positions.removeIf(this.blacklist::contains);
        this.knownLocations = positions;
    }

    private Goal createGoal(class_2338 pos) {
        if (this.walkIntoInsteadOfAdjacent(this.gettingTo.getBlock())) {
            return new GoalTwoBlocks(pos);
        }
        if (this.blockOnTopMustBeRemoved(this.gettingTo.getBlock()) && MovementHelper.isBlockNormalCube(this.baritone.bsi.get0(pos.method_10084()))) {
            return new GoalBlock(pos.method_10084());
        }
        return new GoalGetToBlock(pos);
    }

    private boolean rightClick() {
        for (class_2338 pos : this.knownLocations) {
            Optional<Rotation> reachable = RotationUtils.reachable(this.ctx.entity(), pos, this.ctx.playerController().getBlockReachDistance());
            if (!reachable.isPresent()) continue;
            this.baritone.getLookBehavior().updateTarget(reachable.get(), true);
            if (this.knownLocations.contains(this.ctx.getSelectedBlock().orElse(null))) {
                class_1723 handler;
                this.baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_RIGHT, true);
                class_1723 class_17232 = handler = this.ctx.entity() instanceof class_1657 ? ((class_1657)this.ctx.entity()).field_7498 : null;
                if (handler == null) {
                    return true;
                }
            }
            if (this.arrivalTickCount++ > 20) {
                this.logDirect("Right click timed out");
                return true;
            }
            return false;
        }
        this.logDirect("Arrived but failed to right click open");
        return true;
    }

    private boolean walkIntoInsteadOfAdjacent(class_2248 block) {
        if (!this.baritone.settings().enterPortal.get().booleanValue()) {
            return false;
        }
        return block == class_2246.field_10316;
    }

    private boolean rightClickOnArrival(class_2248 block) {
        if (!this.baritone.settings().rightClickContainerOnArrival.get().booleanValue()) {
            return false;
        }
        return block == class_2246.field_9980 || block == class_2246.field_10181 || block == class_2246.field_10443 || block == class_2246.field_10034 || block == class_2246.field_10380;
    }

    private boolean blockOnTopMustBeRemoved(class_2248 block) {
        if (!this.rightClickOnArrival(block)) {
            return false;
        }
        return block == class_2246.field_10443 || block == class_2246.field_10034 || block == class_2246.field_10380;
    }
}

