/*
 * Decompiled with CFR 0.152.
 */
package f_baritone.process;

import f_baritone.Automatone;
import f_baritone.Baritone;
import f_baritone.api.Settings;
import f_baritone.api.pathing.goals.Goal;
import f_baritone.api.pathing.goals.GoalBlock;
import f_baritone.api.pathing.goals.GoalComposite;
import f_baritone.api.process.IFarmProcess;
import f_baritone.api.process.PathingCommand;
import f_baritone.api.process.PathingCommandType;
import f_baritone.api.utils.RayTraceUtils;
import f_baritone.api.utils.Rotation;
import f_baritone.api.utils.RotationUtils;
import f_baritone.api.utils.input.Input;
import f_baritone.api.utils.interfaces.IGoalRenderPos;
import f_baritone.cache.WorldScanner;
import f_baritone.pathing.movement.MovementHelper;
import f_baritone.process.BuilderProcess;
import f_baritone.utils.BaritoneProcessHelper;
import f_baritone.utils.NotificationHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2189;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2266;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2421;
import net.minecraft.class_243;
import net.minecraft.class_2523;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_4538;

public final class FarmProcess
extends BaritoneProcessHelper
implements IFarmProcess {
    private boolean active;
    private List<class_2338> locations;
    private int tickCount;
    private int range;
    private class_2338 center;
    private static final List<class_1792> FARMLAND_PLANTABLE = Arrays.asList(class_1802.field_8309, class_1802.field_8188, class_1802.field_8317, class_1802.field_8706, class_1802.field_8567, class_1802.field_8179);
    private static final List<class_1792> PICKUP_DROPPED = Arrays.asList(class_1802.field_8309, class_1802.field_8186, class_1802.field_8188, class_1802.field_8497, class_2246.field_10545.method_8389(), class_1802.field_8317, class_1802.field_8861, class_1802.field_8706, class_2246.field_10261.method_8389(), class_1802.field_8567, class_1802.field_8179, class_1802.field_8790, class_2246.field_10424.method_8389(), class_2246.field_10029.method_8389());

    public FarmProcess(Baritone baritone) {
        super(baritone);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void farm(int range, class_2338 pos) {
        this.center = pos == null ? this.baritone.getPlayerContext().feetPos() : pos;
        this.range = range;
        this.active = true;
        this.locations = null;
    }

    private boolean readyForHarvest(class_1937 world, class_2338 pos, class_2680 state) {
        for (Harvest harvest : Harvest.values()) {
            if (harvest.block != state.method_26204()) continue;
            return harvest.readyToHarvest(world, pos, state, this.baritone.settings());
        }
        return false;
    }

    private boolean isPlantable(class_1799 stack) {
        return FARMLAND_PLANTABLE.contains(stack.method_7909());
    }

    private boolean isBoneMeal(class_1799 stack) {
        return !stack.method_7960() && stack.method_7909().equals(class_1802.field_8324);
    }

    private boolean isNetherWart(class_1799 stack) {
        return !stack.method_7960() && stack.method_7909().equals(class_1802.field_8790);
    }

    @Override
    public PathingCommand onTick(boolean calcFailed, boolean isSafeToCancel) {
        ArrayList<class_2248> scan = new ArrayList<class_2248>();
        for (Harvest harvest : Harvest.values()) {
            scan.add(harvest.block);
        }
        if (this.baritone.settings().replantCrops.get().booleanValue()) {
            scan.add(class_2246.field_10362);
            if (this.baritone.settings().replantNetherWart.get().booleanValue()) {
                scan.add(class_2246.field_10114);
            }
        }
        if (this.baritone.settings().mineGoalUpdateInterval.get() != 0 && this.tickCount++ % this.baritone.settings().mineGoalUpdateInterval.get() == 0) {
            Automatone.getExecutor().execute(() -> {
                this.locations = WorldScanner.INSTANCE.scanChunkRadius(this.ctx, scan, 256, 10, 10);
            });
        }
        if (this.locations == null) {
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        ArrayList<class_2338> toBreak = new ArrayList<class_2338>();
        ArrayList<class_2338> openFarmland = new ArrayList<class_2338>();
        ArrayList<class_2338> bonemealable = new ArrayList<class_2338>();
        ArrayList<class_2338> openSoulsand = new ArrayList<class_2338>();
        for (class_2338 class_23382 : this.locations) {
            class_2256 ig;
            if (this.range != 0 && class_23382.method_10262((class_2382)this.center) > (double)(this.range * this.range)) continue;
            class_2680 class_26802 = this.ctx.world().method_8320(class_23382);
            boolean bl = this.ctx.world().method_8320(class_23382.method_10084()).method_26204() instanceof class_2189;
            if (class_26802.method_26204() == class_2246.field_10362) {
                if (!bl) continue;
                openFarmland.add(class_23382);
                continue;
            }
            if (class_26802.method_26204() == class_2246.field_10114) {
                if (!bl) continue;
                openSoulsand.add(class_23382);
                continue;
            }
            if (this.readyForHarvest((class_1937)this.ctx.world(), class_23382, class_26802)) {
                toBreak.add(class_23382);
                continue;
            }
            if (!(class_26802.method_26204() instanceof class_2256) || !(ig = (class_2256)class_26802.method_26204()).method_9651((class_4538)this.ctx.world(), class_23382, class_26802, true)) continue;
            bonemealable.add(class_23382);
        }
        this.baritone.getInputOverrideHandler().clearAllKeys();
        for (class_2338 class_23383 : toBreak) {
            Optional<Rotation> optional = RotationUtils.reachable(this.ctx, class_23383);
            if (!optional.isPresent() || !isSafeToCancel) continue;
            this.baritone.getLookBehavior().updateTarget(optional.get(), true);
            MovementHelper.switchToBestToolFor(this.ctx, this.ctx.world().method_8320(class_23383));
            if (this.ctx.isLookingAt(class_23383)) {
                this.baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_LEFT, true);
            }
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        ArrayList<class_2338> both = new ArrayList<class_2338>(openFarmland);
        both.addAll(openSoulsand);
        for (class_2338 class_23384 : both) {
            class_239 result;
            boolean bl = openSoulsand.contains(class_23384);
            Optional<Rotation> rot = RotationUtils.reachableOffset((class_1297)this.ctx.entity(), class_23384, new class_243((double)class_23384.method_10263() + 0.5, (double)(class_23384.method_10264() + 1), (double)class_23384.method_10260() + 0.5), this.ctx.playerController().getBlockReachDistance(), false);
            if (!rot.isPresent() || !isSafeToCancel || !this.baritone.getInventoryBehavior().throwaway(true, bl ? this::isNetherWart : this::isPlantable) || !((result = RayTraceUtils.rayTraceTowards((class_1297)this.ctx.entity(), rot.get(), this.ctx.playerController().getBlockReachDistance())) instanceof class_3965) || ((class_3965)result).method_17780() != class_2350.field_11036) continue;
            this.baritone.getLookBehavior().updateTarget(rot.get(), true);
            if (this.ctx.isLookingAt(class_23384)) {
                this.baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_RIGHT, true);
            }
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        for (class_2338 class_23385 : bonemealable) {
            Optional<Rotation> optional = RotationUtils.reachable(this.ctx, class_23385);
            if (!optional.isPresent() || !isSafeToCancel || !this.baritone.getInventoryBehavior().throwaway(true, this::isBoneMeal)) continue;
            this.baritone.getLookBehavior().updateTarget(optional.get(), true);
            if (this.ctx.isLookingAt(class_23385)) {
                this.baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_RIGHT, true);
            }
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        if (calcFailed) {
            this.logDirect("Farm failed");
            if (this.baritone.settings().desktopNotifications.get().booleanValue() && this.baritone.settings().notificationOnFarmFail.get().booleanValue()) {
                NotificationHelper.notify("Farm failed", true);
            }
            this.onLostControl();
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        ArrayList<IGoalRenderPos> arrayList = new ArrayList<IGoalRenderPos>();
        for (class_2338 class_23386 : toBreak) {
            arrayList.add(new BuilderProcess.GoalBreak(class_23386));
        }
        if (this.baritone.getInventoryBehavior().throwaway(false, this::isPlantable)) {
            for (class_2338 class_23387 : openFarmland) {
                arrayList.add(new GoalBlock(class_23387.method_10084()));
            }
        }
        if (this.baritone.getInventoryBehavior().throwaway(false, this::isNetherWart)) {
            for (class_2338 class_23388 : openSoulsand) {
                arrayList.add(new GoalBlock(class_23388.method_10084()));
            }
        }
        if (this.baritone.getInventoryBehavior().throwaway(false, this::isBoneMeal)) {
            for (class_2338 class_23389 : bonemealable) {
                arrayList.add(new GoalBlock(class_23389));
            }
        }
        for (class_1542 class_15422 : this.ctx.world().method_8390(class_1542.class, this.ctx.entity().method_5829().method_1014(30.0), class_1297::method_24828)) {
            if (!PICKUP_DROPPED.contains(class_15422.method_6983().method_7909())) continue;
            arrayList.add(new GoalBlock(new class_2338((int)Math.round(class_15422.method_23317()), (int)Math.round(class_15422.method_23318() + 0.1), (int)Math.round(class_15422.method_23321()))));
        }
        return new PathingCommand(new GoalComposite(arrayList.toArray(new Goal[0])), PathingCommandType.SET_GOAL_AND_PATH);
    }

    @Override
    public void onLostControl() {
        this.active = false;
    }

    @Override
    public String displayName0() {
        return "Farming";
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Harvest {
        WHEAT((class_2302)class_2246.field_10293),
        CARROTS((class_2302)class_2246.field_10609),
        POTATOES((class_2302)class_2246.field_10247),
        BEETROOT((class_2302)class_2246.field_10341),
        PUMPKIN(class_2246.field_10261, state -> true),
        MELON(class_2246.field_10545, state -> true),
        NETHERWART(class_2246.field_9974, state -> (Integer)state.method_11654((class_2769)class_2421.field_11306) >= 3),
        SUGARCANE(class_2246.field_10424, null){

            @Override
            public boolean readyToHarvest(class_1937 world, class_2338 pos, class_2680 state, Settings settings) {
                if (settings.replantCrops.get().booleanValue()) {
                    return world.method_8320(pos.method_10074()).method_26204() instanceof class_2523;
                }
                return true;
            }
        }
        ,
        CACTUS(class_2246.field_10029, null){

            @Override
            public boolean readyToHarvest(class_1937 world, class_2338 pos, class_2680 state, Settings settings) {
                if (settings.replantCrops.get().booleanValue()) {
                    return world.method_8320(pos.method_10074()).method_26204() instanceof class_2266;
                }
                return true;
            }
        };

        public final class_2248 block;
        public final Predicate<class_2680> readyToHarvest;

        private Harvest(class_2302 blockCrops) {
            this((class_2248)blockCrops, arg_0 -> ((class_2302)blockCrops).method_9825(arg_0));
        }

        private Harvest(class_2248 block, Predicate<class_2680> readyToHarvest) {
            this.block = block;
            this.readyToHarvest = readyToHarvest;
        }

        public boolean readyToHarvest(class_1937 world, class_2338 pos, class_2680 state, Settings settings) {
            return this.readyToHarvest.test(state);
        }
    }
}

