/*
 * Decompiled with CFR 0.152.
 */
package f_baritone.process;

import f_baritone.Baritone;
import f_baritone.api.pathing.goals.Goal;
import f_baritone.api.process.ICustomGoalProcess;
import f_baritone.api.process.PathingCommand;
import f_baritone.api.process.PathingCommandType;
import f_baritone.utils.BaritoneProcessHelper;
import f_baritone.utils.NotificationHelper;

public final class CustomGoalProcess
extends BaritoneProcessHelper
implements ICustomGoalProcess {
    private Goal goal;
    private State state;

    public CustomGoalProcess(Baritone baritone) {
        super(baritone);
    }

    @Override
    public void setGoal(Goal goal) {
        this.goal = goal;
        if (goal == null) {
            this.state = State.NONE;
            return;
        }
        if (this.state == State.NONE) {
            this.state = State.GOAL_SET;
        }
        if (this.state == State.EXECUTING) {
            this.state = State.PATH_REQUESTED;
        }
    }

    @Override
    public void path() {
        this.state = State.PATH_REQUESTED;
    }

    @Override
    public Goal getGoal() {
        return this.goal;
    }

    @Override
    public boolean isActive() {
        return this.state != State.NONE;
    }

    @Override
    public PathingCommand onTick(boolean calcFailed, boolean isSafeToCancel) {
        switch (this.state) {
            case GOAL_SET: {
                return new PathingCommand(this.goal, PathingCommandType.CANCEL_AND_SET_GOAL);
            }
            case PATH_REQUESTED: {
                PathingCommand ret = new PathingCommand(this.goal, PathingCommandType.FORCE_REVALIDATE_GOAL_AND_PATH);
                this.state = State.EXECUTING;
                return ret;
            }
            case EXECUTING: {
                if (calcFailed) {
                    this.onLostControl();
                    return new PathingCommand(this.goal, PathingCommandType.CANCEL_AND_SET_GOAL);
                }
                if (this.goal == null || this.goal.isInGoal(this.ctx.feetPos()) && this.goal.isInGoal(this.baritone.getPathingBehavior().pathStart())) {
                    this.onLostControl();
                    if (this.baritone.settings().disconnectOnArrival.get().booleanValue()) {
                        this.ctx.world().method_8525();
                    }
                    if (this.baritone.settings().desktopNotifications.get().booleanValue() && this.baritone.settings().notificationOnPathComplete.get().booleanValue()) {
                        NotificationHelper.notify("Pathing complete", false);
                    }
                    return new PathingCommand(this.goal, PathingCommandType.CANCEL_AND_SET_GOAL);
                }
                return new PathingCommand(this.goal, PathingCommandType.SET_GOAL_AND_PATH);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void onLostControl() {
        this.state = State.NONE;
        this.goal = null;
    }

    @Override
    public String displayName0() {
        return "Custom Goal " + this.goal;
    }

    protected static enum State {
        NONE,
        GOAL_SET,
        PATH_REQUESTED,
        EXECUTING;

    }
}

