/*
 * Decompiled with CFR 0.152.
 */
package f_baritone.process;

import f_baritone.Automatone;
import f_baritone.Baritone;
import f_baritone.api.pathing.goals.Goal;
import f_baritone.api.pathing.goals.GoalBlock;
import f_baritone.api.pathing.goals.GoalComposite;
import f_baritone.api.pathing.goals.GoalGetToBlock;
import f_baritone.api.process.IBuilderProcess;
import f_baritone.api.process.PathingCommand;
import f_baritone.api.process.PathingCommandType;
import f_baritone.api.schematic.FillSchematic;
import f_baritone.api.schematic.ISchematic;
import f_baritone.api.schematic.IStaticSchematic;
import f_baritone.api.schematic.format.ISchematicFormat;
import f_baritone.api.utils.BetterBlockPos;
import f_baritone.api.utils.BlockOptionalMeta;
import f_baritone.api.utils.RayTraceUtils;
import f_baritone.api.utils.Rotation;
import f_baritone.api.utils.RotationUtils;
import f_baritone.api.utils.input.Input;
import f_baritone.pathing.movement.CalculationContext;
import f_baritone.pathing.movement.Movement;
import f_baritone.pathing.movement.MovementHelper;
import f_baritone.utils.BaritoneProcessHelper;
import f_baritone.utils.BlockStateInterface;
import f_baritone.utils.NotificationHelper;
import f_baritone.utils.PathingCommandContext;
import f_baritone.utils.schematic.MapArtSchematic;
import f_baritone.utils.schematic.SchematicSystem;
import f_baritone.utils.schematic.schematica.SchematicaHelper;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2189;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3545;
import net.minecraft.class_3965;
import net.minecraft.class_4538;

public final class BuilderProcess
extends BaritoneProcessHelper
implements IBuilderProcess {
    private HashSet<BetterBlockPos> incorrectPositions;
    private LongOpenHashSet observedCompleted;
    private String name;
    private ISchematic realSchematic;
    private ISchematic schematic;
    private class_2382 origin;
    private int ticks;
    private boolean paused;
    private int layer;
    private int numRepeats;
    private List<class_2680> approxPlaceable;

    public BuilderProcess(Baritone baritone) {
        super(baritone);
    }

    @Override
    public void build(String name, ISchematic schematic, class_2382 origin) {
        this.name = name;
        this.schematic = schematic;
        this.realSchematic = null;
        int x = origin.method_10263();
        int y = origin.method_10264();
        int z = origin.method_10260();
        if (this.baritone.settings().schematicOrientationX.get().booleanValue()) {
            x += schematic.widthX();
        }
        if (this.baritone.settings().schematicOrientationY.get().booleanValue()) {
            y += schematic.heightY();
        }
        if (this.baritone.settings().schematicOrientationZ.get().booleanValue()) {
            z += schematic.lengthZ();
        }
        this.origin = new class_2382(x, y, z);
        this.paused = false;
        this.layer = this.baritone.settings().startAtLayer.get();
        this.numRepeats = 0;
        this.observedCompleted = new LongOpenHashSet();
    }

    @Override
    public void resume() {
        this.paused = false;
    }

    @Override
    public void pause() {
        this.paused = true;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean build(String name, File schematic, class_2382 origin) {
        ISchematic parsed;
        Optional<ISchematicFormat> format = SchematicSystem.INSTANCE.getByFile(schematic);
        if (format.isEmpty()) {
            return false;
        }
        try {
            parsed = format.get().parse(new FileInputStream(schematic));
        }
        catch (Exception e) {
            Automatone.LOGGER.error((Object)e);
            return false;
        }
        if (this.baritone.settings().mapArtMode.get().booleanValue()) {
            parsed = new MapArtSchematic((IStaticSchematic)parsed);
        }
        this.build(name, parsed, origin);
        return true;
    }

    @Override
    public void buildOpenSchematic() {
        if (SchematicaHelper.isSchematicaPresent()) {
            Optional<class_3545<IStaticSchematic, class_2338>> schematic = SchematicaHelper.getOpenSchematic();
            if (schematic.isPresent()) {
                IStaticSchematic s = (IStaticSchematic)schematic.get().method_15442();
                this.build(((IStaticSchematic)schematic.get().method_15442()).toString(), this.baritone.settings().mapArtMode.get() != false ? new MapArtSchematic(s) : s, (class_2382)schematic.get().method_15441());
            } else {
                this.logDirect("No schematic currently open");
            }
        } else {
            this.logDirect("Schematica is not present");
        }
    }

    @Override
    public void clearArea(class_2338 corner1, class_2338 corner2) {
        class_2338 origin = new class_2338(Math.min(corner1.method_10263(), corner2.method_10263()), Math.min(corner1.method_10264(), corner2.method_10264()), Math.min(corner1.method_10260(), corner2.method_10260()));
        int widthX = Math.abs(corner1.method_10263() - corner2.method_10263()) + 1;
        int heightY = Math.abs(corner1.method_10264() - corner2.method_10264()) + 1;
        int lengthZ = Math.abs(corner1.method_10260() - corner2.method_10260()) + 1;
        this.build("clear area", new FillSchematic(widthX, heightY, lengthZ, new BlockOptionalMeta(this.baritone.getPlayerContext().world(), class_2246.field_10124)), (class_2382)origin);
    }

    @Override
    public List<class_2680> getApproxPlaceable() {
        return new ArrayList<class_2680>(this.approxPlaceable);
    }

    @Override
    public boolean isActive() {
        return this.schematic != null;
    }

    public class_2680 placeAt(int x, int y, int z, class_2680 current) {
        if (!this.isActive()) {
            return null;
        }
        if (!this.schematic.inSchematic(x - this.origin.method_10263(), y - this.origin.method_10264(), z - this.origin.method_10260(), current)) {
            return null;
        }
        class_2680 state = this.schematic.desiredState(x - this.origin.method_10263(), y - this.origin.method_10264(), z - this.origin.method_10260(), current, this.approxPlaceable);
        if (state.method_26204() instanceof class_2189) {
            return null;
        }
        return state;
    }

    private Optional<class_3545<BetterBlockPos, Rotation>> toBreakNearPlayer(BuilderCalculationContext bcc) {
        BetterBlockPos center = this.ctx.feetPos();
        BetterBlockPos pathStart = this.baritone.getPathingBehavior().pathStart();
        for (int dx = -5; dx <= 5; ++dx) {
            int dy;
            int n = dy = this.baritone.settings().breakFromAbove.get() != false ? -1 : 0;
            while (dy <= 5) {
                for (int dz = -5; dz <= 5; ++dz) {
                    class_2680 curr;
                    class_2680 desired;
                    int x = center.x + dx;
                    int y = center.y + dy;
                    int z = center.z + dz;
                    if (dy == -1 && x == pathStart.x && z == pathStart.z || (desired = bcc.getSchematic(x, y, z, bcc.bsi.get0(x, y, z))) == null || (curr = bcc.bsi.get0(x, y, z)).method_26204() instanceof class_2189 || curr.method_26204() == class_2246.field_10382 || curr.method_26204() == class_2246.field_10164 || this.valid(curr, desired, false)) continue;
                    BetterBlockPos pos = new BetterBlockPos(x, y, z);
                    Optional<Rotation> rot = RotationUtils.reachable(this.ctx.entity(), (class_2338)pos, this.ctx.playerController().getBlockReachDistance());
                    if (!rot.isPresent()) continue;
                    return Optional.of(new class_3545((Object)pos, (Object)rot.get()));
                }
                ++dy;
            }
        }
        return Optional.empty();
    }

    private Optional<Placement> searchForPlacables(BuilderCalculationContext bcc, List<class_2680> desirableOnHotbar) {
        BetterBlockPos center = this.ctx.feetPos();
        for (int dx = -5; dx <= 5; ++dx) {
            for (int dy = -5; dy <= 1; ++dy) {
                for (int dz = -5; dz <= 5; ++dz) {
                    class_2680 curr;
                    int x = center.x + dx;
                    int y = center.y + dy;
                    int z = center.z + dz;
                    class_2680 desired = bcc.getSchematic(x, y, z, bcc.bsi.get0(x, y, z));
                    if (desired == null || !MovementHelper.isReplaceable(x, y, z, curr = bcc.bsi.get0(x, y, z), bcc.bsi) || this.valid(curr, desired, false) || dy == 1 && bcc.bsi.get0(x, y + 1, z).method_26204() instanceof class_2189) continue;
                    desirableOnHotbar.add(desired);
                    Optional<Placement> opt = this.possibleToPlace(desired, x, y, z, bcc.bsi);
                    if (!opt.isPresent()) continue;
                    return opt;
                }
            }
        }
        return Optional.empty();
    }

    public boolean placementPlausible(class_2338 pos, class_2680 state) {
        class_265 voxelshape = state.method_26220((class_1922)this.ctx.world(), pos);
        return voxelshape.method_1110() || this.ctx.world().method_8611(null, voxelshape.method_1096((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()));
    }

    private Optional<Placement> possibleToPlace(class_2680 toPlace, int x, int y, int z, BlockStateInterface bsi) {
        for (class_2350 against : class_2350.values()) {
            BetterBlockPos placeAgainstPos = new BetterBlockPos(x, y, z).offset(against);
            class_2680 placeAgainstState = bsi.get0(placeAgainstPos);
            if (MovementHelper.isReplaceable(placeAgainstPos.x, placeAgainstPos.y, placeAgainstPos.z, placeAgainstState, bsi) || !toPlace.method_26184((class_4538)this.ctx.world(), (class_2338)new BetterBlockPos(x, y, z)) || !this.placementPlausible(new BetterBlockPos(x, y, z), toPlace)) continue;
            class_238 aabb = placeAgainstState.method_26218((class_1922)this.ctx.world(), (class_2338)placeAgainstPos).method_1107();
            for (class_243 placementMultiplier : BuilderProcess.aabbSideMultipliers(against)) {
                OptionalInt hotbar;
                double placeX = (double)placeAgainstPos.x + aabb.field_1323 * placementMultiplier.field_1352 + aabb.field_1320 * (1.0 - placementMultiplier.field_1352);
                double placeY = (double)placeAgainstPos.y + aabb.field_1322 * placementMultiplier.field_1351 + aabb.field_1325 * (1.0 - placementMultiplier.field_1351);
                double placeZ = (double)placeAgainstPos.z + aabb.field_1321 * placementMultiplier.field_1350 + aabb.field_1324 * (1.0 - placementMultiplier.field_1350);
                Rotation rot = RotationUtils.calcRotationFromVec3d(RayTraceUtils.inferSneakingEyePosition((class_1297)this.ctx.entity()), new class_243(placeX, placeY, placeZ), this.ctx.entityRotations());
                class_239 result = RayTraceUtils.rayTraceTowards((class_1297)this.ctx.entity(), rot, this.ctx.playerController().getBlockReachDistance(), true);
                if (result == null || result.method_17783() != class_239.class_240.field_1332 || !((class_3965)result).method_17777().equals((Object)placeAgainstPos) || ((class_3965)result).method_17780() != against.method_10153() || !(hotbar = this.hasAnyItemThatWouldPlace(toPlace, result, rot)).isPresent()) continue;
                return Optional.of(new Placement(hotbar.getAsInt(), placeAgainstPos, against.method_10153(), rot));
            }
        }
        return Optional.empty();
    }

    private OptionalInt hasAnyItemThatWouldPlace(class_2680 desired, class_239 result, Rotation rot) {
        class_1309 class_13092 = this.ctx.entity();
        if (!(class_13092 instanceof class_1657)) {
            return OptionalInt.empty();
        }
        class_1657 player = (class_1657)class_13092;
        for (int i = 0; i < 9; ++i) {
            class_1799 stack = (class_1799)player.method_31548().field_7547.get(i);
            if (stack.method_7960() || !(stack.method_7909() instanceof class_1747)) continue;
            float originalYaw = player.method_36454();
            float originalPitch = player.method_36455();
            player.method_36456(rot.getYaw());
            player.method_36457(rot.getPitch());
            class_1750 meme = new class_1750(new class_1838((class_1937)this.ctx.world(), player, class_1268.field_5808, stack, (class_3965)result){});
            class_2680 wouldBePlaced = ((class_1747)stack.method_7909()).method_7711().method_9605(meme);
            player.method_36456(originalYaw);
            player.method_36457(originalPitch);
            if (wouldBePlaced == null || !meme.method_7716() || !this.valid(wouldBePlaced, desired, true)) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    private static class_243[] aabbSideMultipliers(class_2350 side) {
        switch (side) {
            case field_11036: {
                return new class_243[]{new class_243(0.5, 1.0, 0.5), new class_243(0.1, 1.0, 0.5), new class_243(0.9, 1.0, 0.5), new class_243(0.5, 1.0, 0.1), new class_243(0.5, 1.0, 0.9)};
            }
            case field_11033: {
                return new class_243[]{new class_243(0.5, 0.0, 0.5), new class_243(0.1, 0.0, 0.5), new class_243(0.9, 0.0, 0.5), new class_243(0.5, 0.0, 0.1), new class_243(0.5, 0.0, 0.9)};
            }
            case field_11043: 
            case field_11035: 
            case field_11034: 
            case field_11039: {
                double x = side.method_10148() == 0 ? 0.5 : (double)(1 + side.method_10148()) / 2.0;
                double z = side.method_10165() == 0 ? 0.5 : (double)(1 + side.method_10165()) / 2.0;
                return new class_243[]{new class_243(x, 0.25, z), new class_243(x, 0.75, z)};
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public PathingCommand onTick(boolean calcFailed, boolean isSafeToCancel) {
        return this.onTick(calcFailed, isSafeToCancel, 0);
    }

    public PathingCommand onTick(boolean calcFailed, boolean isSafeToCancel, int recursions) {
        Goal goal;
        Optional<class_3545<BetterBlockPos, Rotation>> toBreak;
        BuilderCalculationContext bcc;
        if (recursions > 1000) {
            return new PathingCommand(null, PathingCommandType.SET_GOAL_AND_PATH);
        }
        class_1661 inventory = this.ctx.inventory();
        if (inventory == null) {
            this.schematic = null;
            return null;
        }
        this.approxPlaceable = this.approxPlaceable(36);
        this.ticks = this.baritone.getInputOverrideHandler().isInputForcedDown(Input.CLICK_LEFT) ? 5 : --this.ticks;
        this.baritone.getInputOverrideHandler().clearAllKeys();
        if (this.paused) {
            return new PathingCommand(null, PathingCommandType.CANCEL_AND_SET_GOAL);
        }
        if (this.baritone.settings().buildInLayers.get().booleanValue()) {
            int minYInclusive;
            int maxYInclusive;
            if (this.realSchematic == null) {
                this.realSchematic = this.schematic;
            }
            final ISchematic realSchematic = this.realSchematic;
            if (this.baritone.settings().layerOrder.get().booleanValue()) {
                maxYInclusive = realSchematic.heightY() - 1;
                minYInclusive = realSchematic.heightY() - this.layer;
            } else {
                maxYInclusive = this.layer - 1;
                minYInclusive = 0;
            }
            this.schematic = new ISchematic(){

                @Override
                public class_2680 desiredState(int x, int y, int z, class_2680 current, List<class_2680> approxPlaceable) {
                    return realSchematic.desiredState(x, y, z, current, BuilderProcess.this.approxPlaceable);
                }

                @Override
                public boolean inSchematic(int x, int y, int z, class_2680 currentState) {
                    return ISchematic.super.inSchematic(x, y, z, currentState) && y >= minYInclusive && y <= maxYInclusive && realSchematic.inSchematic(x, y, z, currentState);
                }

                @Override
                public void reset() {
                    realSchematic.reset();
                }

                @Override
                public int widthX() {
                    return realSchematic.widthX();
                }

                @Override
                public int heightY() {
                    return realSchematic.heightY();
                }

                @Override
                public int lengthZ() {
                    return realSchematic.lengthZ();
                }
            };
        }
        if (!this.recalc(bcc = new BuilderCalculationContext())) {
            if (this.baritone.settings().buildInLayers.get().booleanValue() && this.layer < this.realSchematic.heightY()) {
                this.logDirect("Starting layer " + this.layer);
                ++this.layer;
                return this.onTick(calcFailed, isSafeToCancel, recursions + 1);
            }
            class_2382 repeat = this.baritone.settings().buildRepeat.get();
            int max = this.baritone.settings().buildRepeatCount.get();
            ++this.numRepeats;
            if (repeat.equals((Object)new class_2382(0, 0, 0)) || max != -1 && this.numRepeats >= max) {
                this.logDirect("Done building");
                if (this.baritone.settings().desktopNotifications.get().booleanValue() && this.baritone.settings().notificationOnBuildFinished.get().booleanValue()) {
                    NotificationHelper.notify("Done building", false);
                }
                this.onLostControl();
                return null;
            }
            this.layer = 0;
            this.origin = new class_2338(this.origin).method_10081(repeat);
            if (!this.baritone.settings().buildRepeatSneaky.get().booleanValue()) {
                this.schematic.reset();
            }
            this.logDirect("Repeating build in vector " + repeat + ", new origin is " + this.origin);
            return this.onTick(calcFailed, isSafeToCancel, recursions + 1);
        }
        if (this.baritone.settings().distanceTrim.get().booleanValue()) {
            this.trim();
        }
        if ((toBreak = this.toBreakNearPlayer(bcc)).isPresent() && isSafeToCancel && this.ctx.entity().method_24828()) {
            Rotation rot = (Rotation)toBreak.get().method_15441();
            BetterBlockPos pos = (BetterBlockPos)((Object)toBreak.get().method_15442());
            this.baritone.getLookBehavior().updateTarget(rot, true);
            MovementHelper.switchToBestToolFor(this.ctx, bcc.get(pos));
            if (this.ctx.entity().method_5715()) {
                this.baritone.getInputOverrideHandler().setInputForceState(Input.SNEAK, true);
            }
            if (this.ctx.isLookingAt(pos) || this.ctx.entityRotations().isReallyCloseTo(rot)) {
                this.baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_LEFT, true);
            }
            return new PathingCommand(null, PathingCommandType.CANCEL_AND_SET_GOAL);
        }
        ArrayList<class_2680> desirableOnHotbar = new ArrayList<class_2680>();
        Optional<Placement> toPlace = this.searchForPlacables(bcc, desirableOnHotbar);
        if (toPlace.isPresent() && isSafeToCancel && this.ctx.entity().method_24828() && this.ticks <= 0) {
            Rotation rot = toPlace.get().rot;
            this.baritone.getLookBehavior().updateTarget(rot, true);
            inventory.field_7545 = toPlace.get().hotbarSelection;
            this.baritone.getInputOverrideHandler().setInputForceState(Input.SNEAK, true);
            if (this.ctx.isLookingAt(toPlace.get().placeAgainst) && ((class_3965)this.ctx.objectMouseOver()).method_17780().equals((Object)toPlace.get().side) || this.ctx.entityRotations().isReallyCloseTo(rot)) {
                this.baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_RIGHT, true);
            }
            return new PathingCommand(null, PathingCommandType.CANCEL_AND_SET_GOAL);
        }
        if (this.baritone.settings().allowInventory.get().booleanValue()) {
            ArrayList<Integer> usefulSlots = new ArrayList<Integer>();
            ArrayList<class_2680> noValidHotbarOption = new ArrayList<class_2680>();
            block0: for (class_2680 desired : desirableOnHotbar) {
                for (int i = 0; i < 9; ++i) {
                    if (!this.valid(this.approxPlaceable.get(i), desired, true)) continue;
                    usefulSlots.add(i);
                    continue block0;
                }
                noValidHotbarOption.add(desired);
            }
            block2: for (int i = 9; i < 36; ++i) {
                for (class_2680 desired : noValidHotbarOption) {
                    if (!this.valid(this.approxPlaceable.get(i), desired, true)) continue;
                    this.baritone.getInventoryBehavior().attemptToPutOnHotbar(i, usefulSlots::contains, inventory);
                    break block2;
                }
            }
        }
        if ((goal = this.assemble(bcc, this.approxPlaceable.subList(0, 9))) == null && (goal = this.assemble(bcc, this.approxPlaceable, true)) == null) {
            if (this.baritone.settings().skipFailedLayers.get().booleanValue() && this.baritone.settings().buildInLayers.get().booleanValue() && this.layer < this.realSchematic.heightY()) {
                this.logDirect("Skipping layer that I cannot construct! Layer #" + this.layer);
                ++this.layer;
                return this.onTick(calcFailed, isSafeToCancel, recursions + 1);
            }
            this.logDirect("Unable to do it. Pausing. resume to resume, cancel to cancel");
            this.paused = true;
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        return new PathingCommandContext(goal, PathingCommandType.FORCE_REVALIDATE_GOAL_AND_PATH, bcc);
    }

    private boolean recalc(BuilderCalculationContext bcc) {
        if (this.incorrectPositions == null) {
            this.incorrectPositions = new HashSet();
            this.fullRecalc(bcc);
            if (this.incorrectPositions.isEmpty()) {
                return false;
            }
        }
        this.recalcNearby(bcc);
        if (this.incorrectPositions.isEmpty()) {
            this.fullRecalc(bcc);
        }
        return !this.incorrectPositions.isEmpty();
    }

    private void trim() {
        HashSet<BetterBlockPos> copy = new HashSet<BetterBlockPos>(this.incorrectPositions);
        copy.removeIf(pos -> pos.method_10262((class_2382)this.ctx.entity().method_24515()) > 200.0);
        if (!copy.isEmpty()) {
            this.incorrectPositions = copy;
        }
    }

    private void recalcNearby(BuilderCalculationContext bcc) {
        BetterBlockPos center = this.ctx.feetPos();
        int radius = this.baritone.settings().builderTickScanRadius.get();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    int x = center.x + dx;
                    int y = center.y + dy;
                    int z = center.z + dz;
                    class_2680 desired = bcc.getSchematic(x, y, z, bcc.bsi.get0(x, y, z));
                    if (desired == null) continue;
                    BetterBlockPos pos = new BetterBlockPos(x, y, z);
                    if (this.valid(bcc.bsi.get0(x, y, z), desired, false)) {
                        this.incorrectPositions.remove((Object)pos);
                        this.observedCompleted.add(BetterBlockPos.longHash(pos));
                        continue;
                    }
                    this.incorrectPositions.add(pos);
                    this.observedCompleted.remove(BetterBlockPos.longHash(pos));
                }
            }
        }
    }

    private void fullRecalc(BuilderCalculationContext bcc) {
        this.incorrectPositions = new HashSet();
        for (int y = 0; y < this.schematic.heightY(); ++y) {
            for (int z = 0; z < this.schematic.lengthZ(); ++z) {
                for (int x = 0; x < this.schematic.widthX(); ++x) {
                    int blockZ;
                    int blockY;
                    int blockX = x + this.origin.method_10263();
                    class_2680 current = bcc.bsi.get0(blockX, blockY = y + this.origin.method_10264(), blockZ = z + this.origin.method_10260());
                    if (!this.schematic.inSchematic(x, y, z, current)) continue;
                    if (bcc.bsi.worldContainsLoadedChunk(blockX, blockZ)) {
                        if (this.valid(bcc.bsi.get0(blockX, blockY, blockZ), this.schematic.desiredState(x, y, z, current, this.approxPlaceable), false)) {
                            this.observedCompleted.add(BetterBlockPos.longHash(blockX, blockY, blockZ));
                            continue;
                        }
                        this.incorrectPositions.add(new BetterBlockPos(blockX, blockY, blockZ));
                        this.observedCompleted.remove(BetterBlockPos.longHash(blockX, blockY, blockZ));
                        if (this.incorrectPositions.size() <= this.baritone.settings().incorrectSize.get()) continue;
                        return;
                    }
                    if (this.observedCompleted.contains(BetterBlockPos.longHash(blockX, blockY, blockZ))) continue;
                    this.incorrectPositions.add(new BetterBlockPos(blockX, blockY, blockZ));
                    if (this.incorrectPositions.size() <= this.baritone.settings().incorrectSize.get()) continue;
                    return;
                }
            }
        }
    }

    private Goal assemble(BuilderCalculationContext bcc, List<class_2680> approxPlaceable) {
        return this.assemble(bcc, approxPlaceable, false);
    }

    private Goal assemble(BuilderCalculationContext bcc, List<class_2680> approxPlaceable, boolean logMissing) {
        ArrayList placeable = new ArrayList();
        ArrayList breakable = new ArrayList();
        ArrayList sourceLiquids = new ArrayList();
        ArrayList flowingLiquids = new ArrayList();
        HashMap missing = new HashMap();
        this.incorrectPositions.forEach(pos -> {
            class_2680 state = bcc.bsi.get0((class_2338)pos);
            if (state.method_26204() instanceof class_2189) {
                if (approxPlaceable.contains(bcc.getSchematic(pos.x, pos.y, pos.z, state))) {
                    placeable.add(pos);
                } else {
                    class_2680 desired = bcc.getSchematic(pos.x, pos.y, pos.z, state);
                    missing.put(desired, 1 + missing.getOrDefault(desired, 0));
                }
            } else if (state.method_26204() instanceof class_2404) {
                if (!MovementHelper.possiblyFlowing(state)) {
                    sourceLiquids.add(pos);
                } else {
                    flowingLiquids.add(pos);
                }
            } else {
                breakable.add(pos);
            }
        });
        ArrayList toBreak = new ArrayList();
        breakable.forEach(pos -> toBreak.add(this.breakGoal((class_2338)pos, bcc)));
        ArrayList toPlace = new ArrayList();
        placeable.forEach(pos -> {
            if (!placeable.contains((Object)pos.down()) && !placeable.contains((Object)pos.down(2))) {
                toPlace.add(this.placementGoal((class_2338)pos, bcc));
            }
        });
        sourceLiquids.forEach(pos -> toPlace.add(new GoalBlock(pos.up())));
        if (!toPlace.isEmpty()) {
            return new JankyGoalComposite(new GoalComposite(toPlace.toArray(new Goal[0])), new GoalComposite(toBreak.toArray(new Goal[0])));
        }
        if (toBreak.isEmpty()) {
            if (logMissing && !missing.isEmpty()) {
                this.logDirect("Missing materials for at least:");
                this.logDirect(missing.entrySet().stream().map(e -> String.format("%sx %s", e.getValue(), e.getKey())).collect(Collectors.joining("\n")));
            }
            if (logMissing && !flowingLiquids.isEmpty()) {
                this.logDirect("Unreplaceable liquids at at least:");
                this.logDirect(flowingLiquids.stream().map(p -> String.format("%s %s %s", p.x, p.y, p.z)).collect(Collectors.joining("\n")));
            }
            return null;
        }
        return new GoalComposite(toBreak.toArray(new Goal[0]));
    }

    private Goal placementGoal(class_2338 pos, BuilderCalculationContext bcc) {
        if (!(this.ctx.world().method_8320(pos).method_26204() instanceof class_2189)) {
            return new GoalPlace(pos);
        }
        boolean allowSameLevel = !(this.ctx.world().method_8320(pos.method_10084()).method_26204() instanceof class_2189);
        class_2680 current = this.ctx.world().method_8320(pos);
        for (class_2350 facing : Movement.HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP) {
            if (!bcc.canPlaceAgainst(pos.method_10093(facing)) || !this.placementPlausible(pos, bcc.getSchematic(pos.method_10263(), pos.method_10264(), pos.method_10260(), current))) continue;
            return new GoalAdjacent(pos, pos.method_10093(facing), allowSameLevel);
        }
        return new GoalPlace(pos);
    }

    private Goal breakGoal(class_2338 pos, BuilderCalculationContext bcc) {
        if (this.baritone.settings().goalBreakFromAbove.get().booleanValue() && bcc.bsi.get0(pos.method_10084()).method_26204() instanceof class_2189 && bcc.bsi.get0(pos.method_10086(2)).method_26204() instanceof class_2189) {
            return new JankyGoalComposite(new GoalBreak(pos), new GoalGetToBlock(pos.method_10084()){

                @Override
                public boolean isInGoal(int x, int y, int z) {
                    if (y > this.y || x == this.x && y == this.y && z == this.z) {
                        return false;
                    }
                    return super.isInGoal(x, y, z);
                }
            });
        }
        return new GoalBreak(pos);
    }

    @Override
    public void onLostControl() {
        this.incorrectPositions = null;
        this.name = null;
        this.schematic = null;
        this.realSchematic = null;
        this.layer = this.baritone.settings().startAtLayer.get();
        this.numRepeats = 0;
        this.paused = false;
        this.observedCompleted = null;
    }

    @Override
    public String displayName0() {
        return this.paused ? "Builder Paused" : "Building " + this.name;
    }

    private List<class_2680> approxPlaceable(int size) {
        ArrayList<class_2680> result = new ArrayList<class_2680>();
        class_1657 player = (class_1657)this.ctx.entity();
        for (int i = 0; i < size; ++i) {
            class_1799 stack = (class_1799)player.method_31548().field_7547.get(i);
            if (stack.method_7960() || !(stack.method_7909() instanceof class_1747)) {
                result.add(class_2246.field_10124.method_9564());
                continue;
            }
            class_2680 placementState = ((class_1747)stack.method_7909()).method_7711().method_9605(new class_1750(new class_1838((class_1937)this.ctx.world(), player, class_1268.field_5808, stack, new class_3965(new class_243(this.ctx.entity().method_23317(), this.ctx.entity().method_23318(), this.ctx.entity().method_23321()), class_2350.field_11036, (class_2338)this.ctx.feetPos(), false)){}));
            if (placementState != null) {
                result.add(placementState);
                continue;
            }
            result.add(class_2246.field_10124.method_9564());
        }
        return result;
    }

    private boolean valid(class_2680 current, class_2680 desired, boolean itemVerify) {
        if (desired == null) {
            return true;
        }
        if (current.method_26204() instanceof class_2404 && this.baritone.settings().okIfWater.get().booleanValue()) {
            return true;
        }
        if (current.method_26215() && desired.method_26215()) {
            return true;
        }
        if (current.method_26215() && desired.method_26164(this.baritone.settings().okIfAir.get())) {
            return true;
        }
        if (desired.method_26215() && current.method_26164(this.baritone.settings().buildIgnoreBlocks.get())) {
            return true;
        }
        if (!current.method_26215() && this.baritone.settings().buildIgnoreExisting.get().booleanValue() && !itemVerify) {
            return true;
        }
        return current.equals(desired);
    }

    public class BuilderCalculationContext
    extends CalculationContext {
        private final List<class_2680> placeable;
        private final ISchematic schematic;
        private final int originX;
        private final int originY;
        private final int originZ;

        public BuilderCalculationContext() {
            super(BuilderProcess.this.baritone, true);
            this.placeable = BuilderProcess.this.approxPlaceable(9);
            this.schematic = BuilderProcess.this.schematic;
            this.originX = BuilderProcess.this.origin.method_10263();
            this.originY = BuilderProcess.this.origin.method_10264();
            this.originZ = BuilderProcess.this.origin.method_10260();
            this.jumpPenalty += 10.0;
            this.backtrackCostFavoringCoefficient = 1.0;
        }

        private class_2680 getSchematic(int x, int y, int z, class_2680 current) {
            if (this.schematic.inSchematic(x - this.originX, y - this.originY, z - this.originZ, current)) {
                return this.schematic.desiredState(x - this.originX, y - this.originY, z - this.originZ, current, BuilderProcess.this.approxPlaceable);
            }
            return null;
        }

        @Override
        public double costOfPlacingAt(int x, int y, int z, class_2680 current) {
            if (this.isProtected(x, y, z)) {
                return 1000000.0;
            }
            class_2680 sch = this.getSchematic(x, y, z, current);
            if (sch != null) {
                if (sch.method_26204() instanceof class_2189) {
                    return this.placeBlockCost * 2.0;
                }
                if (this.placeable.contains(sch)) {
                    return 0.0;
                }
                if (!this.hasThrowaway) {
                    return 1000000.0;
                }
                return this.placeBlockCost * 3.0;
            }
            if (this.hasThrowaway) {
                return this.placeBlockCost;
            }
            return 1000000.0;
        }

        @Override
        public double breakCostMultiplierAt(int x, int y, int z, class_2680 current) {
            if (!this.allowBreak || this.isProtected(x, y, z)) {
                return 1000000.0;
            }
            class_2680 sch = this.getSchematic(x, y, z, current);
            if (sch != null) {
                if (sch.method_26204() instanceof class_2189) {
                    return 1.0;
                }
                if (BuilderProcess.this.valid(this.bsi.get0(x, y, z), sch, false)) {
                    return this.baritone.settings().breakCorrectBlockPenaltyMultiplier.get();
                }
                return 1.0;
            }
            return 1.0;
        }
    }

    public static class Placement {
        private final int hotbarSelection;
        private final class_2338 placeAgainst;
        private final class_2350 side;
        private final Rotation rot;

        public Placement(int hotbarSelection, class_2338 placeAgainst, class_2350 side, Rotation rot) {
            this.hotbarSelection = hotbarSelection;
            this.placeAgainst = placeAgainst;
            this.side = side;
            this.rot = rot;
        }
    }

    public static class JankyGoalComposite
    implements Goal {
        private final Goal primary;
        private final Goal fallback;

        public JankyGoalComposite(Goal primary, Goal fallback) {
            this.primary = primary;
            this.fallback = fallback;
        }

        @Override
        public boolean isInGoal(int x, int y, int z) {
            return this.primary.isInGoal(x, y, z) || this.fallback.isInGoal(x, y, z);
        }

        @Override
        public double heuristic(int x, int y, int z) {
            return this.primary.heuristic(x, y, z);
        }

        public String toString() {
            return "JankyComposite Primary: " + this.primary + " Fallback: " + this.fallback;
        }
    }

    public static class GoalPlace
    extends GoalBlock {
        public GoalPlace(class_2338 placeAt) {
            super(placeAt.method_10084());
        }

        @Override
        public double heuristic(int x, int y, int z) {
            return (double)(this.y * 100) + super.heuristic(x, y, z);
        }
    }

    public static class GoalAdjacent
    extends GoalGetToBlock {
        private boolean allowSameLevel;
        private class_2338 no;

        public GoalAdjacent(class_2338 pos, class_2338 no, boolean allowSameLevel) {
            super(pos);
            this.no = no;
            this.allowSameLevel = allowSameLevel;
        }

        @Override
        public boolean isInGoal(int x, int y, int z) {
            if (x == this.x && y == this.y && z == this.z) {
                return false;
            }
            if (x == this.no.method_10263() && y == this.no.method_10264() && z == this.no.method_10260()) {
                return false;
            }
            if (!this.allowSameLevel && y == this.y - 1) {
                return false;
            }
            if (y < this.y - 1) {
                return false;
            }
            return super.isInGoal(x, y, z);
        }

        @Override
        public double heuristic(int x, int y, int z) {
            return (double)(this.y * 100) + super.heuristic(x, y, z);
        }
    }

    public static class GoalBreak
    extends GoalGetToBlock {
        public GoalBreak(class_2338 pos) {
            super(pos);
        }

        @Override
        public boolean isInGoal(int x, int y, int z) {
            if (y > this.y) {
                return false;
            }
            return super.isInGoal(x, y, z);
        }
    }
}

