/*
 * Decompiled with CFR 0.152.
 */
package f_baritone.process;

import f_baritone.Baritone;
import f_baritone.api.process.PathingCommand;
import f_baritone.api.process.PathingCommandType;
import f_baritone.api.utils.BetterBlockPos;
import f_baritone.api.utils.input.Input;
import f_baritone.pathing.movement.Movement;
import f_baritone.pathing.movement.MovementHelper;
import f_baritone.pathing.movement.MovementState;
import f_baritone.pathing.path.PathExecutor;
import f_baritone.utils.BaritoneProcessHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2812;

public final class BackfillProcess
extends BaritoneProcessHelper {
    public HashMap<class_2338, class_2680> blocksToReplace = new HashMap();

    public BackfillProcess(Baritone baritone) {
        super(baritone);
    }

    @Override
    public boolean isActive() {
        if (this.ctx.entity() == null || this.ctx.world() == null) {
            return false;
        }
        if (!this.baritone.settings().backfill.get().booleanValue()) {
            return false;
        }
        if (this.baritone.settings().allowParkour.get().booleanValue()) {
            this.logDirect("Backfill cannot be used with allowParkour true");
            this.baritone.settings().backfill.set(false);
            return false;
        }
        this.amIBreakingABlockHMMMMMMM();
        for (class_2338 pos : new ArrayList<class_2338>(this.blocksToReplace.keySet())) {
            if (!(this.ctx.world().method_22350(pos) instanceof class_2812)) continue;
            this.blocksToReplace.remove(pos);
        }
        this.baritone.getInputOverrideHandler().clearAllKeys();
        return !this.toFillIn().isEmpty();
    }

    @Override
    public PathingCommand onTick(boolean calcFailed, boolean isSafeToCancel) {
        if (!isSafeToCancel) {
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        this.baritone.getInputOverrideHandler().clearAllKeys();
        block5: for (class_2338 toPlace : this.toFillIn()) {
            MovementState fake = new MovementState();
            switch (MovementHelper.attemptToPlaceABlock(fake, this.baritone, toPlace, false, false)) {
                case NO_OPTION: {
                    continue block5;
                }
                case READY_TO_PLACE: {
                    this.baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_RIGHT, true);
                    return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
                }
                case ATTEMPTING: {
                    this.baritone.getLookBehavior().updateTarget(fake.getTarget().getRotation().get(), true);
                    return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
                }
            }
            throw new IllegalStateException();
        }
        return new PathingCommand(null, PathingCommandType.DEFER);
    }

    private void amIBreakingABlockHMMMMMMM() {
        if (!this.ctx.getSelectedBlock().isPresent()) {
            return;
        }
        this.blocksToReplace.put(this.ctx.getSelectedBlock().get(), this.ctx.world().method_8320(this.ctx.getSelectedBlock().get()));
    }

    public List<class_2338> toFillIn() {
        return this.blocksToReplace.keySet().stream().filter(pos -> this.ctx.world().method_8320(pos).method_26204() == class_2246.field_10124).filter(pos -> this.baritone.getBuilderProcess().placementPlausible((class_2338)pos, class_2246.field_10566.method_9564())).filter(pos -> !this.partOfCurrentMovement((class_2338)pos)).sorted(Comparator.comparingDouble(arg_0 -> ((BetterBlockPos)this.ctx.feetPos()).method_10262(arg_0)).reversed()).collect(Collectors.toList());
    }

    private boolean partOfCurrentMovement(class_2338 pos) {
        PathExecutor exec = this.baritone.getPathingBehavior().getCurrent();
        if (exec == null || exec.finished() || exec.failed()) {
            return false;
        }
        Movement movement = (Movement)exec.getPath().movements().get(exec.getPosition());
        return Arrays.asList(movement.toBreakAll()).contains(pos);
    }

    @Override
    public void onLostControl() {
        if (this.blocksToReplace != null && !this.blocksToReplace.isEmpty()) {
            this.blocksToReplace.clear();
        }
    }

    @Override
    public String displayName0() {
        return "Backfill";
    }

    @Override
    public boolean isTemporary() {
        return true;
    }

    @Override
    public double priority() {
        return 5.0;
    }
}

