/*
 * Decompiled with CFR 0.152.
 */
package f_baritone.pathing.path;

import f_baritone.Automatone;
import f_baritone.Baritone;
import f_baritone.api.IBaritone;
import f_baritone.api.Settings;
import f_baritone.api.pathing.calc.IPath;
import f_baritone.api.pathing.movement.IMovement;
import f_baritone.api.pathing.movement.MovementStatus;
import f_baritone.api.pathing.path.IPathExecutor;
import f_baritone.api.utils.BetterBlockPos;
import f_baritone.api.utils.IEntityContext;
import f_baritone.api.utils.RotationUtils;
import f_baritone.api.utils.VecUtils;
import f_baritone.api.utils.input.Input;
import f_baritone.behavior.PathingBehavior;
import f_baritone.pathing.calc.AbstractNodeCostSearch;
import f_baritone.pathing.movement.CalculationContext;
import f_baritone.pathing.movement.Movement;
import f_baritone.pathing.movement.MovementHelper;
import f_baritone.pathing.movement.movements.MovementAscend;
import f_baritone.pathing.movement.movements.MovementDescend;
import f_baritone.pathing.movement.movements.MovementDiagonal;
import f_baritone.pathing.movement.movements.MovementFall;
import f_baritone.pathing.movement.movements.MovementTraverse;
import f_baritone.pathing.path.CutoffPath;
import f_baritone.pathing.path.SplicedPath;
import f_baritone.utils.BlockStateInterface;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_3545;

public class PathExecutor
implements IPathExecutor {
    private static final double MAX_MAX_DIST_FROM_PATH = 3.0;
    private static final double MAX_DIST_FROM_PATH = 2.0;
    private static final double MAX_TICKS_AWAY = 200.0;
    private final IPath path;
    private int pathPosition;
    private int ticksAway;
    private int ticksOnCurrent;
    private Double currentMovementOriginalCostEstimate;
    private Integer costEstimateIndex;
    private boolean failed;
    private boolean recalcBP = true;
    private HashSet<class_2338> toBreak = new HashSet();
    private HashSet<class_2338> toPlace = new HashSet();
    private HashSet<class_2338> toWalkInto = new HashSet();
    private final PathingBehavior behavior;
    private final IEntityContext ctx;
    private boolean sprintNextTick;

    public PathExecutor(PathingBehavior behavior, IPath path) {
        this.behavior = behavior;
        this.ctx = behavior.ctx;
        this.path = path;
        this.pathPosition = 0;
    }

    public void logDebug(String message) {
        this.ctx.logDebug(message);
    }

    public boolean onTick() {
        double currentCost;
        class_3545<Double, class_2338> status;
        if (this.pathPosition == this.path.length() - 1) {
            ++this.pathPosition;
        }
        if (this.pathPosition >= this.path.length()) {
            return true;
        }
        Movement movement = (Movement)this.path.movements().get(this.pathPosition);
        BetterBlockPos whereAmI = this.ctx.feetPos();
        if (!movement.getValidPositions().contains((Object)whereAmI)) {
            for (int i = this.pathPosition + 3; i < this.path.length() - 1; ++i) {
                if (!((Movement)this.path.movements().get(i)).getValidPositions().contains((Object)whereAmI)) continue;
                if (i - this.pathPosition > 2) {
                    this.logDebug("Skipping forward " + (i - this.pathPosition) + " steps, to " + i);
                }
                this.pathPosition = i - 1;
                this.onChangeInPathPosition();
                this.onTick();
                return false;
            }
        }
        if (this.possiblyOffPath(status = this.closestPathPos(this.path), 2.0)) {
            ++this.ticksAway;
            Automatone.LOGGER.warn("FAR AWAY FROM PATH FOR " + this.ticksAway + " TICKS. Current distance: " + status.method_15442() + ". Threshold: 2.0");
            if ((double)this.ticksAway > 200.0) {
                this.logDebug("Too far away from path for too long, cancelling path");
                this.cancel();
                return false;
            }
        } else {
            this.ticksAway = 0;
        }
        if (this.possiblyOffPath(status, 3.0)) {
            this.logDebug("too far from path");
            this.cancel();
            return false;
        }
        BlockStateInterface bsi = new BlockStateInterface(this.ctx);
        for (int i = this.pathPosition - 10; i < this.pathPosition + 10; ++i) {
            if (i < 0 || i >= this.path.movements().size()) continue;
            Movement m = (Movement)this.path.movements().get(i);
            List<class_2338> prevBreak = m.toBreak(bsi);
            List<class_2338> prevPlace = m.toPlace(bsi);
            List<class_2338> prevWalkInto = m.toWalkInto(bsi);
            m.resetBlockCache();
            if (!prevBreak.equals(m.toBreak(bsi))) {
                this.recalcBP = true;
            }
            if (!prevPlace.equals(m.toPlace(bsi))) {
                this.recalcBP = true;
            }
            if (prevWalkInto.equals(m.toWalkInto(bsi))) continue;
            this.recalcBP = true;
        }
        if (this.recalcBP) {
            HashSet<class_2338> newBreak = new HashSet<class_2338>();
            HashSet<class_2338> newPlace = new HashSet<class_2338>();
            HashSet<class_2338> newWalkInto = new HashSet<class_2338>();
            for (int i = this.pathPosition; i < this.path.movements().size(); ++i) {
                Movement m = (Movement)this.path.movements().get(i);
                newBreak.addAll(m.toBreak(bsi));
                newPlace.addAll(m.toPlace(bsi));
                newWalkInto.addAll(m.toWalkInto(bsi));
            }
            this.toBreak = newBreak;
            this.toPlace = newPlace;
            this.toWalkInto = newWalkInto;
            this.recalcBP = false;
        }
        Baritone baritone = this.behavior.baritone;
        if (this.pathPosition < this.path.movements().size() - 1) {
            IMovement next = this.path.movements().get(this.pathPosition + 1);
            if (!baritone.bsi.worldContainsLoadedChunk(next.getDest().x, next.getDest().z)) {
                this.logDebug("Pausing since destination is at edge of loaded chunks");
                this.clearKeys();
                return true;
            }
        }
        boolean canCancel = movement.safeToCancel();
        if (this.costEstimateIndex == null || this.costEstimateIndex != this.pathPosition) {
            this.costEstimateIndex = this.pathPosition;
            this.currentMovementOriginalCostEstimate = movement.getCost();
            for (int i = 1; i < baritone.settings().costVerificationLookahead.get() && this.pathPosition + i < this.path.length() - 1; ++i) {
                if (!(((Movement)this.path.movements().get(this.pathPosition + i)).calculateCost(this.behavior.secretInternalGetCalculationContext()) >= 1000000.0) || !canCancel) continue;
                this.logDebug("Something has changed in the world and a future movement has become impossible. Cancelling.");
                this.cancel();
                return true;
            }
        }
        if ((currentCost = movement.recalculateCost(this.behavior.secretInternalGetCalculationContext())) >= 1000000.0 && canCancel) {
            this.logDebug("Something has changed in the world and this movement has become impossible. Cancelling.");
            this.cancel();
            return true;
        }
        if (!movement.calculatedWhileLoaded() && currentCost - this.currentMovementOriginalCostEstimate > baritone.settings().maxCostIncrease.get() && canCancel) {
            this.logDebug("Original cost " + this.currentMovementOriginalCostEstimate + " current cost " + currentCost + ". Cancelling.");
            this.cancel();
            return true;
        }
        if (this.shouldPause()) {
            this.logDebug("Pausing since current best path is a backtrack");
            this.clearKeys();
            return true;
        }
        MovementStatus movementStatus = movement.update();
        if (movementStatus == MovementStatus.UNREACHABLE || movementStatus == MovementStatus.FAILED) {
            this.logDebug("Movement returns status " + movementStatus);
            this.cancel();
            return true;
        }
        if (movementStatus == MovementStatus.SUCCESS) {
            ++this.pathPosition;
            this.onChangeInPathPosition();
            this.onTick();
            return true;
        }
        this.ctx.entity().method_5728(this.shouldSprintNextTick());
        ++this.ticksOnCurrent;
        if ((double)this.ticksOnCurrent > this.currentMovementOriginalCostEstimate + (double)baritone.settings().movementTimeoutTicks.get().intValue()) {
            this.logDebug("This movement has taken too long (" + this.ticksOnCurrent + " ticks, expected " + this.currentMovementOriginalCostEstimate + "). Cancelling.");
            this.cancel();
            return true;
        }
        return canCancel;
    }

    private class_3545<Double, class_2338> closestPathPos(IPath path) {
        double best = -1.0;
        class_2338 bestPos = null;
        for (IMovement movement : path.movements()) {
            for (class_2338 class_23382 : ((Movement)movement).getValidPositions()) {
                double dist = VecUtils.entityDistanceToCenter((class_1297)this.ctx.entity(), class_23382);
                if (!(dist < best) && best != -1.0) continue;
                best = dist;
                bestPos = class_23382;
            }
        }
        return new class_3545((Object)best, bestPos);
    }

    private boolean shouldPause() {
        Optional<AbstractNodeCostSearch> current = this.behavior.getInProgress();
        if (!current.isPresent()) {
            return false;
        }
        if (!this.ctx.entity().method_24828()) {
            return false;
        }
        if (!MovementHelper.canWalkOn(this.ctx, this.ctx.feetPos().down())) {
            return false;
        }
        if (!MovementHelper.canWalkThrough(this.ctx, this.ctx.feetPos()) || !MovementHelper.canWalkThrough(this.ctx, this.ctx.feetPos().up())) {
            return false;
        }
        if (!this.path.movements().get(this.pathPosition).safeToCancel()) {
            return false;
        }
        Optional<IPath> currentBest = current.get().bestPathSoFar();
        if (!currentBest.isPresent()) {
            return false;
        }
        List<BetterBlockPos> positions = currentBest.get().positions();
        if (positions.size() < 3) {
            return false;
        }
        positions = positions.subList(1, positions.size());
        return positions.contains((Object)this.ctx.feetPos());
    }

    private boolean possiblyOffPath(class_3545<Double, class_2338> status, double leniency) {
        double distanceFromPath = (Double)status.method_15442();
        if (distanceFromPath > leniency) {
            if (this.path.movements().get(this.pathPosition) instanceof MovementFall) {
                class_2338 fallDest = this.path.positions().get(this.pathPosition + 1);
                return VecUtils.entityFlatDistanceToCenter((class_1297)this.ctx.entity(), fallDest) >= leniency;
            }
            return true;
        }
        return false;
    }

    public boolean snipsnapifpossible() {
        if (!this.ctx.entity().method_24828() && this.ctx.world().method_8316((class_2338)this.ctx.feetPos()).method_15769()) {
            return false;
        }
        if (this.ctx.entity().method_18798().field_1351 < -0.1) {
            return false;
        }
        int index = this.path.positions().indexOf((Object)this.ctx.feetPos());
        if (index == -1) {
            return false;
        }
        this.pathPosition = index;
        this.clearKeys();
        return true;
    }

    private boolean shouldSprintNextTick() {
        class_3545<class_243, class_2338> data;
        IMovement prev;
        IMovement next;
        boolean requested = this.behavior.baritone.getInputOverrideHandler().isInputForcedDown(Input.SPRINT);
        this.behavior.baritone.getInputOverrideHandler().setInputForceState(Input.SPRINT, false);
        if (!new CalculationContext((IBaritone)this.behavior.baritone).canSprint) {
            return false;
        }
        IMovement current = this.path.movements().get(this.pathPosition);
        if (current instanceof MovementTraverse && this.pathPosition < this.path.length() - 3 && (next = this.path.movements().get(this.pathPosition + 1)) instanceof MovementAscend && this.behavior.baritone.settings().sprintAscends.get().booleanValue() && PathExecutor.sprintableAscend(this.ctx, (MovementTraverse)current, (MovementAscend)next, this.path.movements().get(this.pathPosition + 2))) {
            if (PathExecutor.skipNow(this.ctx, current)) {
                this.logDebug("Skipping traverse to straight ascend");
                ++this.pathPosition;
                this.onChangeInPathPosition();
                this.onTick();
                this.behavior.baritone.getInputOverrideHandler().setInputForceState(Input.JUMP, true);
                return true;
            }
            this.logDebug("Too far to the side to safely sprint ascend");
        }
        if (current instanceof MovementDiagonal && this.ctx.entity().method_5869() && this.ctx.world().method_8320((class_2338)this.ctx.feetPos().up()).method_26227().method_15769()) {
            return false;
        }
        if (requested) {
            return true;
        }
        if (current instanceof MovementDescend) {
            if (((MovementDescend)current).safeMode() && !((MovementDescend)current).skipToAscend()) {
                this.logDebug("Sprinting would be unsafe");
                return false;
            }
            if (this.pathPosition < this.path.length() - 2) {
                next = this.path.movements().get(this.pathPosition + 1);
                if (next instanceof MovementAscend && current.getDirection().method_10084().equals((Object)next.getDirection().method_10074())) {
                    ++this.pathPosition;
                    this.onChangeInPathPosition();
                    this.onTick();
                    this.logDebug("Skipping descend to straight ascend");
                    return true;
                }
                if (PathExecutor.canSprintFromDescendInto(this.ctx, current, next, this.behavior.baritone.settings())) {
                    if (this.ctx.feetPos().equals((Object)current.getDest())) {
                        ++this.pathPosition;
                        this.onChangeInPathPosition();
                        this.onTick();
                    }
                    return true;
                }
            }
        }
        if (current instanceof MovementAscend && this.pathPosition != 0) {
            prev = this.path.movements().get(this.pathPosition - 1);
            if (prev instanceof MovementDescend && prev.getDirection().method_10084().equals((Object)current.getDirection().method_10074())) {
                BetterBlockPos center = current.getSrc().up();
                if (this.ctx.entity().method_23318() >= (double)center.method_10264() - 0.07) {
                    this.behavior.baritone.getInputOverrideHandler().setInputForceState(Input.JUMP, false);
                    return true;
                }
            }
            if (this.pathPosition < this.path.length() - 2 && prev instanceof MovementTraverse && PathExecutor.sprintableAscend(this.ctx, (MovementTraverse)prev, (MovementAscend)current, this.path.movements().get(this.pathPosition + 1))) {
                return true;
            }
            if (this.pathPosition < this.path.length() - 1 && (prev.getDirection().method_10263() != 0 || prev.getDirection().method_10260() != 0) && this.ctx.entity().method_5869()) {
                return true;
            }
        }
        if (current instanceof MovementTraverse && this.ctx.entity().method_5869() && this.pathPosition != 0) {
            prev = this.path.movements().get(this.pathPosition - 1);
            return (prev.getDirection().method_10263() != 0 || prev.getDirection().method_10260() != 0) && !this.ctx.world().method_8320((class_2338)this.ctx.feetPos().up()).method_26227().method_15769();
        }
        if (current instanceof MovementFall && (data = this.overrideFall((MovementFall)current)) != null) {
            BetterBlockPos fallDest = new BetterBlockPos((class_2338)data.method_15441());
            if (!this.path.positions().contains((Object)fallDest)) {
                throw new IllegalStateException();
            }
            if (this.ctx.feetPos().equals((Object)fallDest)) {
                this.pathPosition = this.path.positions().indexOf((Object)fallDest);
                this.onChangeInPathPosition();
                this.onTick();
                return true;
            }
            this.clearKeys();
            this.behavior.baritone.getLookBehavior().updateTarget(RotationUtils.calcRotationFromVec3d(this.ctx.headPos(), (class_243)data.method_15442(), this.ctx.entityRotations()), false);
            this.behavior.baritone.getInputOverrideHandler().setInputForceState(Input.MOVE_FORWARD, true);
            return true;
        }
        return false;
    }

    private class_3545<class_243, class_2338> overrideFall(MovementFall movement) {
        IMovement next;
        int i;
        class_2338 dir = movement.getDirection();
        if (dir.method_10264() < -3) {
            return null;
        }
        if (!movement.toBreakCached.isEmpty()) {
            return null;
        }
        class_2382 flatDir = new class_2382(dir.method_10263(), 0, dir.method_10260());
        block0: for (i = this.pathPosition + 1; i < this.path.length() - 1 && i < this.pathPosition + 3 && (next = this.path.movements().get(i)) instanceof MovementTraverse && flatDir.equals((Object)next.getDirection()); ++i) {
            for (int y = next.getDest().y; y <= movement.getSrc().y + 1; ++y) {
                class_2338 chk = new class_2338(next.getDest().x, y, next.getDest().z);
                if (!MovementHelper.fullyPassable(this.ctx, chk)) break block0;
            }
            if (!MovementHelper.canWalkOn(this.ctx, next.getDest().down())) break;
        }
        if (--i == this.pathPosition) {
            return null;
        }
        double len = (double)(i - this.pathPosition) - 0.4;
        return new class_3545((Object)new class_243((double)flatDir.method_10263() * len + (double)movement.getDest().x + 0.5, (double)movement.getDest().y, (double)flatDir.method_10260() * len + (double)movement.getDest().z + 0.5), (Object)movement.getDest().method_10069(flatDir.method_10263() * (i - this.pathPosition), 0, flatDir.method_10260() * (i - this.pathPosition)));
    }

    private static boolean skipNow(IEntityContext ctx, IMovement current) {
        double offTarget = Math.abs((double)current.getDirection().method_10263() * ((double)current.getSrc().z + 0.5 - ctx.entity().method_23321())) + Math.abs((double)current.getDirection().method_10260() * ((double)current.getSrc().x + 0.5 - ctx.entity().method_23317()));
        if (offTarget > 0.1) {
            return false;
        }
        class_2338 headBonk = current.getSrc().method_10059((class_2382)current.getDirection()).method_10086(2);
        if (MovementHelper.fullyPassable(ctx, headBonk)) {
            return true;
        }
        double flatDist = Math.abs((double)current.getDirection().method_10263() * ((double)headBonk.method_10263() + 0.5 - ctx.entity().method_23317())) + Math.abs((double)current.getDirection().method_10260() * ((double)headBonk.method_10260() + 0.5 - ctx.entity().method_23321()));
        return flatDist > 0.8;
    }

    private static boolean sprintableAscend(IEntityContext ctx, MovementTraverse current, MovementAscend next, IMovement nextnext) {
        if (!current.getDirection().equals((Object)next.getDirection().method_10074())) {
            return false;
        }
        if (nextnext.getDirection().method_10263() != next.getDirection().method_10263() || nextnext.getDirection().method_10260() != next.getDirection().method_10260()) {
            return false;
        }
        if (!MovementHelper.canWalkOn(ctx, current.getDest().down())) {
            return false;
        }
        if (!MovementHelper.canWalkOn(ctx, next.getDest().down())) {
            return false;
        }
        if (!next.toBreakCached.isEmpty()) {
            return false;
        }
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 3; ++y) {
                BetterBlockPos chk = current.getSrc().up(y);
                if (x == 1) {
                    chk = chk.method_10081((class_2382)current.getDirection());
                }
                if (MovementHelper.fullyPassable(ctx, chk)) continue;
                return false;
            }
        }
        if (MovementHelper.avoidWalkingInto(ctx.world().method_8320((class_2338)current.getSrc().up(3)))) {
            return false;
        }
        return !MovementHelper.avoidWalkingInto(ctx.world().method_8320((class_2338)next.getDest().up(2)));
    }

    private static boolean canSprintFromDescendInto(IEntityContext ctx, IMovement current, IMovement next, Settings settings) {
        if (next instanceof MovementDescend && next.getDirection().equals((Object)current.getDirection())) {
            return true;
        }
        if (!MovementHelper.canWalkOn(ctx, current.getDest().method_10081((class_2382)current.getDirection()))) {
            return false;
        }
        if (next instanceof MovementTraverse && next.getDirection().method_10074().equals((Object)current.getDirection())) {
            return true;
        }
        return next instanceof MovementDiagonal && settings.allowOvershootDiagonalDescend.get() != false;
    }

    private void onChangeInPathPosition() {
        this.clearKeys();
        this.ticksOnCurrent = 0;
    }

    private void clearKeys() {
        this.behavior.baritone.getInputOverrideHandler().clearAllKeys();
    }

    private void cancel() {
        this.clearKeys();
        this.behavior.baritone.getInputOverrideHandler().getBlockBreakHelper().stopBreakingBlock();
        this.pathPosition = this.path.length() + 3;
        this.failed = true;
    }

    @Override
    public int getPosition() {
        return this.pathPosition;
    }

    public PathExecutor trySplice(PathExecutor next) {
        if (next == null) {
            return this.cutIfTooLong();
        }
        return SplicedPath.trySplice(this.path, next.path, false).map(path -> {
            if (!path.getDest().equals((Object)next.getPath().getDest())) {
                throw new IllegalStateException();
            }
            PathExecutor ret = new PathExecutor(this.behavior, (IPath)path);
            ret.pathPosition = this.pathPosition;
            ret.currentMovementOriginalCostEstimate = this.currentMovementOriginalCostEstimate;
            ret.costEstimateIndex = this.costEstimateIndex;
            ret.ticksOnCurrent = this.ticksOnCurrent;
            return ret;
        }).orElseGet(this::cutIfTooLong);
    }

    private PathExecutor cutIfTooLong() {
        if (this.pathPosition > this.behavior.baritone.settings().maxPathHistoryLength.get()) {
            int cutoffAmt = this.behavior.baritone.settings().pathHistoryCutoffAmount.get();
            CutoffPath newPath = new CutoffPath(this.path, cutoffAmt, this.path.length() - 1);
            if (!newPath.getDest().equals((Object)this.path.getDest())) {
                throw new IllegalStateException();
            }
            this.logDebug("Discarding earliest segment movements, length cut from " + this.path.length() + " to " + newPath.length());
            PathExecutor ret = new PathExecutor(this.behavior, newPath);
            ret.pathPosition = this.pathPosition - cutoffAmt;
            ret.currentMovementOriginalCostEstimate = this.currentMovementOriginalCostEstimate;
            if (this.costEstimateIndex != null) {
                ret.costEstimateIndex = this.costEstimateIndex - cutoffAmt;
            }
            ret.ticksOnCurrent = this.ticksOnCurrent;
            return ret;
        }
        return this;
    }

    @Override
    public IPath getPath() {
        return this.path;
    }

    public boolean failed() {
        return this.failed;
    }

    public boolean finished() {
        return this.pathPosition >= this.path.length();
    }

    public Set<class_2338> toBreak() {
        return Collections.unmodifiableSet(this.toBreak);
    }

    public Set<class_2338> toPlace() {
        return Collections.unmodifiableSet(this.toPlace);
    }

    public Set<class_2338> toWalkInto() {
        return Collections.unmodifiableSet(this.toWalkInto);
    }

    public boolean isSprinting() {
        return this.sprintNextTick;
    }

    public static void writeToPacket(PathExecutor p, class_2540 buf) {
        if (p == null) {
            buf.writeInt(-1);
            return;
        }
        buf.writeInt(p.pathPosition);
        PathExecutor.writePositions(p.getPath().positions(), buf);
        PathExecutor.writePositions(p.toBreak(), buf);
        PathExecutor.writePositions(p.toPlace(), buf);
        PathExecutor.writePositions(p.toWalkInto(), buf);
    }

    private static void writePositions(Collection<? extends class_2338> positions, class_2540 buf) {
        buf.method_10804(positions.size());
        for (class_2338 class_23382 : positions) {
            buf.method_10807(class_23382);
        }
    }
}

