/*
 * Decompiled with CFR 0.152.
 */
package f_baritone.pathing.movement.movements;

import com.google.common.collect.ImmutableSet;
import f_baritone.api.IBaritone;
import f_baritone.api.pathing.movement.MovementStatus;
import f_baritone.api.utils.BetterBlockPos;
import f_baritone.api.utils.Rotation;
import f_baritone.api.utils.RotationUtils;
import f_baritone.api.utils.VecUtils;
import f_baritone.api.utils.input.Input;
import f_baritone.pathing.movement.CalculationContext;
import f_baritone.pathing.movement.Movement;
import f_baritone.pathing.movement.MovementHelper;
import f_baritone.pathing.movement.MovementState;
import f_baritone.utils.BlockStateInterface;
import f_baritone.utils.pathing.MutableMoveResult;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3621;
import net.minecraft.class_4048;
import net.minecraft.class_4050;

public class MovementTraverse
extends Movement {
    private boolean wasTheBridgeBlockAlwaysThere = true;

    public MovementTraverse(IBaritone baritone, BetterBlockPos from, BetterBlockPos to) {
        super(baritone, from, to, MovementTraverse.buildPositionsToBreak((class_1297)baritone.getPlayerContext().entity(), from, to), to.down());
    }

    @Override
    public void reset() {
        super.reset();
        this.wasTheBridgeBlockAlwaysThere = true;
    }

    @Override
    public double calculateCost(CalculationContext context) {
        MutableMoveResult result = new MutableMoveResult();
        MovementTraverse.cost(context, this.src.x, this.src.y, this.src.z, this.dest.x, this.dest.z, result);
        return result.cost;
    }

    @Override
    protected Set<BetterBlockPos> calculateValidPositions() {
        return ImmutableSet.of((Object)((Object)this.src), (Object)((Object)this.dest));
    }

    public static BetterBlockPos[] buildPositionsToBreak(class_1297 e, BetterBlockPos from, BetterBlockPos to) {
        int x = from.x;
        int y = from.y;
        int z = from.z;
        int destX = to.x;
        int destZ = to.z;
        int diffX = destX - x;
        int diffZ = destZ - z;
        class_4048 dimensions = e.method_18377(class_4050.field_18076);
        int requiredSideSpace = CalculationContext.getRequiredSideSpace(dimensions);
        int checkedXShift = diffX * requiredSideSpace;
        int checkedZShift = diffZ * requiredSideSpace;
        int checkedX = destX + checkedXShift;
        int checkedZ = destZ + checkedZShift;
        int height = class_3532.method_15386((float)dimensions.field_18068);
        int requiredForwardSpace = requiredSideSpace == 0 ? 1 : 2;
        int volume = requiredForwardSpace * (requiredSideSpace * 2 + 1) * height;
        int i = 0;
        BetterBlockPos[] ret = new BetterBlockPos[volume];
        for (int df = 0; df < requiredForwardSpace; ++df) {
            for (int ds = -requiredSideSpace; ds <= requiredSideSpace; ++ds) {
                for (int dy = 0; dy < height; ++dy) {
                    ret[i++] = new BetterBlockPos(checkedX + diffZ * ds - diffX * df, y + dy, checkedZ + diffX * ds - diffZ * df);
                }
            }
        }
        return ret;
    }

    public static void cost(CalculationContext context, int x, int y, int z, int destX, int destZ, MutableMoveResult result) {
        class_2680 destOn = context.get(destX, y - 1, destZ);
        class_2680 srcOn = context.get(x, y - 1, z);
        class_2248 srcOnBlock = srcOn.method_26204();
        int movX = destX - x;
        int movZ = destZ - z;
        int checkedXShift = movX * context.requiredSideSpace;
        int checkedZShift = movZ * context.requiredSideSpace;
        int checkedX = destX + checkedXShift;
        int checkedZ = destZ + checkedZShift;
        if (MovementHelper.canWalkOn(context.bsi, destX, y - 1, destZ, destOn, context.baritone.settings())) {
            double WC = 0.0;
            boolean water = false;
            class_2680 destHeadState = context.get(destX, y + context.height - 1, destZ);
            if (MovementHelper.isWater(destHeadState)) {
                WC = context.waterWalkSpeed;
                water = true;
            } else {
                for (int dy = 0; dy < context.height - 1; ++dy) {
                    if (!MovementHelper.isWater(context.get(destX, y + dy, destZ))) continue;
                    WC = context.waterWalkSpeed;
                    water = true;
                    break;
                }
            }
            if (!water) {
                WC = destOn.method_26204() == class_2246.field_10382 ? context.walkOnWaterOnePenalty : 4.63284688441047 / (double)destOn.method_26204().method_23349() / 2.0;
                WC += 4.63284688441047 / (double)srcOnBlock.method_23349() / 2.0;
            }
            double hardness = 0.0;
            class_2680 srcHeadState = context.get(x, y + context.height - 1, z);
            int hardnessModifier = MovementHelper.isWater(srcHeadState) || srcOnBlock == class_2246.field_9983 || srcOnBlock == class_2246.field_10597 ? 5 : 1;
            for (int dxz = -context.requiredSideSpace; dxz <= context.requiredSideSpace; ++dxz) {
                for (int dy = 0; dy < context.height; ++dy) {
                    if (!((hardness += MovementHelper.getMiningDurationTicks(context, checkedX + dxz * movZ, y + dy, checkedZ + dxz * movX, dy == context.height - 1) * (double)hardnessModifier) >= 1000000.0)) continue;
                    return;
                }
            }
            if (hardness == 0.0 && !water && context.canSprint) {
                WC *= 0.7692444761225944;
            }
            result.cost = WC + hardness;
            result.oxygenCost = context.oxygenCost(WC / 2.0 + hardness, srcHeadState) + context.oxygenCost(WC / 2.0, destHeadState);
        } else {
            if (srcOnBlock == class_2246.field_9983 || srcOnBlock == class_2246.field_10597) {
                return;
            }
            if (MovementHelper.isReplaceable(destX, y - 1, destZ, destOn, context.bsi)) {
                double placeCost;
                boolean throughWater = false;
                for (int dy = 0; dy < context.height; ++dy) {
                    if (!MovementHelper.isWater(context.get(destX, y + dy, destZ))) continue;
                    throughWater = true;
                    if (!MovementHelper.isWater(destOn)) break;
                    return;
                }
                if ((placeCost = context.costOfPlacingAt(destX, y - 1, destZ, destOn)) >= 1000000.0) {
                    return;
                }
                double hardness = 0.0;
                for (int dxz = -context.requiredSideSpace; dxz <= context.requiredSideSpace; ++dxz) {
                    for (int dy = 0; dy < context.height; ++dy) {
                        if (!((hardness += MovementHelper.getMiningDurationTicks(context, checkedX + dxz * movZ, y + dy, checkedZ + dxz * movX, dy == context.height - 1)) >= 1000000.0)) continue;
                        return;
                    }
                }
                double WC = throughWater ? context.waterWalkSpeed : 4.63284688441047;
                for (int i = 0; i < 5; ++i) {
                    int againstX = destX + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].method_10148();
                    int againstY = y - 1 + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].method_10164();
                    int againstZ = destZ + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].method_10165();
                    if (againstX == x && againstZ == z || !MovementHelper.canPlaceAgainst(context.bsi, againstX, againstY, againstZ)) continue;
                    result.cost = WC + placeCost + hardness;
                    return;
                }
                if (!srcOn.method_45474() && !srcOn.method_26234((class_1922)context.world, class_2338.field_10980)) {
                    return;
                }
                if (srcOn.method_26227().method_15772() instanceof class_3621) {
                    return;
                }
                result.cost = (WC *= 3.3207692307692307) + placeCost + hardness;
                result.oxygenCost = context.oxygenCost(result.cost, class_2246.field_10124.method_9564());
            }
        }
    }

    private boolean tryOpenDoors(MovementState state, class_2680 bs, BetterBlockPos dest, BetterBlockPos src) {
        if (bs.method_26204() instanceof class_2323) {
            boolean notPassable = bs.method_26204() instanceof class_2323 && !MovementHelper.isDoorPassable(this.ctx, dest, src);
            boolean canOpen = class_2323.method_24796((class_2680)bs);
            if (notPassable && canOpen) {
                state.setTarget(new MovementState.MovementTarget(RotationUtils.calcRotationFromVec3d(this.ctx.headPos(), VecUtils.calculateBlockCenter((class_1937)this.ctx.world(), dest.up()), this.ctx.entityRotations()), true)).setInput(Input.CLICK_RIGHT, true);
                return true;
            }
        } else if (bs.method_26204() instanceof class_2349) {
            Optional<Rotation> rotation;
            BetterBlockPos blocked;
            BetterBlockPos betterBlockPos = !MovementHelper.isGatePassable(this.ctx, dest.up(), src.up()) ? dest.up() : (blocked = !MovementHelper.isGatePassable(this.ctx, dest, src) ? dest : null);
            if (blocked != null && (rotation = RotationUtils.reachable(this.ctx, blocked)).isPresent()) {
                state.setTarget(new MovementState.MovementTarget(rotation.get(), true)).setInput(Input.CLICK_RIGHT, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean safeToCancel(MovementState state) {
        return state.getStatus() != MovementStatus.RUNNING || MovementHelper.canWalkOn(this.ctx, this.dest.down());
    }

    @Override
    protected boolean prepared(MovementState state) {
        class_2248 block;
        if ((this.ctx.feetPos().equals((Object)this.src) || this.ctx.feetPos().equals((Object)this.src.down())) && ((block = BlockStateInterface.getBlock(this.ctx, this.src.down())) == class_2246.field_9983 || block == class_2246.field_10597)) {
            state.setInput(Input.SNEAK, true);
        }
        return super.prepared(state);
    }
}

