/*
 * Decompiled with CFR 0.152.
 */
package f_baritone.pathing.movement.movements;

import f_baritone.api.IBaritone;
import f_baritone.api.pathing.movement.MovementStatus;
import f_baritone.api.utils.BetterBlockPos;
import f_baritone.pathing.movement.CalculationContext;
import f_baritone.pathing.movement.Movement;
import f_baritone.pathing.movement.MovementHelper;
import f_baritone.pathing.movement.MovementState;
import f_baritone.utils.BlockStateInterface;
import f_baritone.utils.pathing.MutableMoveResult;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_3612;
import net.minecraft.class_3621;

public class MovementParkour
extends Movement {
    private static final BetterBlockPos[] EMPTY = new BetterBlockPos[0];
    private final class_2350 direction;
    private final int dist;
    private final boolean ascend;

    private MovementParkour(IBaritone baritone, BetterBlockPos src, int dist, class_2350 dir, boolean ascend) {
        super(baritone, src, src.offset(dir, dist).up(ascend ? 1 : 0), EMPTY, src.offset(dir, dist).down(ascend ? 0 : 1));
        this.direction = dir;
        this.dist = dist;
        this.ascend = ascend;
    }

    public static MovementParkour cost(CalculationContext context, BetterBlockPos src, class_2350 direction) {
        MutableMoveResult res = new MutableMoveResult();
        MovementParkour.cost(context, src.x, src.y, src.z, direction, res);
        int dist = Math.abs(res.x - src.x) + Math.abs(res.z - src.z);
        return new MovementParkour(context.getBaritone(), src, dist, direction, res.y > src.y);
    }

    public static void cost(CalculationContext context, int x, int y, int z, class_2350 dir, MutableMoveResult res) {
        int zDiff;
        if (!context.allowParkour) {
            return;
        }
        if (context.height > 2 || context.width > 1) {
            return;
        }
        if (y == context.worldTop && !context.allowJumpAt256) {
            return;
        }
        int xDiff = dir.method_10148();
        if (!MovementHelper.fullyPassable(context, x + xDiff, y, z + (zDiff = dir.method_10165()))) {
            return;
        }
        class_2680 adj = context.get(x + xDiff, y - 1, z + zDiff);
        if (MovementHelper.canWalkOn(context.bsi, x + xDiff, y - 1, z + zDiff, adj, context.baritone.settings())) {
            return;
        }
        if (MovementHelper.avoidWalkingInto(adj) && !(adj.method_26227().method_15772() instanceof class_3621)) {
            return;
        }
        if (!MovementHelper.fullyPassable(context, x + xDiff, y + 1, z + zDiff)) {
            return;
        }
        if (!MovementHelper.fullyPassable(context, x + xDiff, y + 2, z + zDiff)) {
            return;
        }
        if (!MovementHelper.fullyPassable(context, x, y + 2, z)) {
            return;
        }
        class_2680 standingOn = context.get(x, y - 1, z);
        if (standingOn.method_26204() == class_2246.field_10597 || standingOn.method_26204() == class_2246.field_9983 || standingOn.method_26204() instanceof class_2510 || MovementHelper.isBottomSlab(standingOn) || standingOn.method_26227().method_15772() != class_3612.field_15906) {
            return;
        }
        int maxJump = (double)standingOn.method_26204().method_23349() < 0.8 ? 2 : (context.canSprint ? 4 : 3);
        boolean smol = context.height <= 1;
        for (int i = 2; i <= maxJump; ++i) {
            int destX = x + xDiff * i;
            int destZ = z + zDiff * i;
            if (!MovementHelper.fullyPassable(context, destX, y + 1, destZ)) {
                return;
            }
            if (!smol && !MovementHelper.fullyPassable(context, destX, y + 2, destZ)) {
                return;
            }
            class_2680 destInto = context.bsi.get0(destX, y, destZ);
            if (!MovementHelper.fullyPassable(context.bsi.access, (class_2338)context.bsi.isPassableBlockPos.method_10103(destX, y, destZ), destInto)) {
                if (i <= 3 && context.allowParkourAscend && context.canSprint && MovementHelper.canWalkOn(context.bsi, destX, y, destZ, destInto, context.baritone.settings()) && MovementParkour.checkOvershootSafety(context.bsi, destX + xDiff, y + 1, destZ + zDiff)) {
                    res.x = destX;
                    res.y = y + 1;
                    res.z = destZ;
                    res.cost = (double)i * 3.563791874554526 + context.jumpPenalty;
                    res.oxygenCost = context.oxygenCost(res.cost, class_2246.field_10124.method_9564());
                }
                return;
            }
            class_2680 landingOn = context.bsi.get0(destX, y - 1, destZ);
            if (!(landingOn.method_26204() instanceof class_2344) && MovementHelper.canWalkOn(context.bsi, destX, y - 1, destZ, landingOn, context.baritone.settings())) {
                if (MovementParkour.checkOvershootSafety(context.bsi, destX + xDiff, y, destZ + zDiff)) {
                    res.x = destX;
                    res.y = y;
                    res.z = destZ;
                    res.cost = MovementParkour.costFromJumpDistance(i) + context.jumpPenalty;
                    res.oxygenCost = context.oxygenCost(res.cost, class_2246.field_10124.method_9564());
                }
                return;
            }
            if (MovementHelper.fullyPassable(context, destX, y + context.height + 1, destZ)) continue;
            return;
        }
        if (maxJump != 4) {
            return;
        }
        if (!context.allowParkourPlace) {
            return;
        }
        int destX = x + 4 * xDiff;
        int destZ = z + 4 * zDiff;
        class_2680 toReplace = context.get(destX, y - 1, destZ);
        double placeCost = context.costOfPlacingAt(destX, y - 1, destZ, toReplace);
        if (placeCost >= 1000000.0) {
            return;
        }
        if (!MovementHelper.isReplaceable(destX, y - 1, destZ, toReplace, context.bsi)) {
            return;
        }
        if (!MovementParkour.checkOvershootSafety(context.bsi, destX + xDiff, y, destZ + zDiff)) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            int againstX = destX + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].method_10148();
            int againstY = y - 1 + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].method_10164();
            int againstZ = destZ + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].method_10165();
            if (againstX == x + xDiff * 3 && againstZ == z + zDiff * 3 || !MovementHelper.canPlaceAgainst(context.bsi, againstX, againstY, againstZ)) continue;
            res.x = destX;
            res.y = y;
            res.z = destZ;
            res.cost = MovementParkour.costFromJumpDistance(4) + placeCost + context.jumpPenalty;
            res.oxygenCost = context.oxygenCost(res.cost, class_2246.field_10124.method_9564());
            return;
        }
    }

    private static boolean checkOvershootSafety(BlockStateInterface bsi, int x, int y, int z) {
        return !MovementHelper.avoidWalkingInto(bsi.get0(x, y, z)) && !MovementHelper.avoidWalkingInto(bsi.get0(x, y + 1, z));
    }

    private static double costFromJumpDistance(int dist) {
        switch (dist) {
            case 2: {
                return 9.26569376882094;
            }
            case 3: {
                return 13.89854065323141;
            }
            case 4: {
                return 14.255167498218103;
            }
        }
        throw new IllegalStateException("LOL " + dist);
    }

    @Override
    public double calculateCost(CalculationContext context) {
        MutableMoveResult res = new MutableMoveResult();
        MovementParkour.cost(context, this.src.x, this.src.y, this.src.z, this.direction, res);
        if (res.x != this.dest.x || res.y != this.dest.y || res.z != this.dest.z) {
            return 1000000.0;
        }
        return res.cost;
    }

    @Override
    protected Set<BetterBlockPos> calculateValidPositions() {
        HashSet<BetterBlockPos> set = new HashSet<BetterBlockPos>();
        for (int i = 0; i <= this.dist; ++i) {
            for (int y = 0; y < 2; ++y) {
                set.add(this.src.offset(this.direction, i).up(y));
            }
        }
        return set;
    }

    @Override
    public boolean safeToCancel(MovementState state) {
        return state.getStatus() != MovementStatus.RUNNING;
    }
}

