/*
 * Decompiled with CFR 0.152.
 */
package f_baritone.pathing.movement.movements;

import f_baritone.api.IBaritone;
import f_baritone.api.pathing.movement.MovementStatus;
import f_baritone.api.utils.BetterBlockPos;
import f_baritone.pathing.movement.CalculationContext;
import f_baritone.pathing.movement.Movement;
import f_baritone.pathing.movement.MovementHelper;
import f_baritone.pathing.movement.MovementState;
import f_baritone.pathing.movement.movements.MovementDescend;
import f_baritone.utils.pathing.MutableMoveResult;
import java.util.HashSet;
import java.util.Set;

public class MovementFall
extends Movement {
    public MovementFall(IBaritone baritone, BetterBlockPos src, BetterBlockPos dest) {
        super(baritone, src, dest, MovementFall.buildPositionsToBreak(src, dest));
    }

    @Override
    public double calculateCost(CalculationContext context) {
        MutableMoveResult result = new MutableMoveResult();
        MovementDescend.cost(context, this.src.x, this.src.y, this.src.z, this.dest.x, this.dest.z, result);
        if (result.y != this.dest.y) {
            return 1000000.0;
        }
        return result.cost;
    }

    @Override
    protected Set<BetterBlockPos> calculateValidPositions() {
        HashSet<BetterBlockPos> set = new HashSet<BetterBlockPos>();
        set.add(this.src);
        for (int y = this.src.y - this.dest.y; y >= 0; --y) {
            set.add(this.dest.up(y));
        }
        return set;
    }

    @Override
    public boolean safeToCancel(MovementState state) {
        return this.ctx.feetPos().equals((Object)this.src) || state.getStatus() != MovementStatus.RUNNING;
    }

    private static BetterBlockPos[] buildPositionsToBreak(BetterBlockPos src, BetterBlockPos dest) {
        int diffX = src.method_10263() - dest.method_10263();
        int diffZ = src.method_10260() - dest.method_10260();
        int diffY = src.method_10264() - dest.method_10264();
        BetterBlockPos[] toBreak = new BetterBlockPos[Math.max(0, diffY + 2)];
        for (int i = 0; i < toBreak.length; ++i) {
            toBreak[i] = new BetterBlockPos(src.method_10263() - diffX, src.method_10264() + 1 - i, src.method_10260() - diffZ);
        }
        return toBreak;
    }

    @Override
    protected boolean prepared(MovementState state) {
        if (state.getStatus() == MovementStatus.WAITING) {
            return true;
        }
        for (int i = 0; i < 4 && i < this.positionsToBreak.length; ++i) {
            if (MovementHelper.canWalkThrough(this.ctx, this.positionsToBreak[i])) continue;
            return super.prepared(state);
        }
        return true;
    }
}

