/*
 * Decompiled with CFR 0.152.
 */
package f_baritone.pathing.movement.movements;

import com.google.common.collect.ImmutableSet;
import f_baritone.api.IBaritone;
import f_baritone.api.utils.BetterBlockPos;
import f_baritone.pathing.movement.CalculationContext;
import f_baritone.pathing.movement.Movement;
import f_baritone.pathing.movement.MovementHelper;
import f_baritone.utils.pathing.MutableMoveResult;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3736;
import net.minecraft.class_4048;
import net.minecraft.class_4050;

public class MovementDownward
extends Movement {
    private int numTicks = 0;

    public MovementDownward(IBaritone baritone, BetterBlockPos start, BetterBlockPos end) {
        super(baritone, start, end, MovementDownward.buildPositionsToBreak((class_1297)baritone.getPlayerContext().entity(), end));
    }

    public static BetterBlockPos[] buildPositionsToBreak(class_1297 entity, BetterBlockPos end) {
        int x = end.x;
        int y = end.y;
        int z = end.z;
        class_4048 dims = entity.method_18377(class_4050.field_18076);
        int requiredSideSpace = CalculationContext.getRequiredSideSpace(dims);
        int sideLength = requiredSideSpace * 2 + 1;
        BetterBlockPos[] ret = new BetterBlockPos[sideLength * sideLength];
        int i = 0;
        for (int dx = -requiredSideSpace; dx <= requiredSideSpace; ++dx) {
            for (int dz = -requiredSideSpace; dz <= requiredSideSpace; ++dz) {
                ret[i++] = new BetterBlockPos(x + dx, y, z + dz);
            }
        }
        return ret;
    }

    @Override
    public void reset() {
        super.reset();
        this.numTicks = 0;
    }

    @Override
    public double calculateCost(CalculationContext context) {
        MutableMoveResult result = new MutableMoveResult();
        MovementDownward.cost(context, this.src.x, this.src.y, this.src.z, result);
        return result.cost;
    }

    @Override
    protected Set<BetterBlockPos> calculateValidPositions() {
        return ImmutableSet.of((Object)((Object)this.src), (Object)((Object)this.dest));
    }

    public static void cost(CalculationContext context, int x, int y, int z, MutableMoveResult result) {
        if (!context.allowDownward) {
            return;
        }
        if (!MovementHelper.canWalkOn(context.bsi, x, y - 2, z, context.baritone.settings())) {
            return;
        }
        class_2680 downBlock = context.get(x, y - 1, z);
        class_2680 fromBlock = context.get(x, y, z);
        if (fromBlock.method_27852(class_2246.field_16492) && ((Boolean)fromBlock.method_11654((class_2769)class_3736.field_16547)).booleanValue()) {
            return;
        }
        if (downBlock.method_26164(class_3481.field_22414)) {
            if (fromBlock.method_26164(class_3481.field_22414) && downBlock.method_27852(class_2246.field_16492) && !fromBlock.method_27852(class_2246.field_16492)) {
                return;
            }
            if (context.requiredSideSpace == 0) {
                result.cost = 6.666666666666667;
            }
        } else {
            double totalHardness = 0.0;
            int requiredSideSpace = context.requiredSideSpace;
            boolean waterFloor = false;
            class_2680 headState = context.get(x, y + context.height - 1, z);
            boolean inWater = MovementHelper.isWater(headState);
            for (int dx = -requiredSideSpace; dx <= requiredSideSpace; ++dx) {
                for (int dz = -requiredSideSpace; dz <= requiredSideSpace; ++dz) {
                    int checkedX = x + dx;
                    int checkedZ = z + dz;
                    class_2680 toBreak = context.get(checkedX, y - 1, checkedZ);
                    totalHardness += MovementHelper.getMiningDurationTicks(context, checkedX, y - 1, checkedZ, toBreak, false);
                    if (!MovementHelper.isWater(toBreak)) continue;
                    waterFloor = true;
                }
            }
            if (inWater) {
                totalHardness *= 5.0;
            }
            double fallCost = (waterFloor ? context.waterWalkSpeed / 4.63284688441047 : 1.0) * FALL_N_BLOCKS_COST[1];
            result.cost = fallCost + totalHardness;
            result.oxygenCost = context.oxygenCost(fallCost * 0.5 + totalHardness, headState) + context.oxygenCost(fallCost * 0.5, fromBlock);
        }
    }
}

