/*
 * Decompiled with CFR 0.152.
 */
package f_baritone.pathing.movement.movements;

import com.google.common.collect.ImmutableSet;
import f_baritone.api.IBaritone;
import f_baritone.api.utils.BetterBlockPos;
import f_baritone.pathing.movement.CalculationContext;
import f_baritone.pathing.movement.Movement;
import f_baritone.pathing.movement.MovementHelper;
import f_baritone.pathing.movement.movements.MovementDownward;
import f_baritone.pathing.movement.movements.MovementTraverse;
import f_baritone.utils.BlockStateInterface;
import f_baritone.utils.pathing.MutableMoveResult;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3736;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public class MovementDescend
extends Movement {
    private int numTicks = 0;

    public MovementDescend(IBaritone baritone, BetterBlockPos start, BetterBlockPos end) {
        super(baritone, start, end, MovementDescend.buildPositionsToBreak(baritone.getPlayerContext().entity(), start, end), end.down());
    }

    @NotNull
    private static BetterBlockPos[] buildPositionsToBreak(class_1309 entity, BetterBlockPos start, BetterBlockPos end) {
        BetterBlockPos[] wall = MovementTraverse.buildPositionsToBreak((class_1297)entity, start, end.up());
        BetterBlockPos[] floor = MovementDownward.buildPositionsToBreak((class_1297)entity, end);
        return (BetterBlockPos[])ArrayUtils.addAll((Object[])wall, (Object[])floor);
    }

    @Override
    public void reset() {
        super.reset();
        this.numTicks = 0;
    }

    @Override
    public double calculateCost(CalculationContext context) {
        MutableMoveResult result = new MutableMoveResult();
        MovementDescend.cost(context, this.src.x, this.src.y, this.src.z, this.dest.x, this.dest.z, result);
        if (result.y != this.dest.y) {
            return 1000000.0;
        }
        return result.cost;
    }

    @Override
    protected Set<BetterBlockPos> calculateValidPositions() {
        return ImmutableSet.of((Object)((Object)this.src), (Object)((Object)this.dest.up()), (Object)((Object)this.dest));
    }

    public static void cost(CalculationContext context, int x, int y, int z, int destX, int destZ, MutableMoveResult res) {
        double frontBreak = 0.0;
        class_2680 destDown = context.get(destX, y - 1, destZ);
        if (destDown.method_27852(class_2246.field_16492) && ((Boolean)destDown.method_11654((class_2769)class_3736.field_16547)).booleanValue()) {
            return;
        }
        if ((frontBreak += MovementHelper.getMiningDurationTicks(context, destX, y - 1, destZ, destDown, false)) >= 1000000.0) {
            return;
        }
        class_2680 destUp = context.get(destX, y, destZ);
        if (destUp.method_27852(class_2246.field_16492) && ((Boolean)destUp.method_11654((class_2769)class_3736.field_16547)).booleanValue()) {
            return;
        }
        if ((frontBreak += MovementHelper.getMiningDurationTicks(context, destX, y, destZ, destUp, false)) >= 1000000.0) {
            return;
        }
        if ((frontBreak += MovementHelper.getMiningDurationTicks(context, destX, y + 1, destZ, true)) >= 1000000.0) {
            return;
        }
        class_2680 fromDown = context.get(x, y - 1, z);
        if (fromDown.method_26164(class_3481.field_22414)) {
            return;
        }
        class_2680 below = context.get(destX, y - 2, destZ);
        if (!MovementHelper.canWalkOn(context.bsi, destX, y - 2, destZ, below, context.baritone.settings())) {
            MovementDescend.dynamicFallCost(context, x, y, z, destX, destZ, frontBreak, below, res);
            res.oxygenCost += context.oxygenCost(3.7062775075283763 + frontBreak, context.get(x, y + context.height - 1, z));
            return;
        }
        double totalCost = frontBreak;
        if (destDown.method_26204() == class_2246.field_9983 || destDown.method_26204() == class_2246.field_10597) {
            return;
        }
        boolean water = MovementHelper.isWater(destUp);
        double waterModifier = water ? context.waterWalkSpeed / 4.63284688441047 : 1.0;
        double walk = waterModifier * (3.7062775075283763 / (double)fromDown.method_26204().method_23349());
        double fall = waterModifier * Math.max(FALL_N_BLOCKS_COST[1], 0.9265693768820937);
        res.x = destX;
        res.y = y - 1;
        res.z = destZ;
        res.cost = totalCost += walk + fall;
        res.oxygenCost = context.oxygenCost(walk / 2.0 + frontBreak, context.get(x, y + context.height - 1, z));
        res.oxygenCost += context.oxygenCost(fall / 2.0, context.get(destX, y + context.height - 2, destZ));
        res.oxygenCost += context.oxygenCost(walk / 2.0 + fall / 2.0, context.get(destX, y + context.height - 1, destZ));
    }

    public static boolean dynamicFallCost(CalculationContext context, int x, int y, int z, int destX, int destZ, double frontBreak, class_2680 below, MutableMoveResult res) {
        if (frontBreak != 0.0 && context.get(destX, y + 2, destZ).method_26204() instanceof class_2346) {
            return false;
        }
        if (!MovementHelper.canWalkThrough(context.bsi, destX, y - 2, destZ, below, context.baritone.settings())) {
            return false;
        }
        double costSoFar = 0.0;
        int effectiveStartHeight = y;
        int fallHeight = 3;
        int newY;
        while ((newY = y - fallHeight) >= context.worldBottom) {
            class_2680 ontoBlock = context.get(destX, newY, destZ);
            int unprotectedFallHeight = fallHeight - (y - effectiveStartHeight);
            double fallCost = FALL_N_BLOCKS_COST[unprotectedFallHeight] + costSoFar;
            double tentativeCost = 3.7062775075283763 + fallCost + frontBreak;
            if (MovementHelper.isWater(ontoBlock)) {
                if (!MovementHelper.canWalkThrough(context.bsi, destX, newY, destZ, ontoBlock, context.baritone.settings())) {
                    return false;
                }
                if (context.assumeWalkOnWater) {
                    return false;
                }
                if (MovementHelper.isFlowing(destX, newY, destZ, ontoBlock, context.bsi)) {
                    return false;
                }
                if (!MovementHelper.canWalkOn(context.bsi, destX, newY - 1, destZ, context.baritone.settings())) {
                    return false;
                }
                res.x = destX;
                res.y = newY;
                res.z = destZ;
                res.cost = tentativeCost;
                res.oxygenCost = context.oxygenCost(fallCost, class_2246.field_10124.method_9564());
                return false;
            }
            if (unprotectedFallHeight <= 11 && (ontoBlock.method_26204() == class_2246.field_10597 || ontoBlock.method_26204() == class_2246.field_9983)) {
                costSoFar += FALL_N_BLOCKS_COST[unprotectedFallHeight - 1];
                costSoFar += 6.666666666666667;
                effectiveStartHeight = newY;
            } else if (!MovementHelper.canWalkThrough(context.bsi, destX, newY, destZ, ontoBlock, context.baritone.settings())) {
                if (!MovementHelper.canWalkOn(context.bsi, destX, newY, destZ, ontoBlock, context.baritone.settings())) {
                    return false;
                }
                if (MovementHelper.isBottomSlab(ontoBlock)) {
                    return false;
                }
                if (unprotectedFallHeight <= context.maxFallHeightNoWater + 1) {
                    res.x = destX;
                    res.y = newY + 1;
                    res.z = destZ;
                    res.cost = tentativeCost;
                    res.oxygenCost = context.oxygenCost(fallCost, class_2246.field_10124.method_9564());
                    return false;
                }
                if (context.hasWaterBucket && unprotectedFallHeight <= context.maxFallHeightBucket + 1) {
                    res.x = destX;
                    res.y = newY + 1;
                    res.z = destZ;
                    res.cost = tentativeCost + context.placeBucketCost();
                    res.oxygenCost = context.oxygenCost(fallCost, class_2246.field_10124.method_9564());
                    return true;
                }
                return false;
            }
            ++fallHeight;
        }
        return false;
    }

    public boolean safeMode() {
        class_2338 into = this.dest.method_10059((class_2382)this.src.down()).method_10081((class_2382)this.dest);
        if (this.skipToAscend()) {
            return true;
        }
        for (int y = 0; y <= 2; ++y) {
            class_2680 state = BlockStateInterface.get(this.ctx, into.method_10086(y));
            if (!MovementHelper.avoidWalkingInto(state) || MovementHelper.isWater(state) && this.baritone.settings().allowSwimming.get().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean skipToAscend() {
        class_2338 into = this.dest.method_10059((class_2382)this.src.down()).method_10081((class_2382)this.dest);
        return !MovementHelper.canWalkThrough(this.ctx, new BetterBlockPos(into)) && MovementHelper.canWalkThrough(this.ctx, new BetterBlockPos(into).up()) && MovementHelper.canWalkThrough(this.ctx, new BetterBlockPos(into).up(2));
    }
}

