/*
 * Decompiled with CFR 0.152.
 */
package f_baritone.pathing.movement.movements;

import com.google.common.collect.ImmutableSet;
import f_baritone.api.IBaritone;
import f_baritone.api.pathing.movement.MovementStatus;
import f_baritone.api.utils.BetterBlockPos;
import f_baritone.pathing.movement.CalculationContext;
import f_baritone.pathing.movement.Movement;
import f_baritone.pathing.movement.MovementHelper;
import f_baritone.pathing.movement.MovementState;
import f_baritone.pathing.movement.movements.MovementPillar;
import f_baritone.pathing.movement.movements.MovementTraverse;
import f_baritone.utils.pathing.MutableMoveResult;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import org.apache.commons.lang3.ArrayUtils;

public class MovementAscend
extends Movement {
    private int ticksWithoutPlacement = 0;

    public MovementAscend(IBaritone baritone, BetterBlockPos src, BetterBlockPos dest) {
        super(baritone, src, dest, MovementAscend.buildPositionsToBreak(baritone.getPlayerContext().entity(), src, dest), MovementAscend.buildPositionsToPlace(baritone.getPlayerContext().entity(), src, dest));
    }

    private static BetterBlockPos buildPositionsToPlace(class_1309 entity, BetterBlockPos src, BetterBlockPos dest) {
        int diffX = dest.x - src.x;
        int diffZ = dest.z - src.z;
        assert (Math.abs(diffX) <= 1 && Math.abs(diffZ) <= 1);
        int requiredSideSpace = CalculationContext.getRequiredSideSpace(entity.method_18377(class_4050.field_18076));
        int placeX = dest.x + diffX * requiredSideSpace;
        int placeZ = dest.z + diffZ * requiredSideSpace;
        return new BetterBlockPos(placeX, src.y, placeZ);
    }

    private static BetterBlockPos[] buildPositionsToBreak(class_1309 entity, BetterBlockPos src, BetterBlockPos dest) {
        BetterBlockPos[] ceiling = MovementPillar.buildPositionsToBreak((class_1297)entity, src);
        BetterBlockPos[] wall = MovementTraverse.buildPositionsToBreak((class_1297)entity, src.up(), dest);
        return (BetterBlockPos[])ArrayUtils.addAll((Object[])ceiling, (Object[])wall);
    }

    @Override
    public void reset() {
        super.reset();
        this.ticksWithoutPlacement = 0;
    }

    @Override
    public double calculateCost(CalculationContext context) {
        MutableMoveResult result = new MutableMoveResult();
        MovementAscend.cost(context, this.src.x, this.src.y, this.src.z, this.dest.x, this.dest.z, result);
        return result.cost;
    }

    @Override
    protected Set<BetterBlockPos> calculateValidPositions() {
        BetterBlockPos prior = new BetterBlockPos(this.src.method_10059((class_2382)this.getDirection()).method_10084());
        return ImmutableSet.of((Object)((Object)this.src), (Object)((Object)this.src.up()), (Object)((Object)this.dest), (Object)((Object)prior), (Object)((Object)prior.up()));
    }

    public static void cost(CalculationContext context, int x, int y, int z, int destX, int destZ, MutableMoveResult result) {
        double walk;
        boolean jumpingToBottomSlab;
        int diffX = destX - x;
        int diffZ = destZ - z;
        assert (Math.abs(diffX) <= 1 && Math.abs(diffZ) <= 1);
        int placeX = destX + diffX * context.requiredSideSpace;
        int placeZ = destZ + diffZ * context.requiredSideSpace;
        class_2680 toPlace = context.get(placeX, y, placeZ);
        double additionalPlacementCost = 0.0;
        if (!MovementHelper.canWalkOn(context.bsi, placeX, y, placeZ, toPlace, context.baritone.settings())) {
            additionalPlacementCost = context.costOfPlacingAt(placeX, y, placeZ, toPlace);
            if (additionalPlacementCost >= 1000000.0) {
                return;
            }
            if (!MovementHelper.isReplaceable(placeX, y, placeZ, toPlace, context.bsi)) {
                return;
            }
            boolean foundPlaceOption = false;
            for (int i = 0; i < 5; ++i) {
                int againstX = placeX + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].method_10148();
                int againstY = y + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].method_10164();
                int againstZ = placeZ + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].method_10165();
                if (placeX - againstX == diffX && placeZ - againstZ == diffZ || !context.canPlaceAgainst(againstX, againstY, againstZ)) continue;
                foundPlaceOption = true;
                break;
            }
            if (!foundPlaceOption) {
                return;
            }
        }
        double miningTicks = 0.0;
        class_2680 srcDown = context.get(x, y - 1, z);
        if (srcDown.method_26204() == class_2246.field_9983 || srcDown.method_26204() == class_2246.field_10597) {
            return;
        }
        boolean inLiquid = MovementHelper.isLiquid(srcDown);
        for (int dx = -context.requiredSideSpace; dx <= context.requiredSideSpace; ++dx) {
            for (int dz = -context.requiredSideSpace; dz <= context.requiredSideSpace; ++dz) {
                int x1 = x + dx;
                int y1 = y + context.height;
                int z1 = z + dz;
                class_2680 aboveHead = context.get(x1, y1, z1);
                if (context.get(x1, y1 + 1, z1).method_26204() instanceof class_2346 && (MovementHelper.canWalkThrough(context.bsi, x1, y1 - 1, z1, context.baritone.settings()) || !(aboveHead.method_26204() instanceof class_2346))) {
                    return;
                }
                if (!((miningTicks += MovementHelper.getMiningDurationTicks(context, x1, y1, z1, aboveHead, false)) >= 1000000.0) && (!(inLiquid |= MovementHelper.isWater(aboveHead)) || !(miningTicks > 0.0))) continue;
                return;
            }
        }
        boolean jumpingFromBottomSlab = !inLiquid && MovementHelper.isBottomSlab(srcDown);
        boolean bl = jumpingToBottomSlab = !inLiquid && MovementHelper.isBottomSlab(toPlace);
        if (jumpingFromBottomSlab && !jumpingToBottomSlab) {
            return;
        }
        if (jumpingToBottomSlab) {
            if (jumpingFromBottomSlab) {
                walk = Math.max(JUMP_ONE_BLOCK_COST, 4.63284688441047);
                walk += context.jumpPenalty;
            } else {
                walk = 4.63284688441047;
            }
        } else if (inLiquid) {
            walk = context.waterWalkSpeed / 4.63284688441047 * Math.max(JUMP_ONE_BLOCK_COST, 4.63284688441047);
        } else {
            walk = Math.max(JUMP_ONE_BLOCK_COST, 4.63284688441047 / (double)toPlace.method_26204().method_23349());
            walk += context.jumpPenalty;
        }
        double totalCost = walk + additionalPlacementCost;
        totalCost += miningTicks;
        if (totalCost >= 1000000.0) {
            return;
        }
        for (int dxz = -context.requiredSideSpace; dxz <= context.requiredSideSpace; ++dxz) {
            for (int dy = 0; dy < context.height; ++dy) {
                miningTicks = MovementHelper.getMiningDurationTicks(context, placeX + dxz * diffZ, y + dy + 1, placeZ + dxz * diffX, dy == context.height - 1);
                if (!((totalCost += miningTicks) >= 1000000.0) && (!(miningTicks > 0.0) || !inLiquid)) continue;
                return;
            }
        }
        result.oxygenCost = context.oxygenCost(walk / 3.0, context.get(x, y + context.height - 1, z));
        result.oxygenCost += context.oxygenCost(walk / 3.0, context.get(x, y + context.height, z));
        result.oxygenCost += context.oxygenCost(walk / 3.0, context.get(destX, y + context.height - 1, destZ));
        result.cost = totalCost;
    }

    private boolean canStopJumping() {
        BetterBlockPos srcUp = this.src.up();
        double entityY = this.ctx.entity().method_23318();
        if (entityY < (double)srcUp.y) {
            return false;
        }
        if (entityY <= (double)srcUp.y + 0.1) {
            return !MovementHelper.isWater(this.ctx.world().method_8320((class_2338)srcUp));
        }
        return true;
    }

    public boolean headBonkClear() {
        BetterBlockPos startUp = this.src.up(class_3532.method_15386((float)this.ctx.entity().method_17682()));
        for (int i = 0; i < 4; ++i) {
            BetterBlockPos check = startUp.offset(class_2350.method_10139((int)i));
            if (MovementHelper.canWalkThrough(this.ctx, check)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean safeToCancel(MovementState state) {
        return state.getStatus() != MovementStatus.RUNNING || this.ticksWithoutPlacement == 0;
    }
}

