/*
 * Decompiled with CFR 0.152.
 */
package f_baritone.pathing.movement;

import f_baritone.api.IBaritone;
import f_baritone.api.pathing.movement.IMovement;
import f_baritone.api.pathing.movement.MovementStatus;
import f_baritone.api.utils.BetterBlockPos;
import f_baritone.api.utils.IEntityContext;
import f_baritone.api.utils.Rotation;
import f_baritone.api.utils.RotationUtils;
import f_baritone.api.utils.VecUtils;
import f_baritone.api.utils.input.Input;
import f_baritone.behavior.PathingBehavior;
import f_baritone.pathing.movement.CalculationContext;
import f_baritone.pathing.movement.MovementHelper;
import f_baritone.pathing.movement.MovementState;
import f_baritone.utils.BlockStateInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1540;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;

public abstract class Movement
implements IMovement,
MovementHelper {
    public static final class_2350[] HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039, class_2350.field_11033};
    protected final IBaritone baritone;
    protected final IEntityContext ctx;
    private MovementState currentState = new MovementState().setStatus(MovementStatus.PREPPING);
    protected final BetterBlockPos src;
    protected final BetterBlockPos dest;
    protected final BetterBlockPos[] positionsToBreak;
    protected final BetterBlockPos positionToPlace;
    private Double cost;
    public List<class_2338> toBreakCached = null;
    public List<class_2338> toPlaceCached = null;
    public List<class_2338> toWalkIntoCached = null;
    private Set<BetterBlockPos> validPositionsCached = null;
    private Boolean calculatedWhileLoaded;

    protected Movement(IBaritone baritone, BetterBlockPos src, BetterBlockPos dest, BetterBlockPos[] toBreak, BetterBlockPos toPlace) {
        this.baritone = baritone;
        this.ctx = baritone.getPlayerContext();
        this.src = src;
        this.dest = dest;
        this.positionsToBreak = toBreak;
        this.positionToPlace = toPlace;
    }

    protected Movement(IBaritone baritone, BetterBlockPos src, BetterBlockPos dest, BetterBlockPos[] toBreak) {
        this(baritone, src, dest, toBreak, null);
    }

    @Override
    public double getCost() throws NullPointerException {
        return this.cost;
    }

    public double getCost(CalculationContext context) {
        if (this.cost == null) {
            this.cost = this.calculateCost(context);
        }
        return this.cost;
    }

    public abstract double calculateCost(CalculationContext var1);

    public double recalculateCost(CalculationContext context) {
        this.cost = null;
        return this.getCost(context);
    }

    public void override(double cost) {
        this.cost = cost;
    }

    protected abstract Set<BetterBlockPos> calculateValidPositions();

    public Set<BetterBlockPos> getValidPositions() {
        if (this.validPositionsCached == null) {
            this.validPositionsCached = this.calculateValidPositions();
            Objects.requireNonNull(this.validPositionsCached);
        }
        return this.validPositionsCached;
    }

    protected boolean playerInValidPosition() {
        return this.getValidPositions().contains((Object)this.ctx.feetPos()) || this.getValidPositions().contains((Object)((PathingBehavior)this.baritone.getPathingBehavior()).pathStart());
    }

    @Override
    public MovementStatus update() {
        if (this.ctx.entity() instanceof class_1657) {
            ((class_1657)this.ctx.entity()).method_31549().field_7479 = false;
        }
        if (!this.ctx.baritone().settings().allowSwimming.get().booleanValue() && MovementHelper.isLiquid(this.ctx, this.ctx.feetPos())) {
            this.currentState.setInput(Input.JUMP, true);
        }
        this.currentState = this.updateState(this.currentState);
        if (this.ctx.entity().method_5757()) {
            this.ctx.getSelectedBlock().ifPresent(pos -> MovementHelper.switchToBestToolFor(this.ctx, BlockStateInterface.get(this.ctx, pos)));
            this.currentState.setInput(Input.CLICK_LEFT, true);
        }
        this.currentState.getTarget().getRotation().ifPresent(rotation -> this.baritone.getLookBehavior().updateTarget((Rotation)rotation, this.currentState.getTarget().hasToForceRotations()));
        this.baritone.getInputOverrideHandler().clearAllKeys();
        this.currentState.getInputStates().forEach((input, forced) -> this.baritone.getInputOverrideHandler().setInputForceState((Input)((Object)input), (boolean)forced));
        this.currentState.getInputStates().clear();
        if (this.currentState.getStatus().isComplete()) {
            this.baritone.getInputOverrideHandler().clearAllKeys();
        }
        return this.currentState.getStatus();
    }

    protected boolean prepared(MovementState state) {
        if (state.getStatus() == MovementStatus.WAITING) {
            return true;
        }
        boolean somethingInTheWay = false;
        for (BetterBlockPos blockPos : this.positionsToBreak) {
            if (!this.ctx.world().method_8390(class_1540.class, new class_238(0.0, 0.0, 0.0, 1.0, 1.1, 1.0).method_996((class_2338)blockPos), e -> true).isEmpty() && this.baritone.settings().pauseMiningForFallingBlocks.get().booleanValue()) {
                return false;
            }
            if (MovementHelper.canWalkThrough(this.ctx, blockPos)) continue;
            somethingInTheWay = true;
            MovementHelper.switchToBestToolFor(this.ctx, BlockStateInterface.get(this.ctx, blockPos));
            Optional<Rotation> reachable = RotationUtils.reachable(this.ctx.entity(), (class_2338)blockPos, this.ctx.playerController().getBlockReachDistance());
            if (reachable.isPresent()) {
                Rotation rotTowardsBlock = reachable.get();
                state.setTarget(new MovementState.MovementTarget(rotTowardsBlock, true));
                if (this.ctx.isLookingAt(blockPos) || this.ctx.entityRotations().isReallyCloseTo(rotTowardsBlock)) {
                    state.setInput(Input.CLICK_LEFT, true);
                }
                return false;
            }
            state.setTarget(new MovementState.MovementTarget(RotationUtils.calcRotationFromVec3d(this.ctx.headPos(), VecUtils.getBlockPosCenter(blockPos), this.ctx.entityRotations()), true));
            state.setInput(Input.CLICK_LEFT, true);
            return false;
        }
        if (somethingInTheWay) {
            state.setStatus(MovementStatus.UNREACHABLE);
            return true;
        }
        return true;
    }

    @Override
    public boolean safeToCancel() {
        return this.safeToCancel(this.currentState);
    }

    protected boolean safeToCancel(MovementState currentState) {
        return true;
    }

    @Override
    public BetterBlockPos getSrc() {
        return this.src;
    }

    @Override
    public BetterBlockPos getDest() {
        return this.dest;
    }

    @Override
    public void reset() {
        this.currentState = new MovementState().setStatus(MovementStatus.PREPPING);
    }

    public MovementState updateState(MovementState state) {
        if (!this.prepared(state)) {
            return state.setStatus(MovementStatus.PREPPING);
        }
        if (state.getStatus() == MovementStatus.PREPPING) {
            state.setStatus(MovementStatus.WAITING);
        }
        if (state.getStatus() == MovementStatus.WAITING) {
            state.setStatus(MovementStatus.RUNNING);
        }
        MovementHelper.moveTowards(this.ctx, state, this.dest, this.baritone.settings());
        if ((float)this.ctx.feetPos().method_19455((class_2382)this.dest) < 0.2f) {
            return state.setStatus(MovementStatus.SUCCESS);
        }
        return state;
    }

    @Override
    public class_2338 getDirection() {
        return this.getDest().method_10059((class_2382)this.getSrc());
    }

    public void checkLoadedChunk(CalculationContext context) {
        this.calculatedWhileLoaded = context.bsi.worldContainsLoadedChunk(this.dest.x, this.dest.z);
    }

    @Override
    public boolean calculatedWhileLoaded() {
        return this.calculatedWhileLoaded;
    }

    @Override
    public void resetBlockCache() {
        this.toBreakCached = null;
        this.toPlaceCached = null;
        this.toWalkIntoCached = null;
    }

    public List<class_2338> toBreak(BlockStateInterface bsi) {
        if (this.toBreakCached != null) {
            return this.toBreakCached;
        }
        ArrayList<class_2338> result = new ArrayList<class_2338>();
        for (BetterBlockPos positionToBreak : this.positionsToBreak) {
            if (MovementHelper.canWalkThrough(bsi, positionToBreak.x, positionToBreak.y, positionToBreak.z, this.ctx.baritone().settings())) continue;
            result.add(positionToBreak);
        }
        this.toBreakCached = result;
        return result;
    }

    public List<class_2338> toPlace(BlockStateInterface bsi) {
        if (this.toPlaceCached != null) {
            return this.toPlaceCached;
        }
        ArrayList<class_2338> result = new ArrayList<class_2338>();
        if (this.positionToPlace != null && !MovementHelper.canWalkOn(bsi, this.positionToPlace.x, this.positionToPlace.y, this.positionToPlace.z, this.baritone.settings())) {
            result.add(this.positionToPlace);
        }
        this.toPlaceCached = result;
        return result;
    }

    public List<class_2338> toWalkInto(BlockStateInterface bsi) {
        if (this.toWalkIntoCached == null) {
            this.toWalkIntoCached = new ArrayList<class_2338>();
        }
        return this.toWalkIntoCached;
    }

    public class_2338[] toBreakAll() {
        return this.positionsToBreak;
    }
}

