/*
 * Decompiled with CFR 0.152.
 */
package f_baritone.pathing.movement;

import f_baritone.Automatone;
import f_baritone.Baritone;
import f_baritone.api.IBaritone;
import f_baritone.behavior.InventoryBehavior;
import f_baritone.cache.WorldData;
import f_baritone.pathing.movement.MovementHelper;
import f_baritone.utils.BlockStateInterface;
import f_baritone.utils.ToolSet;
import f_baritone.utils.accessor.ILivingEntityAccessor;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.jetbrains.annotations.Nullable;

public class CalculationContext {
    private static final class_1799 STACK_BUCKET_WATER = new class_1799((class_1935)class_1802.field_8705);
    public final boolean safeForThreadedUse;
    public final IBaritone baritone;
    public final class_1937 world;
    public final WorldData worldData;
    public final BlockStateInterface bsi;
    @Nullable
    public final ToolSet toolSet;
    public final boolean hasWaterBucket;
    public final boolean hasThrowaway;
    public final boolean canSprint;
    protected final double placeBlockCost;
    public final boolean allowBreak;
    public final boolean allowParkour;
    public final boolean allowParkourPlace;
    public final boolean allowJumpAt256;
    public final boolean allowParkourAscend;
    public final boolean assumeWalkOnWater;
    public final boolean allowDiagonalDescend;
    public final boolean allowDiagonalAscend;
    public final boolean allowDownward;
    public final int maxFallHeightNoWater;
    public final int maxFallHeightBucket;
    public final double waterWalkSpeed;
    public final double breakBlockAdditionalCost;
    public double backtrackCostFavoringCoefficient;
    public double jumpPenalty;
    public final double walkOnWaterOnePenalty;
    public final int worldBottom;
    public final int worldTop;
    public final int width;
    public final int requiredSideSpace;
    public final int height;
    private final class_1657 player;
    private final class_2338.class_2339 blockPos;
    public final int breathTime;
    public final int startingBreathTime;
    public final boolean allowSwimming;
    private final int airIncreaseOnLand;
    private final int airDecreaseInWater;

    public CalculationContext(IBaritone baritone) {
        this(baritone, false);
    }

    public CalculationContext(IBaritone baritone, boolean forUseOnAnotherThread) {
        this.safeForThreadedUse = forUseOnAnotherThread;
        this.baritone = baritone;
        class_1309 entity = baritone.getPlayerContext().entity();
        this.player = entity instanceof class_1657 ? (class_1657)entity : null;
        this.world = baritone.getPlayerContext().world();
        this.worldData = (WorldData)baritone.getWorldProvider().getCurrentWorld();
        this.bsi = new BlockStateInterface(this.world);
        this.toolSet = this.player == null ? null : new ToolSet(this.player);
        this.hasThrowaway = baritone.settings().allowPlace.get() != false && ((Baritone)baritone).getInventoryBehavior().hasGenericThrowaway();
        this.hasWaterBucket = this.player != null && baritone.settings().allowWaterBucketFall.get() != false && class_1661.method_7380((int)InventoryBehavior.getSlotWithStack(this.player.method_31548(), Automatone.WATER_BUCKETS)) && !this.world.method_8597().comp_644();
        this.canSprint = this.player != null && baritone.settings().allowSprint.get() != false && this.player.method_7344().method_7586() > 6;
        this.placeBlockCost = baritone.settings().blockPlacementPenalty.get();
        this.allowBreak = baritone.settings().allowBreak.get();
        this.allowParkour = baritone.settings().allowParkour.get();
        this.allowParkourPlace = baritone.settings().allowParkourPlace.get();
        this.allowJumpAt256 = baritone.settings().allowJumpAt256.get();
        this.allowParkourAscend = baritone.settings().allowParkourAscend.get();
        this.assumeWalkOnWater = baritone.settings().assumeWalkOnWater.get();
        this.allowDiagonalDescend = baritone.settings().allowDiagonalDescend.get();
        this.allowDiagonalAscend = baritone.settings().allowDiagonalAscend.get();
        this.allowDownward = baritone.settings().allowDownward.get();
        this.maxFallHeightNoWater = baritone.settings().maxFallHeightNoWater.get();
        this.maxFallHeightBucket = baritone.settings().maxFallHeightBucket.get();
        int depth = class_1890.method_8232((class_1309)entity);
        if (depth > 3) {
            depth = 3;
        }
        float mult = (float)depth / 3.0f;
        this.waterWalkSpeed = 9.09090909090909 * (double)(1.0f - mult) + 4.63284688441047 * (double)mult;
        this.breakBlockAdditionalCost = baritone.settings().blockBreakAdditionalPenalty.get();
        this.backtrackCostFavoringCoefficient = baritone.settings().backtrackCostFavoringCoefficient.get();
        this.jumpPenalty = baritone.settings().jumpPenalty.get();
        this.walkOnWaterOnePenalty = baritone.settings().walkOnWaterOnePenalty.get();
        this.worldTop = this.world.method_31600();
        this.worldBottom = this.world.method_31607();
        class_4048 dimensions = entity.method_18377(class_4050.field_18076);
        this.width = class_3532.method_15386((float)dimensions.field_18067);
        this.requiredSideSpace = CalculationContext.getRequiredSideSpace(dimensions);
        this.height = class_3532.method_15386((float)dimensions.field_18068);
        this.blockPos = new class_2338.class_2339();
        this.allowSwimming = baritone.settings().allowSwimming.get();
        this.breathTime = baritone.settings().ignoreBreath.get() != false ? Integer.MAX_VALUE : entity.method_5748();
        this.startingBreathTime = entity.method_5669();
        this.airIncreaseOnLand = ((ILivingEntityAccessor)entity).automatone$getNextAirOnLand(0);
        this.airDecreaseInWater = this.breathTime - ((ILivingEntityAccessor)entity).automatone$getNextAirUnderwater(this.breathTime);
    }

    public static int getRequiredSideSpace(class_4048 dimensions) {
        return class_3532.method_15386((float)((dimensions.field_18067 - 1.0f) * 0.5f));
    }

    public final IBaritone getBaritone() {
        return this.baritone;
    }

    public class_2680 get(int x, int y, int z) {
        return this.bsi.get0(x, y, z);
    }

    public boolean isLoaded(int x, int z) {
        return this.bsi.isLoaded(x, z);
    }

    public class_2680 get(class_2338 pos) {
        return this.get(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public class_2248 getBlock(int x, int y, int z) {
        return this.get(x, y, z).method_26204();
    }

    public double costOfPlacingAt(int x, int y, int z, class_2680 current) {
        if (!this.hasThrowaway) {
            return 1000000.0;
        }
        if (this.isProtected(x, y, z)) {
            return 1000000.0;
        }
        return this.placeBlockCost;
    }

    public double breakCostMultiplierAt(int x, int y, int z, class_2680 current) {
        if (!this.allowBreak) {
            return 1000000.0;
        }
        if (this.isProtected(x, y, z)) {
            return 1000000.0;
        }
        return 1.0;
    }

    public double placeBucketCost() {
        return this.placeBlockCost;
    }

    public boolean canPlaceAgainst(class_2338 pos) {
        return this.canPlaceAgainst(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public boolean canPlaceAgainst(int againstX, int againstY, int againstZ) {
        return this.canPlaceAgainst(againstX, againstY, againstZ, this.bsi.get0(againstX, againstY, againstZ));
    }

    public boolean canPlaceAgainst(int againstX, int againstY, int againstZ, class_2680 state) {
        return !this.isProtected(againstX, againstY, againstZ) && MovementHelper.canPlaceAgainst(this.bsi, againstX, againstY, againstZ, state);
    }

    public boolean isProtected(int x, int y, int z) {
        this.blockPos.method_10103(x, y, z);
        return this.player != null && !this.world.method_8505(this.player, (class_2338)this.blockPos);
    }

    public double oxygenCost(double baseCost, class_2680 headState) {
        return 0.0;
    }
}

