/*
 * Decompiled with CFR 0.152.
 */
package f_baritone.pathing.calc;

import f_baritone.Automatone;
import f_baritone.api.Settings;
import f_baritone.api.pathing.calc.IPath;
import f_baritone.api.pathing.calc.IPathFinder;
import f_baritone.api.pathing.goals.Goal;
import f_baritone.api.utils.BetterBlockPos;
import f_baritone.api.utils.PathCalculationResult;
import f_baritone.pathing.calc.Path;
import f_baritone.pathing.calc.PathNode;
import f_baritone.pathing.movement.CalculationContext;
import f_baritone.utils.NotificationHelper;
import f_baritone.utils.pathing.PathBase;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Optional;

public abstract class AbstractNodeCostSearch
implements IPathFinder {
    protected final int startX;
    protected final int startY;
    protected final int startZ;
    protected final Goal goal;
    private final CalculationContext context;
    private final Long2ObjectOpenHashMap<PathNode> map;
    protected PathNode startNode;
    protected PathNode mostRecentConsidered;
    protected final PathNode[] bestSoFar = new PathNode[COEFFICIENTS.length];
    private volatile boolean isFinished;
    protected boolean cancelRequested;
    protected static final double[] COEFFICIENTS = new double[]{1.5, 2.0, 2.5, 3.0, 4.0, 5.0, 10.0};
    protected static final double MIN_DIST_PATH = 5.0;
    protected static final double MIN_IMPROVEMENT = 0.01;

    AbstractNodeCostSearch(int startX, int startY, int startZ, Goal goal, CalculationContext context) {
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.goal = goal;
        this.context = context;
        this.map = new Long2ObjectOpenHashMap(context.baritone.settings().pathingMapDefaultSize.get().intValue(), context.baritone.settings().pathingMapLoadFactor.get().floatValue());
    }

    public void cancel() {
        this.cancelRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized PathCalculationResult calculate(long primaryTimeout, long failureTimeout) {
        if (this.isFinished) {
            throw new IllegalStateException("Path finder cannot be reused!");
        }
        this.cancelRequested = false;
        try {
            IPath path = this.calculate0(primaryTimeout, failureTimeout).map(IPath::postProcess).orElse(null);
            if (this.cancelRequested) {
                PathCalculationResult pathCalculationResult = new PathCalculationResult(PathCalculationResult.Type.CANCELLATION);
                return pathCalculationResult;
            }
            if (path == null) {
                PathCalculationResult pathCalculationResult = new PathCalculationResult(PathCalculationResult.Type.FAILURE);
                return pathCalculationResult;
            }
            int previousLength = path.length();
            Settings settings = this.context.getBaritone().settings();
            if ((path = ((PathBase)path).cutoffAtLoadedChunks(this.context.bsi, settings)).length() < previousLength) {
                this.context.baritone.logDebug("Cutting off path at edge of loaded chunks");
                this.context.baritone.logDebug("Length decreased by " + (previousLength - path.length()));
            } else {
                this.context.baritone.logDebug("Path ends within loaded chunks");
            }
            previousLength = path.length();
            path = ((PathBase)path).staticCutoff(this.goal, settings);
            if (path.length() < previousLength) {
                this.context.baritone.logDebug("Static cutoff " + previousLength + " to " + path.length());
            }
            if (this.goal.isInGoal(path.getDest())) {
                PathCalculationResult pathCalculationResult = new PathCalculationResult(PathCalculationResult.Type.SUCCESS_TO_GOAL, path);
                return pathCalculationResult;
            }
            PathCalculationResult pathCalculationResult = new PathCalculationResult(PathCalculationResult.Type.SUCCESS_SEGMENT, path);
            return pathCalculationResult;
        }
        catch (Exception e) {
            this.context.baritone.logDirect("Pathing exception: " + e);
            Automatone.LOGGER.error("Pathing exception: ", (Throwable)e);
            PathCalculationResult pathCalculationResult = new PathCalculationResult(PathCalculationResult.Type.EXCEPTION);
            return pathCalculationResult;
        }
        finally {
            this.isFinished = true;
        }
    }

    protected abstract Optional<IPath> calculate0(long var1, long var3);

    protected double getDistFromStartSq(PathNode n) {
        int xDiff = n.x - this.startX;
        int yDiff = n.y - this.startY;
        int zDiff = n.z - this.startZ;
        return xDiff * xDiff + yDiff * yDiff + zDiff * zDiff;
    }

    protected PathNode getNodeAtPosition(int x, int y, int z, long hashCode) {
        PathNode node = (PathNode)this.map.get(hashCode);
        if (node == null) {
            node = new PathNode(x, y, z, this.goal);
            this.map.put(hashCode, (Object)node);
        }
        return node;
    }

    @Override
    public Optional<IPath> pathToMostRecentNodeConsidered() {
        return Optional.ofNullable(this.mostRecentConsidered).map(node -> new Path(this.startNode, (PathNode)node, 0, this.goal, this.context));
    }

    @Override
    public Optional<IPath> bestPathSoFar() {
        return this.bestSoFar(false, 0);
    }

    protected Optional<IPath> bestSoFar(boolean logInfo, int numNodes) {
        if (this.startNode == null) {
            return Optional.empty();
        }
        double bestDist = 0.0;
        for (int i = 0; i < COEFFICIENTS.length; ++i) {
            if (this.bestSoFar[i] == null) continue;
            double dist = this.getDistFromStartSq(this.bestSoFar[i]);
            if (dist > bestDist) {
                bestDist = dist;
            }
            if (!(dist > 25.0)) continue;
            if (logInfo) {
                if (COEFFICIENTS[i] >= 3.0) {
                    Automatone.LOGGER.warn("Warning: cost coefficient is greater than three! Probably means that");
                    Automatone.LOGGER.warn("the path I found is pretty terrible (like sneak-bridging for dozens of blocks)");
                    Automatone.LOGGER.warn("But I'm going to do it anyway, because yolo");
                }
                Automatone.LOGGER.info("Path goes for " + Math.sqrt(dist) + " blocks");
                this.context.baritone.logDebug("A* cost coefficient " + COEFFICIENTS[i]);
            }
            return Optional.of(new Path(this.startNode, this.bestSoFar[i], numNodes, this.goal, this.context));
        }
        if (logInfo) {
            this.context.baritone.logDebug("Even with a cost coefficient of " + COEFFICIENTS[COEFFICIENTS.length - 1] + ", I couldn't get more than " + Math.sqrt(bestDist) + " blocks");
            this.context.baritone.logDebug("No path found =(");
            if (this.context.baritone.settings().desktopNotifications.get().booleanValue()) {
                NotificationHelper.notify("No path found =(", true);
            }
        }
        return Optional.empty();
    }

    @Override
    public final boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public final Goal getGoal() {
        return this.goal;
    }

    public BetterBlockPos getStart() {
        return new BetterBlockPos(this.startX, this.startY, this.startZ);
    }

    protected int mapSize() {
        return this.map.size();
    }
}

