/*
 * Decompiled with CFR 0.152.
 */
package f_baritone.event;

import f_baritone.Automatone;
import f_baritone.Baritone;
import f_baritone.api.event.events.BlockInteractEvent;
import f_baritone.api.event.events.PathEvent;
import f_baritone.api.event.listener.IEventBus;
import f_baritone.api.event.listener.IGameEventListener;
import f_baritone.utils.BlockStateInterface;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class GameEventHandler
implements IEventBus {
    private final Baritone baritone;
    private final List<IGameEventListener> listeners = new CopyOnWriteArrayList<IGameEventListener>();

    public GameEventHandler(Baritone baritone) {
        this.baritone = baritone;
    }

    @Override
    public void onTickServer() {
        try {
            this.baritone.bsi = new BlockStateInterface(this.baritone.getPlayerContext());
        }
        catch (Exception ex) {
            Automatone.LOGGER.error((Object)ex);
            this.baritone.bsi = null;
        }
        this.listeners.forEach(IGameEventListener::onTickServer);
    }

    @Override
    public void onBlockInteract(BlockInteractEvent event) {
        this.listeners.forEach(l -> l.onBlockInteract(event));
    }

    @Override
    public void onPathEvent(PathEvent event) {
        this.listeners.forEach(l -> l.onPathEvent(event));
    }

    @Override
    public final void registerEventListener(IGameEventListener listener) {
        this.listeners.add(listener);
    }
}

