/*
 * Decompiled with CFR 0.152.
 */
package f_baritone.cache;

import f_baritone.api.cache.IWorldScanner;
import f_baritone.api.utils.BetterBlockPos;
import f_baritone.api.utils.BlockOptionalMetaLookup;
import f_baritone.api.utils.IEntityContext;
import f_baritone.utils.accessor.ServerChunkManagerAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_3215;
import net.minecraft.class_3218;

public enum WorldScanner implements IWorldScanner
{
    INSTANCE;

    public static final int SECTION_HEIGHT = 16;
    private static final int[] DEFAULT_COORDINATE_ITERATION_ORDER;

    @Override
    public List<class_2338> scanChunkRadius(IEntityContext ctx, BlockOptionalMetaLookup filter, int max, int yLevelThreshold, int maxSearchRadius) {
        ArrayList<class_2338> res = new ArrayList<class_2338>();
        if (filter.blocks().isEmpty()) {
            return res;
        }
        ServerChunkManagerAccessor chunkProvider = (ServerChunkManagerAccessor)ctx.world().method_14178();
        int maxSearchRadiusSq = maxSearchRadius * maxSearchRadius;
        int playerChunkX = ctx.feetPos().method_10263() >> 4;
        int playerChunkZ = ctx.feetPos().method_10260() >> 4;
        int playerY = ctx.feetPos().method_10264();
        int playerYBlockStateContainerIndex = playerY >> 4;
        int[] coordinateIterationOrder = this.streamSectionY(ctx.world()).boxed().sorted(Comparator.comparingInt(y -> Math.abs(y - playerYBlockStateContainerIndex))).mapToInt(x -> x).toArray();
        int searchRadiusSq = 0;
        boolean foundWithinY = false;
        while (true) {
            boolean allUnloaded = true;
            boolean foundChunks = false;
            for (int xoff = -searchRadiusSq; xoff <= searchRadiusSq; ++xoff) {
                for (int zoff = -searchRadiusSq; zoff <= searchRadiusSq; ++zoff) {
                    int distance = xoff * xoff + zoff * zoff;
                    if (distance != searchRadiusSq) continue;
                    foundChunks = true;
                    int chunkX = xoff + playerChunkX;
                    int chunkZ = zoff + playerChunkZ;
                    class_2818 chunk = chunkProvider.automatone$getChunkNow(chunkX, chunkZ);
                    if (chunk == null) continue;
                    allUnloaded = false;
                    if (!this.scanChunkInto(chunkX << 4, chunkZ << 4, (class_2791)chunk, filter, res, max, yLevelThreshold, playerY, coordinateIterationOrder)) continue;
                    foundWithinY = true;
                }
            }
            if (allUnloaded && foundChunks || res.size() >= max && (searchRadiusSq > maxSearchRadiusSq || searchRadiusSq > 1 && foundWithinY)) {
                return res;
            }
            ++searchRadiusSq;
        }
    }

    @Override
    public List<class_2338> scanChunk(IEntityContext ctx, BlockOptionalMetaLookup filter, class_1923 pos, int max, int yLevelThreshold) {
        if (filter.blocks().isEmpty()) {
            return Collections.emptyList();
        }
        class_3215 chunkProvider = ctx.world().method_14178();
        class_2791 chunk = chunkProvider.method_12121(pos.field_9181, pos.field_9180, class_2806.field_12803, false);
        int playerY = ctx.feetPos().method_10264();
        if (!(chunk instanceof class_2818) || ((class_2818)chunk).method_12223()) {
            return Collections.emptyList();
        }
        ArrayList<class_2338> res = new ArrayList<class_2338>();
        this.scanChunkInto(pos.field_9181 << 4, pos.field_9180 << 4, chunk, filter, res, max, yLevelThreshold, playerY, this.streamSectionY(ctx.world()).toArray());
        return res;
    }

    private IntStream streamSectionY(class_3218 world) {
        return IntStream.range(0, world.method_31605() / 16);
    }

    @Override
    public int repack(IEntityContext ctx) {
        return this.repack(ctx, 40);
    }

    @Override
    public int repack(IEntityContext ctx, int range) {
        class_3215 chunkProvider = ctx.world().method_14178();
        BetterBlockPos playerPos = ctx.feetPos();
        int playerChunkX = playerPos.method_10263() >> 4;
        int playerChunkZ = playerPos.method_10260() >> 4;
        int minX = playerChunkX - range;
        int minZ = playerChunkZ - range;
        int maxX = playerChunkX + range;
        int maxZ = playerChunkZ + range;
        int queued = 0;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                class_2818 chunk = chunkProvider.method_12126(x, z, false);
                if (chunk == null || chunk.method_12223()) continue;
                ++queued;
            }
        }
        return queued;
    }

    private boolean scanChunkInto(int chunkX, int chunkZ, class_2791 chunk, BlockOptionalMetaLookup filter, Collection<class_2338> result, int max, int yLevelThreshold, int playerY, int[] coordinateIterationOrder) {
        class_2826[] chunkInternalStorageArray = chunk.method_12006();
        boolean foundWithinY = false;
        if (chunkInternalStorageArray.length != coordinateIterationOrder.length) {
            throw new IllegalStateException("Unexpected number of sections in chunk (expected " + coordinateIterationOrder.length + ", got " + chunkInternalStorageArray.length + ")");
        }
        for (int yIndex = 0; yIndex < chunkInternalStorageArray.length; ++yIndex) {
            int y0 = coordinateIterationOrder[yIndex];
            class_2826 section = chunkInternalStorageArray[y0];
            if (section == null || section.method_38292() || !section.method_19523(filter::has)) continue;
            int yReal = y0 << 4;
            class_2841 bsc = section.method_12265();
            for (int yy = 0; yy < 16; ++yy) {
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        class_2680 state = (class_2680)bsc.method_12321(x, yy, z);
                        if (!filter.has(state)) continue;
                        int y = yReal | yy;
                        if (result.size() >= max) {
                            if (Math.abs(y - playerY) < yLevelThreshold) {
                                foundWithinY = true;
                            } else if (foundWithinY) {
                                return true;
                            }
                        }
                        result.add(new class_2338(chunkX | x, y, chunkZ | z));
                    }
                }
            }
        }
        return foundWithinY;
    }

    static {
        DEFAULT_COORDINATE_ITERATION_ORDER = IntStream.range(0, 16).toArray();
    }
}

