/*
 * Decompiled with CFR 0.152.
 */
package f_baritone.cache;

import f_baritone.Automatone;
import f_baritone.api.BaritoneAPI;
import f_baritone.api.cache.IContainerMemory;
import f_baritone.api.cache.IRememberedInventory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;

public class ContainerMemory
implements IContainerMemory {
    private final Map<class_2338, RememberedInventory> inventories = new HashMap<class_2338, RememberedInventory>();

    public void read(class_2487 tag) {
        try {
            class_2499 nbtInventories = tag.method_10554("inventories", 10);
            for (int i = 0; i < nbtInventories.size(); ++i) {
                class_2487 nbtEntry = nbtInventories.method_10602(i);
                class_2338 pos = class_2512.method_10691((class_2487)nbtEntry.method_10562("pos"));
                RememberedInventory rem = new RememberedInventory();
                rem.fromNbt(nbtEntry.method_10554("content", 9));
                if (rem.items.isEmpty()) continue;
                this.inventories.put(pos, rem);
            }
        }
        catch (Exception ex) {
            Automatone.LOGGER.error((Object)ex);
            this.inventories.clear();
        }
    }

    public class_2487 toNbt() {
        class_2487 tag = new class_2487();
        if (BaritoneAPI.getGlobalSettings().containerMemory.get().booleanValue()) {
            class_2499 list = new class_2499();
            for (Map.Entry<class_2338, RememberedInventory> entry : this.inventories.entrySet()) {
                class_2487 nbtEntry = new class_2487();
                nbtEntry.method_10566("pos", (class_2520)class_2512.method_10692((class_2338)entry.getKey()));
                nbtEntry.method_10566("content", (class_2520)entry.getValue().toNbt());
                list.add((Object)nbtEntry);
            }
            tag.method_10566("inventories", (class_2520)list);
        }
        return tag;
    }

    public synchronized void setup(class_2338 pos, int windowId, int slotCount) {
        RememberedInventory inventory = this.inventories.computeIfAbsent(pos, x -> new RememberedInventory());
        inventory.windowId = windowId;
        inventory.size = slotCount;
    }

    public synchronized Optional<RememberedInventory> getInventoryFromWindow(int windowId) {
        return this.inventories.values().stream().filter(i -> i.windowId == windowId).findFirst();
    }

    @Override
    public final synchronized RememberedInventory getInventoryByPos(class_2338 pos) {
        return this.inventories.get(pos);
    }

    @Override
    public final synchronized Map<class_2338, IRememberedInventory> getRememberedInventories() {
        return new HashMap<class_2338, IRememberedInventory>(this.inventories);
    }

    public static class RememberedInventory
    implements IRememberedInventory {
        private final List<class_1799> items = new ArrayList<class_1799>();
        private int windowId;
        private int size;

        private RememberedInventory() {
        }

        @Override
        public final List<class_1799> getContents() {
            return Collections.unmodifiableList(this.items);
        }

        @Override
        public final int getSize() {
            return this.size;
        }

        public class_2499 toNbt() {
            class_2499 inv = new class_2499();
            for (class_1799 item : this.items) {
                inv.add((Object)item.method_7953(new class_2487()));
            }
            return inv;
        }

        public void fromNbt(class_2499 content) {
            for (int i = 0; i < content.size(); ++i) {
                this.items.add(class_1799.method_7915((class_2487)content.method_10602(i)));
            }
            this.size = this.items.size();
            this.windowId = -1;
        }
    }
}

