/*
 * Decompiled with CFR 0.152.
 */
package f_baritone.api.fakeplayer;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import f_baritone.api.fakeplayer.AutomatoneFakePlayer;
import f_baritone.api.fakeplayer.FakePlayers;
import f_baritone.api.utils.IEntityAccessor;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.CheckForNull;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_2602;
import net.minecraft.class_2658;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class FakeServerPlayerEntity
extends class_3222
implements AutomatoneFakePlayer {
    @Nullable
    protected GameProfile displayProfile;
    private boolean release;

    public FakeServerPlayerEntity(class_1299<? extends class_1657> type, class_3218 world) {
        this(type, world, new GameProfile(UUID.randomUUID(), "FakePlayer"));
    }

    public FakeServerPlayerEntity(class_1299<? extends class_1657> type, class_3218 world, GameProfile profile) {
        super(world.method_8503(), world, profile);
        ((IEntityAccessor)((Object)this)).automatone$setType(type);
        this.method_49477(0.6f);
        new class_3244(world.method_8503(), new class_2535(class_2598.field_11942), (class_3222)this);
    }

    public void selectHotbarSlot(int hotbarSlot) {
        Preconditions.checkArgument((boolean)class_1661.method_7380((int)hotbarSlot));
        if (this.method_31548().field_7545 != hotbarSlot && this.method_6058() == class_1268.field_5808) {
            this.method_6021();
        }
        this.method_31548().field_7545 = hotbarSlot;
        this.method_14234();
    }

    public void swapHands() {
        class_1799 offhandStack = this.method_5998(class_1268.field_5810);
        this.method_6122(class_1268.field_5810, this.method_5998(class_1268.field_5808));
        this.method_6122(class_1268.field_5808, offhandStack);
        this.method_6021();
    }

    public void releaseActiveItem() {
        this.release = true;
    }

    public void useItem(class_1268 hand) {
        class_1269 actionResult;
        if (this.release && hand != this.method_6058()) {
            this.method_6021();
        }
        if (this.method_6115()) {
            return;
        }
        class_1799 stack = this.method_5998(hand);
        if (!stack.method_7960() && (actionResult = this.field_13974.method_14256((class_3222)this, this.method_37908(), stack, hand)).method_23666()) {
            this.method_23667(hand, true);
        }
    }

    public void method_5773() {
        this.method_7346();
        super.method_5773();
        this.method_14226();
    }

    public void method_6007() {
        if (this.method_5799() && this.method_5715() && this.method_29920()) {
            this.method_6093();
        }
        super.method_6007();
    }

    protected void method_6023() {
        super.method_6023();
        if (this.release) {
            this.method_6021();
            this.release = false;
        }
    }

    public boolean method_6121(class_1297 target) {
        this.method_7324(target);
        return false;
    }

    public void method_6005(double strength, double x, double z) {
        if (this.field_6037) {
            super.method_6005(strength, x, z);
        }
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 landedState, class_2338 landedPosition) {
        this.method_14207(0.0, heightDifference, 0.0, onGround);
    }

    public boolean method_7276() {
        return true;
    }

    public boolean method_31747() {
        return false;
    }

    public class_2561 method_5477() {
        GameProfile displayProfile = this.getDisplayProfile();
        if (displayProfile != null) {
            return class_2561.method_43470((String)displayProfile.getName());
        }
        return super.method_5477();
    }

    @Override
    @Nullable
    public GameProfile getDisplayProfile() {
        return this.displayProfile;
    }

    @Override
    public void setDisplayProfile(@CheckForNull GameProfile profile) {
        if (!Objects.equals(profile, this.displayProfile)) {
            this.displayProfile = profile;
            this.sendProfileUpdatePacket();
        }
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_10573("automatone:display_profile", 10)) {
            this.displayProfile = class_2512.method_10683((class_2487)tag.method_10562("automatone:display_profile"));
        }
        if (tag.method_10545("head_yaw")) {
            this.field_6241 = tag.method_10583("head_yaw");
        }
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        if (this.displayProfile != null) {
            tag.method_10566("automatone:display_profile", (class_2520)class_2512.method_10684((class_2487)new class_2487(), (GameProfile)this.displayProfile));
        }
        tag.method_10548("head_yaw", this.field_6241);
    }

    public class_2596<class_2602> method_18002() {
        class_2540 buf = PacketByteBufs.create();
        this.writeToSpawnPacket(buf);
        return new class_2658(FakePlayers.SPAWN_PACKET_ID, buf);
    }

    protected void writeToSpawnPacket(class_2540 buf) {
        buf.method_10804(this.method_5628());
        buf.method_10797(this.method_5667());
        buf.method_10804(class_7923.field_41177.method_10206((Object)this.method_5864()));
        buf.method_10814(this.method_7334().getName());
        buf.writeDouble(this.method_23317());
        buf.writeDouble(this.method_23318());
        buf.writeDouble(this.method_23321());
        buf.writeByte((int)((byte)(this.method_36454() * 256.0f / 360.0f)));
        buf.writeByte((int)((byte)(this.method_36455() * 256.0f / 360.0f)));
        buf.writeByte((int)((byte)(this.field_6241 * 256.0f / 360.0f)));
        FakeServerPlayerEntity.writeProfile(buf, this.getDisplayProfile());
    }

    public void sendProfileUpdatePacket() {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(this.method_5628());
        FakeServerPlayerEntity.writeProfile(buf, this.getDisplayProfile());
        class_2658 packet = new class_2658(FakePlayers.PROFILE_UPDATE_PACKET_ID, buf);
        for (class_3222 e : PlayerLookup.tracking((class_1297)this)) {
            e.field_13987.method_14364((class_2596)packet);
        }
    }

    public static void writeProfile(class_2540 buf, @Nullable GameProfile profile) {
        buf.writeBoolean(profile != null);
        if (profile != null) {
            buf.method_10797(profile.getId());
            buf.method_10814(profile.getName());
        }
    }
}

