/*
 * Decompiled with CFR 0.152.
 */
package f_baritone.api.behavior;

import f_baritone.api.behavior.IBehavior;
import f_baritone.api.pathing.calc.IPath;
import f_baritone.api.pathing.calc.IPathFinder;
import f_baritone.api.pathing.goals.Goal;
import f_baritone.api.pathing.path.IPathExecutor;
import f_baritone.api.utils.BetterBlockPos;
import java.util.Optional;
import java.util.OptionalDouble;

public interface IPathingBehavior
extends IBehavior {
    default public OptionalDouble ticksRemainingInSegment() {
        return this.ticksRemainingInSegment(true);
    }

    default public OptionalDouble ticksRemainingInSegment(boolean includeCurrentMovement) {
        IPathExecutor current = this.getCurrent();
        if (current == null) {
            return OptionalDouble.empty();
        }
        int start = includeCurrentMovement ? current.getPosition() : current.getPosition() + 1;
        return OptionalDouble.of(current.getPath().ticksRemainingFrom(start));
    }

    public Optional<Double> estimatedTicksToGoal();

    public Goal getGoal();

    public boolean isPathing();

    default public boolean hasPath() {
        return this.getCurrent() != null;
    }

    public boolean cancelEverything();

    public void forceCancel();

    default public Optional<IPath> getPath() {
        return Optional.ofNullable(this.getCurrent()).map(IPathExecutor::getPath);
    }

    public Optional<? extends IPathFinder> getInProgress();

    public IPathExecutor getCurrent();

    public IPathExecutor getNext();

    public BetterBlockPos pathStart();
}

