/*
 * Decompiled with CFR 0.152.
 */
package f_baritone;

import f_baritone.Automatone;
import f_baritone.AutomatoneClient;
import f_baritone.api.BaritoneAPI;
import f_baritone.api.IBaritone;
import f_baritone.api.Settings;
import f_baritone.api.cache.IWorldProvider;
import f_baritone.api.event.listener.IEventBus;
import f_baritone.api.utils.IEntityContext;
import f_baritone.behavior.Behavior;
import f_baritone.behavior.InventoryBehavior;
import f_baritone.behavior.LookBehavior;
import f_baritone.behavior.MemoryBehavior;
import f_baritone.behavior.PathingBehavior;
import f_baritone.cache.WorldProvider;
import f_baritone.event.GameEventHandler;
import f_baritone.process.BackfillProcess;
import f_baritone.process.BuilderProcess;
import f_baritone.process.CustomGoalProcess;
import f_baritone.process.ExploreProcess;
import f_baritone.process.FarmProcess;
import f_baritone.process.FollowProcess;
import f_baritone.process.GetToBlockProcess;
import f_baritone.process.MineProcess;
import f_baritone.render.ClientPathingBehaviour;
import f_baritone.utils.BlockStateInterface;
import f_baritone.utils.InputOverrideHandler;
import f_baritone.utils.PathingControlManager;
import f_baritone.utils.player.EntityContext;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class Baritone
implements IBaritone {
    private final Settings settings = new Settings();
    private final GameEventHandler gameEventHandler = new GameEventHandler(this);
    private final PathingBehavior pathingBehavior;
    private final LookBehavior lookBehavior;
    private final MemoryBehavior memoryBehavior;
    private final InventoryBehavior inventoryBehavior;
    private final InputOverrideHandler inputOverrideHandler;
    private final FollowProcess followProcess;
    private final MineProcess mineProcess;
    private final GetToBlockProcess getToBlockProcess;
    private final CustomGoalProcess customGoalProcess;
    private final BuilderProcess builderProcess;
    private final ExploreProcess exploreProcess;
    private final BackfillProcess backfillProcess;
    private final FarmProcess farmProcess;
    private final PathingControlManager pathingControlManager;
    private final IEntityContext playerContext;
    @Nullable
    private final ClientPathingBehaviour clientPathingBehaviour;
    public BlockStateInterface bsi;

    public Baritone(class_1309 player) {
        this.playerContext = new EntityContext(player);
        this.pathingBehavior = new PathingBehavior(this);
        this.lookBehavior = new LookBehavior(this);
        this.memoryBehavior = new MemoryBehavior(this);
        this.inventoryBehavior = new InventoryBehavior(this);
        this.inputOverrideHandler = new InputOverrideHandler(this);
        this.pathingControlManager = new PathingControlManager(this);
        this.followProcess = new FollowProcess(this);
        this.pathingControlManager.registerProcess(this.followProcess);
        this.mineProcess = new MineProcess(this);
        this.pathingControlManager.registerProcess(this.mineProcess);
        this.customGoalProcess = new CustomGoalProcess(this);
        this.pathingControlManager.registerProcess(this.customGoalProcess);
        this.getToBlockProcess = new GetToBlockProcess(this);
        this.pathingControlManager.registerProcess(this.getToBlockProcess);
        this.builderProcess = new BuilderProcess(this);
        this.pathingControlManager.registerProcess(this.builderProcess);
        this.exploreProcess = new ExploreProcess(this);
        this.pathingControlManager.registerProcess(this.exploreProcess);
        this.backfillProcess = new BackfillProcess(this);
        this.pathingControlManager.registerProcess(this.backfillProcess);
        this.farmProcess = new FarmProcess(this);
        this.pathingControlManager.registerProcess(this.farmProcess);
        this.clientPathingBehaviour = player.method_37908().field_9236 ? new ClientPathingBehaviour((class_1297)player) : null;
    }

    @Override
    public PathingControlManager getPathingControlManager() {
        return this.pathingControlManager;
    }

    public void registerBehavior(Behavior behavior) {
        this.gameEventHandler.registerEventListener(behavior);
    }

    @Override
    public InputOverrideHandler getInputOverrideHandler() {
        return this.inputOverrideHandler;
    }

    @Override
    public CustomGoalProcess getCustomGoalProcess() {
        return this.customGoalProcess;
    }

    @Override
    public GetToBlockProcess getGetToBlockProcess() {
        return this.getToBlockProcess;
    }

    @Override
    public IEntityContext getPlayerContext() {
        return this.playerContext;
    }

    public MemoryBehavior getMemoryBehavior() {
        return this.memoryBehavior;
    }

    @Override
    public FollowProcess getFollowProcess() {
        return this.followProcess;
    }

    @Override
    public BuilderProcess getBuilderProcess() {
        return this.builderProcess;
    }

    public InventoryBehavior getInventoryBehavior() {
        return this.inventoryBehavior;
    }

    @Override
    public LookBehavior getLookBehavior() {
        return this.lookBehavior;
    }

    @Override
    public ExploreProcess getExploreProcess() {
        return this.exploreProcess;
    }

    @Override
    public MineProcess getMineProcess() {
        return this.mineProcess;
    }

    @Override
    public FarmProcess getFarmProcess() {
        return this.farmProcess;
    }

    @Override
    public PathingBehavior getPathingBehavior() {
        return this.pathingBehavior;
    }

    @Override
    public WorldProvider getWorldProvider() {
        return (WorldProvider)IWorldProvider.KEY.get((Object)this.getPlayerContext().world());
    }

    @Override
    public IEventBus getGameEventHandler() {
        return this.gameEventHandler;
    }

    public ClientPathingBehaviour getClientPathingBehaviour() {
        if (this.clientPathingBehaviour == null) {
            throw new IllegalStateException("Not a clientside baritone instance");
        }
        return this.clientPathingBehaviour;
    }

    @Override
    public boolean isActive() {
        return this.pathingControlManager.isActive();
    }

    @Override
    public Settings settings() {
        return this.settings;
    }

    @Override
    public void logDebug(String message) {
        Automatone.LOGGER.debug(message);
        if (!BaritoneAPI.getGlobalSettings().chatDebug.get().booleanValue()) {
            return;
        }
        this.logDirect(message);
        if (!this.settings.syncWithOps.get().booleanValue()) {
            return;
        }
        MinecraftServer server = this.getPlayerContext().world().method_8503();
        for (class_3222 p : server.method_3760().method_14571()) {
            if (!server.method_3760().method_14569(p.method_7334())) continue;
            ((IBaritone)KEY.get((Object)p)).logDirect(message);
        }
    }

    public void readFromNbt(class_2487 tag) {
    }

    public void writeToNbt(class_2487 tag) {
    }

    public boolean shouldSyncWith(class_3222 player) {
        return player == this.playerContext.entity() || this.settings.syncWithOps.get() != false && player.field_13995.method_3835(player.method_7334()) >= 2;
    }

    public void writeSyncPacket(class_2540 buf, class_3222 recipient) {
        buf.writeBoolean(this.isActive());
        this.pathingBehavior.writeToPacket(buf);
    }

    public void applySyncPacket(class_2540 buf) {
        assert (this.clientPathingBehaviour != null) : "applySyncPacket called on a server world";
        boolean active = buf.readBoolean();
        if (active) {
            AutomatoneClient.renderList.add(this);
        } else {
            AutomatoneClient.renderList.remove(this);
        }
        this.clientPathingBehaviour.readFromPacket(buf);
    }

    public void serverTick() {
        this.getGameEventHandler().onTickServer();
    }
}

