/*
 * Decompiled with CFR 0.152.
 */
package f_baritone;

import com.mojang.authlib.GameProfile;
import f_baritone.Baritone;
import f_baritone.KeepName;
import f_baritone.api.IBaritone;
import f_baritone.api.fakeplayer.AutomatoneFakePlayer;
import f_baritone.api.fakeplayer.FakeClientPlayerEntity;
import f_baritone.api.fakeplayer.FakePlayers;
import f_baritone.api.selection.ISelectionManager;
import f_baritone.selection.SelectionRenderer;
import f_baritone.utils.PathRenderer;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

@KeepName
public final class AutomatoneClient
implements ClientModInitializer {
    public static final Set<Baritone> renderList = Collections.newSetFromMap(new WeakHashMap());
    public static final Set<ISelectionManager> selectionRenderList = Collections.newSetFromMap(new WeakHashMap());

    public static void onRenderPass(WorldRenderContext context) {
        class_310 mc = class_310.method_1551();
        for (Baritone baritone : renderList) {
            PathRenderer.render(context, baritone.getClientPathingBehaviour());
        }
        for (ISelectionManager selectionManager : selectionRenderList) {
            SelectionRenderer.renderSelections(selectionManager.getSelections());
        }
        if (!mc.method_1496()) {
            return;
        }
    }

    public void onInitializeClient() {
        WorldRenderEvents.BEFORE_DEBUG_RENDER.register(AutomatoneClient::onRenderPass);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FakePlayers.SPAWN_PACKET_ID, (client, handler, buf, responseSender) -> {
            int id = buf.method_10816();
            UUID uuid = buf.method_10790();
            class_1299 entityTypeId = (class_1299)class_7923.field_41177.method_10200(buf.method_10816());
            String name = buf.method_19772();
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            float yaw = (float)(buf.readByte() * 360) / 256.0f;
            float pitch = (float)(buf.readByte() * 360) / 256.0f;
            float headYaw = (float)(buf.readByte() * 360) / 256.0f;
            GameProfile profile = AutomatoneClient.readProfile(buf);
            client.execute(() -> this.spawnPlayer(id, uuid, entityTypeId, name, x, y, z, yaw, pitch, headYaw, profile));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FakePlayers.PROFILE_UPDATE_PACKET_ID, (client, handler, buf, responseSender) -> {
            int entityId = buf.method_10816();
            GameProfile profile = AutomatoneClient.readProfile(buf);
            client.execute(() -> {
                class_1297 entity = Objects.requireNonNull(client.field_1687).method_8469(entityId);
                if (entity instanceof AutomatoneFakePlayer) {
                    ((AutomatoneFakePlayer)entity).setDisplayProfile(profile);
                }
            });
        });
        ClientEntityEvents.ENTITY_UNLOAD.register((entity, world) -> {
            renderList.remove(IBaritone.KEY.getNullable((Object)entity));
            selectionRenderList.remove(ISelectionManager.KEY.getNullable((Object)entity));
        });
    }

    private <P extends class_1657> void spawnPlayer(int id, UUID uuid, class_1299<?> entityTypeId, String name, double x, double y, double z, float yaw, float pitch, float headYaw, GameProfile profile) {
        class_638 world = class_310.method_1551().field_1687;
        assert (world != null);
        class_1299<?> playerType = entityTypeId;
        Object other = FakeClientPlayerEntity.createClientFakePlayer(playerType, world, new GameProfile(uuid, name));
        other.method_5838(id);
        other.method_5814(x, y, z);
        ((class_1657)other).field_6283 = headYaw;
        ((class_1657)other).field_6220 = headYaw;
        ((class_1657)other).field_6241 = headYaw;
        ((class_1657)other).field_6259 = headYaw;
        other.method_5641(x, y, z, yaw, pitch);
        ((AutomatoneFakePlayer)other).setDisplayProfile(profile);
        world.method_2942(id, other);
    }

    @Nullable
    private static GameProfile readProfile(class_2540 buf) {
        boolean hasProfile = buf.readBoolean();
        return hasProfile ? new GameProfile(buf.method_10790(), buf.method_19772()) : null;
    }
}

