/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.properties;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import me.pepperbell.continuity.api.client.CtmProperties;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.properties.PropertiesParsingHelper;
import me.pepperbell.continuity.client.resource.ResourceRedirectHandler;
import me.pepperbell.continuity.client.util.MathUtil;
import me.pepperbell.continuity.client.util.TextureUtil;
import me.pepperbell.continuity.client.util.biome.BiomeHolder;
import me.pepperbell.continuity.client.util.biome.BiomeHolderManager;
import me.pepperbell.continuity.client.util.biome.BiomeSetPredicate;
import net.minecraft.class_151;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3268;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4730;
import net.minecraft.class_7923;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseCtmProperties
implements CtmProperties {
    public static final class_2960 SPECIAL_SKIP_ID = ContinuityClient.asId("special/skip");
    public static final class_2960 SPECIAL_DEFAULT_ID = ContinuityClient.asId("special/default");
    public static final class_4730 SPECIAL_SKIP_SPRITE_ID = TextureUtil.toSpriteId(SPECIAL_SKIP_ID);
    public static final class_4730 SPECIAL_DEFAULT_SPRITE_ID = TextureUtil.toSpriteId(SPECIAL_DEFAULT_ID);
    protected static final int DIRECTION_AMOUNT = class_2350.values().length;
    protected Properties properties;
    protected class_2960 resourceId;
    protected String packId;
    protected int packPriority;
    protected class_3300 resourceManager;
    protected String method;
    @Nullable
    protected Set<class_2960> matchTilesSet;
    @Nullable
    protected Predicate<class_2680> matchBlocksPredicate;
    protected List<class_2960> tiles = Collections.emptyList();
    @Nullable
    protected EnumSet<class_2350> faces;
    @Nullable
    protected Predicate<class_1959> biomePredicate;
    @Nullable
    protected IntPredicate heightPredicate;
    @Nullable
    protected Predicate<String> blockEntityNamePredicate;
    protected boolean prioritized = false;
    protected boolean valid = true;
    protected Set<class_4730> textureDependencies;
    protected List<class_4730> spriteIds;

    public BaseCtmProperties(Properties properties, class_2960 resourceId, class_3262 pack, int packPriority, class_3300 resourceManager, String method) {
        this.properties = properties;
        this.resourceId = resourceId;
        this.packId = pack.method_14409();
        this.packPriority = packPriority;
        this.resourceManager = resourceManager;
        this.method = method;
    }

    public Set<class_4730> getTextureDependencies() {
        if (this.textureDependencies == null) {
            this.resolveTiles();
        }
        return this.textureDependencies;
    }

    @Override
    public int compareTo(@NotNull CtmProperties o) {
        if (o instanceof BaseCtmProperties) {
            BaseCtmProperties o1 = (BaseCtmProperties)o;
            if (this.prioritized && !o1.prioritized) {
                return 1;
            }
            if (!this.prioritized && o1.prioritized) {
                return -1;
            }
            int c = MathUtil.signum(this.packPriority - o1.packPriority);
            if (c != 0) {
                return c;
            }
            return o1.getResourceId().method_12833(this.getResourceId());
        }
        return 0;
    }

    public void init() {
        this.parseMatchTiles();
        this.parseMatchBlocks();
        this.detectMatches();
        this.validateMatches();
        this.parseTiles();
        this.parseFaces();
        this.parseBiomes();
        this.parseHeights();
        this.parseLegacyHeights();
        this.parseName();
        this.parsePrioritize();
        this.parseResourceCondition();
    }

    protected void parseMatchTiles() {
        this.matchTilesSet = PropertiesParsingHelper.parseMatchTiles(this.properties, "matchTiles", this.resourceId, this.packId, ResourceRedirectHandler.get(this.resourceManager));
        if (this.matchTilesSet != null && this.matchTilesSet.isEmpty()) {
            this.valid = false;
        }
    }

    protected void parseMatchBlocks() {
        this.matchBlocksPredicate = PropertiesParsingHelper.parseBlockStates(this.properties, "matchBlocks", this.resourceId, this.packId);
        if (this.matchBlocksPredicate == PropertiesParsingHelper.EMPTY_BLOCK_STATE_PREDICATE) {
            this.valid = false;
        }
    }

    protected void detectMatches() {
        String baseName = FilenameUtils.getBaseName((String)this.resourceId.method_12832());
        if (this.matchBlocksPredicate == null && baseName.startsWith("block_")) {
            try {
                class_2960 id = new class_2960(baseName.substring(6));
                if (class_7923.field_41175.method_10250(id)) {
                    class_2248 block = (class_2248)class_7923.field_41175.method_10223(id);
                    this.matchBlocksPredicate = state -> state.method_26204() == block;
                }
            }
            catch (class_151 class_1512) {
                // empty catch block
            }
        }
    }

    protected void validateMatches() {
        if (this.matchTilesSet == null && this.matchBlocksPredicate == null) {
            ContinuityClient.LOGGER.error("No tile or block matches provided in file '" + String.valueOf(this.resourceId) + "' in pack '" + this.packId + "'");
            this.valid = false;
        }
    }

    protected void parseTiles() {
        String tilesStr = this.properties.getProperty("tiles");
        if (tilesStr == null) {
            ContinuityClient.LOGGER.error("No 'tiles' value provided in file '" + String.valueOf(this.resourceId) + "' in pack '" + this.packId + "'");
            this.valid = false;
            return;
        }
        String[] tileStrs = tilesStr.trim().split("[ ,]");
        if (tileStrs.length != 0) {
            String basePath = FilenameUtils.getPath((String)this.resourceId.method_12832());
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            for (int i = 0; i < tileStrs.length; ++i) {
                String tileStr = tileStrs[i];
                if (tileStr.isEmpty()) continue;
                if (tileStr.endsWith("<skip>") || tileStr.endsWith("<skip>.png")) {
                    listBuilder.add((Object)SPECIAL_SKIP_ID);
                    continue;
                }
                if (tileStr.endsWith("<default>") || tileStr.endsWith("<default>.png")) {
                    listBuilder.add((Object)SPECIAL_DEFAULT_ID);
                    continue;
                }
                String[] rangeParts = tileStr.split("-", 2);
                if (rangeParts.length != 0) {
                    Object path;
                    String namespace;
                    String[] parts;
                    if (rangeParts.length == 2) {
                        try {
                            int min = Integer.parseInt(rangeParts[0]);
                            int max = Integer.parseInt(rangeParts[1]);
                            if (min <= max) {
                                try {
                                    for (int tile = min; tile <= max; ++tile) {
                                        listBuilder.add((Object)this.resourceId.method_45136(basePath + tile + ".png"));
                                    }
                                    continue;
                                }
                                catch (class_151 e) {
                                    ContinuityClient.LOGGER.warn("Invalid 'tiles' element '" + tileStr + "' at index " + i + " in file '" + String.valueOf(this.resourceId) + "' in pack '" + this.packId + "'", (Throwable)e);
                                    continue;
                                }
                            }
                            ContinuityClient.LOGGER.warn("Invalid 'tiles' element '" + tileStr + "' at index " + i + " in file '" + String.valueOf(this.resourceId) + "' in pack '" + this.packId + "'");
                            continue;
                        }
                        catch (NumberFormatException min) {
                            // empty catch block
                        }
                    }
                    if ((parts = tileStr.split(":", 2)).length == 0) continue;
                    if (parts.length > 1) {
                        namespace = parts[0];
                        path = parts[1];
                    } else {
                        namespace = null;
                        path = parts[0];
                    }
                    if (!((String)path).endsWith(".png")) {
                        path = (String)path + ".png";
                    }
                    if (namespace == null) {
                        if (((String)path).startsWith("assets/minecraft/")) {
                            path = ((String)path).substring(17);
                        } else if (((String)path).startsWith("./")) {
                            path = basePath + ((String)path).substring(2);
                        } else if (((String)path).startsWith("~/")) {
                            path = "optifine/" + ((String)path).substring(2);
                        } else if (((String)path).startsWith("/")) {
                            path = "optifine/" + ((String)path).substring(1);
                        }
                        if (!((String)path).startsWith("textures/") && !((String)path).startsWith("optifine/")) {
                            path = basePath + (String)path;
                        }
                        if (((String)path).startsWith("optifine/")) {
                            namespace = this.resourceId.method_12836();
                        }
                    } else if (!((String)path).contains("/")) {
                        path = "textures/block/" + (String)path;
                    } else if (!((String)path).startsWith("textures/") && !((String)path).startsWith("optifine/")) {
                        path = "textures/" + (String)path;
                    }
                    if (namespace == null) {
                        namespace = "minecraft";
                    }
                    try {
                        listBuilder.add((Object)new class_2960(namespace, (String)path));
                    }
                    catch (class_151 e) {
                        ContinuityClient.LOGGER.warn("Invalid 'tiles' element '" + tileStr + "' at index " + i + " in file '" + String.valueOf(this.resourceId) + "' in pack '" + this.packId + "'", (Throwable)e);
                    }
                    continue;
                }
                ContinuityClient.LOGGER.warn("Invalid 'tiles' element '" + tileStr + "' at index " + i + " in file '" + String.valueOf(this.resourceId) + "' in pack '" + this.packId + "'");
            }
            this.tiles = listBuilder.build();
        }
    }

    protected void parseFaces() {
        String facesStr = this.properties.getProperty("faces");
        if (facesStr == null) {
            return;
        }
        String[] faceStrs = facesStr.trim().split("[ ,]");
        if (faceStrs.length != 0) {
            this.faces = EnumSet.noneOf(class_2350.class);
            for (int i = 0; i < faceStrs.length; ++i) {
                String faceStr = faceStrs[i];
                if (faceStr.isEmpty()) continue;
                String faceStr1 = faceStr.toUpperCase(Locale.ROOT);
                if (faceStr1.equals("BOTTOM")) {
                    this.faces.add(class_2350.field_11033);
                    continue;
                }
                if (faceStr1.equals("TOP")) {
                    this.faces.add(class_2350.field_11036);
                    continue;
                }
                if (faceStr1.equals("SIDES")) {
                    Iterators.addAll(this.faces, (Iterator)class_2350.class_2353.field_11062.iterator());
                    continue;
                }
                if (faceStr1.equals("ALL")) {
                    this.faces = null;
                    return;
                }
                try {
                    this.faces.add(class_2350.valueOf((String)faceStr1));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    ContinuityClient.LOGGER.warn("Unknown 'faces' element '" + faceStr + "' at index " + i + " in file '" + String.valueOf(this.resourceId) + "' in pack '" + this.packId + "'");
                }
            }
            if (this.faces.isEmpty()) {
                this.valid = false;
            } else if (this.faces.size() == DIRECTION_AMOUNT) {
                this.faces = null;
            }
        } else {
            this.valid = false;
        }
    }

    protected void parseBiomes() {
        String biomesStr = this.properties.getProperty("biomes");
        if (biomesStr == null) {
            return;
        }
        if (!(biomesStr = biomesStr.trim()).isEmpty()) {
            String[] biomeStrs;
            boolean negate = false;
            if (biomesStr.charAt(0) == '!') {
                negate = true;
                biomesStr = biomesStr.substring(1);
            }
            if ((biomeStrs = biomesStr.split(" ")).length != 0) {
                ObjectOpenHashSet biomeHolderSet = new ObjectOpenHashSet();
                for (int i = 0; i < biomeStrs.length; ++i) {
                    String biomeStr = biomeStrs[i];
                    if (biomeStr.isEmpty()) continue;
                    try {
                        class_2960 biomeId = new class_2960(biomeStr.toLowerCase(Locale.ROOT));
                        biomeHolderSet.add((Object)BiomeHolderManager.getOrCreateHolder(biomeId));
                        continue;
                    }
                    catch (class_151 e) {
                        ContinuityClient.LOGGER.warn("Invalid 'biomes' element '" + biomeStr + "' at index " + i + " in file '" + String.valueOf(this.resourceId) + "' in pack '" + this.packId + "'", (Throwable)e);
                    }
                }
                if (!biomeHolderSet.isEmpty()) {
                    biomeHolderSet.trim();
                    this.biomePredicate = new BiomeSetPredicate((Set<BiomeHolder>)biomeHolderSet);
                    if (negate) {
                        this.biomePredicate = this.biomePredicate.negate();
                    }
                } else if (!negate) {
                    this.valid = false;
                }
            } else if (!negate) {
                this.valid = false;
            }
        } else {
            this.valid = false;
        }
    }

    protected void parseHeights() {
        String heightsStr = this.properties.getProperty("heights");
        if (heightsStr == null) {
            return;
        }
        String[] heightStrs = heightsStr.trim().split("[ ,]");
        if (heightStrs.length != 0) {
            ObjectArrayList predicateList = new ObjectArrayList();
            for (int i = 0; i < heightStrs.length; ++i) {
                String heightStr1;
                String heightStr = heightStrs[i];
                if (heightStr.isEmpty()) continue;
                String[] parts = heightStr.split("\\.\\.", 2);
                if (parts.length == 2) {
                    try {
                        int max;
                        int min;
                        if (parts[1].isEmpty()) {
                            min = Integer.parseInt(parts[0]);
                            predicateList.add(y -> y >= min);
                            continue;
                        }
                        if (parts[0].isEmpty()) {
                            int max2 = Integer.parseInt(parts[1]);
                            predicateList.add(y -> y <= max2);
                            continue;
                        }
                        min = Integer.parseInt(parts[0]);
                        if (min < (max = Integer.parseInt(parts[1]))) {
                            predicateList.add(y -> y >= min && y <= max);
                            continue;
                        }
                        if (min > max) {
                            predicateList.add(y -> y >= max && y <= min);
                            continue;
                        }
                        predicateList.add(y -> y == min);
                        continue;
                    }
                    catch (NumberFormatException min) {
                    }
                } else if (parts.length == 1 && !(heightStr1 = heightStr.replaceAll("[()]", "")).isEmpty()) {
                    int separatorIndex = heightStr1.indexOf(45, heightStr1.charAt(0) == '-' ? 1 : 0);
                    try {
                        int max;
                        if (separatorIndex == -1) {
                            int height = Integer.parseInt(heightStr1);
                            predicateList.add(y -> y == height);
                            continue;
                        }
                        int min = Integer.parseInt(heightStr1.substring(0, separatorIndex));
                        if (min < (max = Integer.parseInt(heightStr1.substring(separatorIndex + 1)))) {
                            predicateList.add(y -> y >= min && y <= max);
                            continue;
                        }
                        if (min > max) {
                            predicateList.add(y -> y >= max && y <= min);
                            continue;
                        }
                        predicateList.add(y -> y == min);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                ContinuityClient.LOGGER.warn("Invalid 'heights' element '" + heightStr + "' at index " + i + " in file '" + String.valueOf(this.resourceId) + "' in pack '" + this.packId + "'");
            }
            if (!predicateList.isEmpty()) {
                IntPredicate[] predicateArray = (IntPredicate[])predicateList.toArray(IntPredicate[]::new);
                this.heightPredicate = y -> {
                    for (IntPredicate predicate : predicateArray) {
                        if (!predicate.test(y)) continue;
                        return true;
                    }
                    return false;
                };
            } else {
                this.valid = false;
            }
        } else {
            this.valid = false;
        }
    }

    protected void parseLegacyHeights() {
        if (this.heightPredicate == null) {
            boolean hasMaxHeight;
            String minHeightStr = this.properties.getProperty("minHeight");
            String maxHeightStr = this.properties.getProperty("maxHeight");
            boolean hasMinHeight = minHeightStr != null;
            boolean bl = hasMaxHeight = maxHeightStr != null;
            if (hasMinHeight || hasMaxHeight) {
                int min = 0;
                int max = 0;
                if (hasMinHeight) {
                    try {
                        min = Integer.parseInt(minHeightStr.trim());
                    }
                    catch (NumberFormatException e) {
                        ContinuityClient.LOGGER.warn("Invalid 'minHeight' value '" + minHeightStr + "' in file '" + String.valueOf(this.resourceId) + "' in pack '" + this.packId + "'");
                        hasMinHeight = false;
                    }
                }
                if (hasMaxHeight) {
                    try {
                        max = Integer.parseInt(maxHeightStr.trim());
                    }
                    catch (NumberFormatException e) {
                        ContinuityClient.LOGGER.warn("Invalid 'maxHeight' value '" + minHeightStr + "' in file '" + String.valueOf(this.resourceId) + "' in pack '" + this.packId + "'");
                        hasMaxHeight = false;
                    }
                }
                int finalMin = min;
                int finalMax = max;
                if (hasMinHeight && hasMaxHeight) {
                    this.heightPredicate = finalMin < finalMax ? y -> y >= finalMin && y <= finalMax : (finalMin > finalMax ? y -> y >= finalMax && y <= finalMin : y -> y == finalMin);
                } else if (hasMinHeight) {
                    this.heightPredicate = y -> y >= finalMin;
                } else if (hasMaxHeight) {
                    this.heightPredicate = y -> y <= finalMax;
                }
            }
        }
    }

    protected void parseName() {
        boolean caseInsensitive;
        boolean isPattern;
        String nameStr = this.properties.getProperty("name");
        if (nameStr == null) {
            return;
        }
        if ((nameStr = StringEscapeUtils.escapeJava((String)nameStr.trim())).startsWith("regex:")) {
            nameStr = nameStr.substring(6);
            isPattern = false;
            caseInsensitive = false;
        } else if (nameStr.startsWith("iregex:")) {
            nameStr = nameStr.substring(7);
            isPattern = false;
            caseInsensitive = true;
        } else if (nameStr.startsWith("pattern:")) {
            nameStr = nameStr.substring(8);
            isPattern = true;
            caseInsensitive = false;
        } else if (nameStr.startsWith("ipattern:")) {
            nameStr = nameStr.substring(9);
            isPattern = true;
            caseInsensitive = true;
        } else {
            this.blockEntityNamePredicate = nameStr::equals;
            return;
        }
        String patternStr = nameStr;
        if (isPattern) {
            patternStr = Pattern.quote(patternStr);
            patternStr = patternStr.replace("?", "\\E.\\Q");
            patternStr = patternStr.replace("*", "\\E.*\\Q");
        }
        Pattern pattern = Pattern.compile(patternStr, caseInsensitive ? 2 : 0);
        this.blockEntityNamePredicate = blockEntityName -> pattern.matcher((CharSequence)blockEntityName).matches();
    }

    protected void parsePrioritize() {
        String prioritizeStr = this.properties.getProperty("prioritize");
        if (prioritizeStr == null) {
            this.prioritized = this.matchTilesSet != null;
            return;
        }
        this.prioritized = Boolean.parseBoolean(prioritizeStr.trim());
    }

    protected void parseResourceCondition() {
        String conditionsStr = this.properties.getProperty("resourceCondition");
        if (conditionsStr == null) {
            return;
        }
        String[] conditionStrs = conditionsStr.trim().split("\\|");
        if (conditionStrs.length != 0) {
            class_3268 defaultPack = class_310.method_1551().method_45573();
            for (int i = 0; i < conditionStrs.length; ++i) {
                String conditionStr = conditionStrs[i];
                if (conditionStr.isEmpty()) continue;
                String[] parts = conditionStr.split("@", 2);
                if (parts.length != 0) {
                    Optional optionalResource;
                    class_2960 resourceId;
                    String resourceStr = parts[0];
                    try {
                        resourceId = new class_2960(resourceStr);
                    }
                    catch (class_151 e) {
                        ContinuityClient.LOGGER.warn("Invalid resource '" + resourceStr + "' in 'resourceCondition' element '" + conditionStr + "' at index " + i + " in file '" + String.valueOf(this.resourceId) + "' in pack '" + this.packId + "'", (Throwable)e);
                        continue;
                    }
                    String packStr = parts.length > 1 ? parts[1] : null;
                    if (packStr == null || packStr.equals("default")) {
                        optionalResource = this.resourceManager.method_14486(resourceId);
                        if (!optionalResource.isPresent() || ((class_3298)optionalResource.get()).method_45304() == defaultPack) continue;
                        this.valid = false;
                        break;
                    }
                    if (packStr.equals("programmer_art")) {
                        optionalResource = this.resourceManager.method_14486(resourceId);
                        if (!optionalResource.isPresent() || ((class_3298)optionalResource.get()).method_45304().method_14409().equals("programmer_art")) continue;
                        this.valid = false;
                        break;
                    }
                    ContinuityClient.LOGGER.warn("Unknown pack '" + packStr + "' in 'resourceCondition' element '" + conditionStr + "' at index " + i + " in file '" + String.valueOf(this.resourceId) + "' in pack '" + this.packId + "'");
                    continue;
                }
                ContinuityClient.LOGGER.warn("Invalid 'resourceCondition' element '" + conditionStr + "' at index " + i + " in file '" + String.valueOf(this.resourceId) + "' in pack '" + this.packId + "'");
            }
        }
    }

    protected boolean isValid() {
        return this.valid;
    }

    protected void resolveTiles() {
        this.textureDependencies = new ObjectOpenHashSet();
        this.spriteIds = new ObjectArrayList();
        ResourceRedirectHandler redirectHandler = ResourceRedirectHandler.get(this.resourceManager);
        for (class_2960 tile : this.tiles) {
            class_4730 spriteId;
            if (tile.equals((Object)SPECIAL_SKIP_ID)) {
                spriteId = SPECIAL_SKIP_SPRITE_ID;
            } else if (tile.equals((Object)SPECIAL_DEFAULT_ID)) {
                spriteId = SPECIAL_DEFAULT_SPRITE_ID;
            } else {
                String namespace = tile.method_12836();
                String path = tile.method_12832();
                if (path.startsWith("textures/")) {
                    if ((path = path.substring(9)).endsWith(".png")) {
                        path = path.substring(0, path.length() - 4);
                    }
                    spriteId = TextureUtil.toSpriteId(new class_2960(namespace, path));
                    this.textureDependencies.add(spriteId);
                } else if (redirectHandler != null) {
                    path = redirectHandler.getSourceSpritePath(path);
                    spriteId = TextureUtil.toSpriteId(new class_2960(namespace, path));
                    this.textureDependencies.add(spriteId);
                } else {
                    spriteId = TextureUtil.MISSING_SPRITE_ID;
                }
            }
            this.spriteIds.add(spriteId);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public class_2960 getResourceId() {
        return this.resourceId;
    }

    public String getPackId() {
        return this.packId;
    }

    public int getPackPriority() {
        return this.packPriority;
    }

    public String getMethod() {
        return this.method;
    }

    @Nullable
    public Set<class_2960> getMatchTilesSet() {
        return this.matchTilesSet;
    }

    @Nullable
    public Predicate<class_2680> getMatchBlocksPredicate() {
        return this.matchBlocksPredicate;
    }

    public int getTileAmount() {
        return this.tiles.size();
    }

    @Nullable
    public EnumSet<class_2350> getFaces() {
        return this.faces;
    }

    @Nullable
    public Predicate<class_1959> getBiomePredicate() {
        return this.biomePredicate;
    }

    @Nullable
    public IntPredicate getHeightPredicate() {
        return this.heightPredicate;
    }

    @Nullable
    public Predicate<String> getBlockEntityNamePredicate() {
        return this.blockEntityNamePredicate;
    }

    public boolean isPrioritized() {
        return this.prioritized;
    }

    public List<class_4730> getSpriteIds() {
        if (this.spriteIds == null) {
            this.resolveTiles();
        }
        return this.spriteIds;
    }

    public static <T extends BaseCtmProperties> CtmProperties.Factory<T> wrapFactory(CtmProperties.Factory<T> factory) {
        return (properties, resourceId, pack, packPriority, resourceManager, method) -> {
            BaseCtmProperties ctmProperties = (BaseCtmProperties)factory.createProperties(properties, resourceId, pack, packPriority, resourceManager, method);
            if (ctmProperties == null) {
                return null;
            }
            ctmProperties.init();
            if (ctmProperties.isValid()) {
                return ctmProperties;
            }
            return null;
        };
    }
}

