/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import com.mojang.brigadier.CommandDispatcher;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.detail.FabricDetailRegistries;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.media.MediaLookup;
import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.node.wired.WiredElementLookup;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.PeripheralLookup;
import dan200.computercraft.impl.Peripherals;
import dan200.computercraft.shared.CommonHooks;
import dan200.computercraft.shared.FabricCommonHooks;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.command.CommandComputerCraft;
import dan200.computercraft.shared.config.ConfigSpec;
import dan200.computercraft.shared.details.FluidDetails;
import dan200.computercraft.shared.integration.CreateIntegration;
import dan200.computercraft.shared.network.MessageType;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.client.UpgradesLoadedMessage;
import dan200.computercraft.shared.network.server.ServerNetworkContext;
import dan200.computercraft.shared.network.server.ServerNetworking;
import dan200.computercraft.shared.peripheral.generic.methods.InventoryMethods;
import dan200.computercraft.shared.platform.FabricConfigFile;
import dan200.computercraft.shared.platform.FabricMessageType;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.lookup.v1.item.ItemApiLookup;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_7923;
import org.jspecify.annotations.Nullable;

public class ComputerCraft {
    private static final class_5218 SERVERCONFIG = new class_5218("serverconfig");

    public static void init() {
        for (MessageType<? extends NetworkMessage<ServerNetworkContext>> type : NetworkMessages.getServerbound()) {
            ServerPlayNetworking.registerGlobalReceiver(FabricMessageType.toFabricType(type), (packet, player, sender) -> packet.payload().handle(() -> player));
        }
        ModRegistry.register();
        ModRegistry.registerMainThread();
        ModRegistry.registerPeripherals(new BlockComponentImpl<IPeripheral, class_2350>(PeripheralLookup.get()));
        ModRegistry.registerWiredElements(new BlockComponentImpl<WiredElement, class_2350>(WiredElementLookup.get()));
        ModRegistry.registerMedia(new ItemComponentImpl<IMedia>(MediaLookup.get()));
        CommandRegistrationCallback.EVENT.register((dispatcher, context, environment) -> CommandComputerCraft.register((CommandDispatcher<class_2168>)dispatcher));
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            ((FabricConfigFile)ConfigSpec.serverSpec).load(server.method_27050(SERVERCONFIG).resolve("computercraft-server.toml"));
            CommonHooks.onServerStarting(server);
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(s -> {
            CommonHooks.onServerStopped();
            ((FabricConfigFile)ConfigSpec.serverSpec).unload();
        });
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> ServerNetworking.sendToPlayer(new UpgradesLoadedMessage(), player));
        ServerTickEvents.START_SERVER_TICK.register(CommonHooks::onServerTickStart);
        ServerTickEvents.START_SERVER_TICK.register(s -> CommonHooks.onServerTickEnd());
        ServerChunkEvents.CHUNK_UNLOAD.register((l, c) -> CommonHooks.onServerChunkUnload(c));
        PlayerBlockBreakEvents.BEFORE.register(FabricCommonHooks::onBlockDestroy);
        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, tableBuilder, source) -> {
            class_55.class_56 pool = CommonHooks.getExtraLootPool(id);
            if (pool != null) {
                tableBuilder.method_336(pool);
            }
        });
        ItemGroupEvents.MODIFY_ENTRIES_ALL.register((tab, entries) -> CommonHooks.onBuildCreativeTab((class_5321<class_1761>)((class_5321)class_7923.field_44687.method_29113((Object)tab).orElseThrow()), entries.getContext(), (class_1761.class_7704)entries));
        CommonHooks.onDatapackReload((name, listener) -> ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new ReloadListener((String)name, (class_3302)listener)));
        FabricDetailRegistries.FLUID_VARIANT.addProvider(FluidDetails::fill);
        ComputerCraftAPI.registerGenericSource(new InventoryMethods());
        Peripherals.addGenericLookup((world, pos, state, blockEntity, side, invalidate) -> InventoryMethods.extractContainer((class_1937)world, pos, state, blockEntity, side));
        if (FabricLoader.getInstance().isModLoaded("create")) {
            CreateIntegration.setup();
        }
    }

    private record BlockComponentImpl<T, C>(BlockApiLookup<T, C> lookup) implements ModRegistry.BlockComponent<T, C>
    {
        @Override
        public <B extends class_2586> void registerForBlockEntity(class_2591<B> blockEntityType, BiFunction<? super B, C, @Nullable T> provider) {
            this.lookup.registerForBlockEntity(provider, blockEntityType);
        }
    }

    private record ItemComponentImpl<T>(ItemApiLookup<T, @Nullable Void> lookup) implements ModRegistry.ItemComponent<T>
    {
        @Override
        public void registerForItems(BiFunction<class_1799, @Nullable Void, @Nullable T> provider, class_1935 ... items) {
            this.lookup().registerForItems(provider::apply, items);
        }

        @Override
        public void registerFallback(BiFunction<class_1799, @Nullable Void, @Nullable T> provider) {
            this.lookup().registerFallback(provider::apply);
        }
    }

    private record ReloadListener(String name, class_3302 listener) implements IdentifiableResourceReloadListener
    {
        public class_2960 getFabricId() {
            return new class_2960("computercraft", this.name);
        }

        public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            return this.listener.method_25931(preparationBarrier, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor);
        }
    }
}

