/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.util.debug;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import org.threadly.util.Pair;
import org.threadly.util.debug.ComparableTrace;

public class StackTracker {
    private static final Function<Object, LongAdder> ADDER_FACTORY = ignored -> new LongAdder();
    private final Map<ComparableTrace, LongAdder> traces = new ConcurrentHashMap<ComparableTrace, LongAdder>();

    public void recordStack() {
        this.traces.computeIfAbsent(new ComparableTrace(Thread.currentThread().getStackTrace()), ADDER_FACTORY).increment();
    }

    public List<Pair<StackTraceElement[], Long>> dumpStackCounts() {
        ArrayList<Pair<StackTraceElement[], Long>> result = new ArrayList<Pair<StackTraceElement[], Long>>(this.traces.size());
        for (Map.Entry<ComparableTrace, LongAdder> e : this.traces.entrySet()) {
            result.add(new Pair<StackTraceElement[], Long>(Arrays.copyOfRange(e.getKey().elements, 2, e.getKey().elements.length), e.getValue().sum()));
        }
        return result;
    }

    public void reset() {
        this.traces.clear();
    }
}

