/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.util.debug;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.threadly.util.Clock;

public class DebugLogger {
    protected static final boolean LOG_TIME_DEFAULT = false;
    protected static final String TIME_DELIM = " - ";
    protected static volatile ConcurrentSkipListMap<Long, String> logMap = new ConcurrentSkipListMap();

    public static void log(String msg) {
        long time = Clock.accurateTimeNanos();
        String replacement = logMap.putIfAbsent(time, msg);
        while (replacement != null) {
            replacement = logMap.putIfAbsent(++time, msg);
        }
    }

    public static int getCurrentMessageQty() {
        return logMap.size();
    }

    public static String getAllStoredMessages() {
        return DebugLogger.getAllStoredMessages(false);
    }

    public static String getAllStoredMessages(boolean includeLogTimes) {
        ConcurrentSkipListMap<Long, String> currentLog = logMap;
        logMap = new ConcurrentSkipListMap();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        StringBuilder result = new StringBuilder();
        Iterator<Map.Entry<Long, String>> it = currentLog.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, String> entry = it.next();
            if (includeLogTimes) {
                result.append(entry.getKey()).append(TIME_DELIM).append(entry.getValue());
            } else {
                result.append(entry.getValue());
            }
            if (!it.hasNext()) continue;
            result.append(System.lineSeparator());
        }
        return result.toString();
    }

    public static String getOldestLogMessages(int qty) {
        return DebugLogger.getOldestLogMessages(qty, false);
    }

    public static String getOldestLogMessages(int qty, boolean includeLogTimes) {
        StringBuilder result = new StringBuilder();
        Iterator<Map.Entry<Long, String>> it = logMap.entrySet().iterator();
        for (int collectedQty = 0; it.hasNext() && collectedQty < qty; ++collectedQty) {
            Map.Entry<Long, String> entry = it.next();
            if (includeLogTimes) {
                result.append(entry.getKey()).append(TIME_DELIM).append(entry.getValue());
            } else {
                result.append(entry.getValue());
            }
            if (it.hasNext()) {
                result.append(System.lineSeparator());
            }
            it.remove();
        }
        return result.toString();
    }
}

