/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.util;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.threadly.concurrent.CentralThreadlyPool;
import org.threadly.concurrent.SchedulerService;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.ExceptionHandler;
import org.threadly.util.StackSuppressedRuntimeException;
import org.threadly.util.StringBufferWriter;
import org.threadly.util.StringBuilderWriter;

public class ExceptionUtils {
    protected static final short INITIAL_BUFFER_PAD_AMOUNT_PER_TRACE_LINE = 16;
    protected static final short INITIAL_BUFFER_PAD_AMOUNT_FOR_STACK = 64;
    protected static final short CAUSE_CYCLE_DEPTH_TRIGGER = 20;
    protected static final ThreadLocal<ExceptionHandler> THREAD_LOCAL_EXCEPTION_HANDLER;
    protected static final InheritableThreadLocal<ExceptionHandler> INHERITED_EXCEPTION_HANDLER;
    protected static volatile ExceptionHandler defaultExceptionHandler;
    private static final int DEFAULT_OVERFLOW_CHECK_MILLIS = 10000;
    private static final SchedulerService EXCEPTION_SCHEDULER;
    private static final Runnable STACK_OVERFLOW_TASK;
    private static volatile Error handledError;
    private static volatile Throwable handledErrorCause;

    public static synchronized void changeStackOverflowCheckFrequency(int frequencyMillis) {
        EXCEPTION_SCHEDULER.remove(STACK_OVERFLOW_TASK);
        if (frequencyMillis > 0) {
            EXCEPTION_SCHEDULER.scheduleAtFixedRate(STACK_OVERFLOW_TASK, frequencyMillis, frequencyMillis);
        }
    }

    public static void setThreadExceptionHandler(ExceptionHandler exceptionHandler) {
        THREAD_LOCAL_EXCEPTION_HANDLER.set(exceptionHandler);
    }

    public static void setInheritableExceptionHandler(ExceptionHandler exceptionHandler) {
        INHERITED_EXCEPTION_HANDLER.set(exceptionHandler);
    }

    public static void setDefaultExceptionHandler(ExceptionHandler exceptionHandler) {
        defaultExceptionHandler = exceptionHandler;
    }

    public static ExceptionHandler getThreadLocalExceptionHandler() {
        return THREAD_LOCAL_EXCEPTION_HANDLER.get();
    }

    public static ExceptionHandler getExceptionHandler() {
        ExceptionHandler eh = THREAD_LOCAL_EXCEPTION_HANDLER.get();
        if (eh != null) {
            return eh;
        }
        eh = (ExceptionHandler)INHERITED_EXCEPTION_HANDLER.get();
        if (eh != null) {
            return eh;
        }
        return defaultExceptionHandler;
    }

    public static void handleException(Throwable t) {
        if (t == null) {
            return;
        }
        try {
            ExceptionHandler ehi = ExceptionUtils.getExceptionHandler();
            if (ehi != null) {
                ehi.handleException(t);
            } else {
                Thread currentThread = Thread.currentThread();
                Thread.UncaughtExceptionHandler ueHandler = currentThread.getUncaughtExceptionHandler();
                ueHandler.uncaughtException(currentThread, t);
            }
        }
        catch (StackOverflowError soe) {
            handledErrorCause = t;
            handledError = soe;
        }
        catch (Throwable handlerThrown) {
            try {
                System.err.println("Error handling exception: ");
                t.printStackTrace();
                System.err.println("Error thrown when handling exception: ");
                handlerThrown.printStackTrace();
            }
            catch (Error soe) {
                handledErrorCause = t;
                handledError = soe;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected static void trimStack(Throwable t, int methodsToRemove) {
        StackTraceElement[] originalstack = t.getStackTrace();
        if (originalstack.length <= methodsToRemove) {
            throw new IllegalArgumentException("Can not remove entire stack");
        }
        StackTraceElement[] newStack = new StackTraceElement[originalstack.length - methodsToRemove];
        System.arraycopy(originalstack, methodsToRemove, newStack, 0, newStack.length);
        t.setStackTrace(newStack);
    }

    public static RuntimeException makeRuntime(Throwable t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        TransformedException result = new TransformedException(t);
        ExceptionUtils.trimStack(result, 1);
        return result;
    }

    public static RuntimeException makeRuntime(Throwable t, boolean suppressWrappedStack) {
        RuntimeException result;
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        if (suppressWrappedStack) {
            result = new TransformedSuppressedStackException(t);
        } else {
            result = new TransformedException(t);
            ExceptionUtils.trimStack(result, 1);
        }
        return result;
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable cause;
        ArgumentVerifier.assertNotNull(throwable, "throwable");
        Throwable result = throwable;
        int depth = 0;
        while ((cause = result.getCause()) != null) {
            result = cause;
            if (++depth <= 20) continue;
            ArrayList<Throwable> causeChain = ExceptionUtils.unwrapThrowableCycleAwareCauseChain(throwable);
            return causeChain.get(causeChain.size() - 1);
        }
        return result;
    }

    protected static ArrayList<Throwable> unwrapThrowableCycleAwareCauseChain(Throwable throwable) {
        ArrayList<Throwable> causeChain = new ArrayList<Throwable>();
        causeChain.add(throwable);
        Throwable cause = throwable;
        while ((cause = cause.getCause()) != null) {
            for (int i = causeChain.size() - 1; i > -1; --i) {
                if (causeChain.get(i) != cause) continue;
                return causeChain;
            }
            causeChain.add(cause);
        }
        return causeChain;
    }

    /*
     * WARNING - void declaration
     */
    public static Throwable getCauseOfTypes(Throwable rootError, Iterable<? extends Class<? extends Throwable>> types) {
        ArgumentVerifier.assertNotNull(types, "types");
        if (rootError == null) {
            return null;
        }
        Throwable t = rootError;
        int depth = 0;
        do {
            void var5_7;
            for (Class<? extends Throwable> clazz : types) {
                if (!clazz.isInstance(t)) continue;
                return t;
            }
            if (++depth <= 20) continue;
            ArrayList<Throwable> causeChain = ExceptionUtils.unwrapThrowableCycleAwareCauseChain(t);
            int n = causeChain.size() - 1;
            while (var5_7 > 0) {
                t = causeChain.get((int)var5_7);
                for (Class<? extends Throwable> clazz : types) {
                    if (!clazz.isInstance(t)) continue;
                    return t;
                }
                --var5_7;
            }
            return null;
        } while ((t = t.getCause()) != null && t != rootError);
        return null;
    }

    public static boolean hasCauseOfTypes(Throwable rootError, Iterable<? extends Class<? extends Throwable>> types) {
        return ExceptionUtils.getCauseOfTypes(rootError, types) != null;
    }

    public static <T extends Throwable> T getCauseOfType(Throwable rootError, Class<? extends T> type) {
        ArgumentVerifier.assertNotNull(type, "type");
        if (rootError == null) {
            return null;
        }
        Throwable t = rootError;
        int depth = 0;
        do {
            if (type.isInstance(t)) {
                return (T)t;
            }
            if (++depth <= 20) continue;
            ArrayList<Throwable> causeChain = ExceptionUtils.unwrapThrowableCycleAwareCauseChain(t);
            for (int i = causeChain.size() - 1; i > 0; --i) {
                t = causeChain.get(i);
                if (!type.isInstance(t)) continue;
                return (T)t;
            }
            return null;
        } while ((t = t.getCause()) != null && t != rootError);
        return null;
    }

    public static boolean hasCauseOfType(Throwable rootError, Class<? extends Throwable> type) {
        return ExceptionUtils.getCauseOfType(rootError, type) != null;
    }

    public static String stackToString(Throwable t) {
        if (t == null) {
            return "";
        }
        String msg = t.getMessage();
        int msgLength = msg == null ? 0 : msg.length();
        StringBuilder sb = new StringBuilder(msgLength + 64);
        ExceptionUtils.writeStackTo(t, sb);
        return sb.toString();
    }

    public static void writeStackTo(Throwable t, StringBuilder sb) {
        ExceptionUtils.writeStackTo(t, new StringBuilderWriter(sb));
    }

    public static void writeStackTo(Throwable t, StringBuffer sb) {
        ExceptionUtils.writeStackTo(t, new StringBufferWriter(sb));
    }

    public static void writeStackTo(Throwable t, Writer w) {
        if (t == null) {
            return;
        }
        try (PrintWriter pw = new PrintWriter(w);){
            t.printStackTrace(pw);
            pw.flush();
        }
    }

    public static String stackToString(StackTraceElement[] stack) {
        if (stack == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(stack.length * 16);
        ExceptionUtils.writeStackTo(stack, sb);
        return sb.toString();
    }

    public static void writeStackTo(StackTraceElement[] stack, StringBuilder stringBuilder) {
        if (stack == null) {
            return;
        }
        ArgumentVerifier.assertNotNull(stringBuilder, "stringBuilder");
        for (StackTraceElement ste : stack) {
            stringBuilder.append("\t at ").append(ste.toString()).append(System.lineSeparator());
        }
    }

    static {
        defaultExceptionHandler = null;
        EXCEPTION_SCHEDULER = CentralThreadlyPool.isolatedTaskPool();
        handledError = null;
        handledErrorCause = null;
        THREAD_LOCAL_EXCEPTION_HANDLER = new ThreadLocal();
        INHERITED_EXCEPTION_HANDLER = new InheritableThreadLocal();
        STACK_OVERFLOW_TASK = () -> {
            if (handledError != null) {
                Error toReportError = handledError;
                StackSuppressedRuntimeException stackOverflow = new StackSuppressedRuntimeException("Swallowed " + toReportError.getClass().getSimpleName() + " (others may have been missed)", handledErrorCause);
                stackOverflow.setStackTrace(toReportError.getStackTrace());
                handledErrorCause = null;
                handledError = null;
                ExceptionUtils.handleException(stackOverflow);
            }
        };
        ExceptionUtils.changeStackOverflowCheckFrequency(10000);
    }

    public static class TransformedSuppressedStackException
    extends StackSuppressedRuntimeException {
        private static final long serialVersionUID = 6501962264714125183L;

        protected TransformedSuppressedStackException(Throwable t) {
            super(t == null ? null : t.getMessage(), t);
        }
    }

    public static class TransformedException
    extends RuntimeException {
        private static final long serialVersionUID = 4524467217814731188L;

        protected TransformedException(Throwable t) {
            super(t == null ? null : t.getMessage(), t);
        }
    }
}

