/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<T>
implements Iterator<T> {
    protected final T[] array;
    private int pos;

    public static <T> Iterator<T> makeIterator(T[] array) {
        if (array == null || array.length == 0) {
            return Collections.emptyIterator();
        }
        return new ArrayIterator<T>(array);
    }

    public static <T> Iterable<T> makeIterable(T[] array) {
        return ArrayIterator.makeIterable(array, true);
    }

    public static <T> Iterable<T> makeIterable(T[] array, boolean newInstanceOnCall) {
        if (newInstanceOnCall) {
            return () -> new ArrayIterator<Object>(array);
        }
        ArrayIterator it = new ArrayIterator(array);
        return () -> {
            it.reset();
            return it;
        };
    }

    protected ArrayIterator(T[] array) {
        this.array = array;
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.array.length;
    }

    @Override
    public T next() {
        if (this.pos == this.array.length) {
            throw new NoSuchElementException("No elements remaining: " + this.pos);
        }
        return this.array[this.pos++];
    }

    public void reset() {
        this.pos = 0;
    }
}

