/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.util;

import org.threadly.util.StringUtils;

public class ArgumentVerifier {
    public static void assertNotNull(Object arg, String name) {
        if (arg == null) {
            throw new IllegalArgumentException(StringUtils.nullToEmpty(name) + " can not be null");
        }
    }

    public static void assertNotNegative(double val, String name) {
        if (val < 0.0) {
            throw new IllegalArgumentException(StringUtils.nullToEmpty(name) + " can not be negative: " + val);
        }
    }

    public static void assertGreaterThanZero(double val, String name) {
        if (val <= 0.0) {
            throw new IllegalArgumentException(StringUtils.nullToEmpty(name) + " must be > 0: " + val);
        }
    }

    public static void assertLessThan(double val, double compareVal, String name) {
        if (val >= compareVal) {
            throw new IllegalArgumentException(StringUtils.nullToEmpty(name) + " must be < " + compareVal + ": " + val);
        }
    }
}

