/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.limiter;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.threadly.concurrent.RunnableCallableAdapter;
import org.threadly.concurrent.RunnableContainer;
import org.threadly.concurrent.SubmitterScheduler;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.ListenableFutureTask;
import org.threadly.concurrent.wrapper.limiter.ExecutorLimiter;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.Clock;

public class SubmitterSchedulerLimiter
extends ExecutorLimiter
implements SubmitterScheduler {
    protected final SubmitterScheduler scheduler;

    public SubmitterSchedulerLimiter(SubmitterScheduler scheduler, int maxConcurrency) {
        this(scheduler, maxConcurrency, true);
    }

    public SubmitterSchedulerLimiter(SubmitterScheduler scheduler, int maxConcurrency, boolean limitFutureListenersExecution) {
        super(scheduler, maxConcurrency, limitFutureListenersExecution);
        this.scheduler = scheduler;
    }

    @Override
    public ListenableFuture<?> submitScheduled(Runnable task, long delayInMs) {
        return this.submitScheduled(task, null, delayInMs);
    }

    @Override
    public <T> ListenableFuture<T> submitScheduled(Runnable task, T result, long delayInMs) {
        return this.submitScheduled(RunnableCallableAdapter.adapt(task, result), delayInMs);
    }

    @Override
    public <T> ListenableFuture<T> submitScheduled(Callable<T> task, long delayInMs) {
        ArgumentVerifier.assertNotNull(task, "task");
        ListenableFutureTask<T> ft = new ListenableFutureTask<T>(task, this);
        this.doSchedule(ft, ft, delayInMs);
        return ft;
    }

    protected void doSchedule(Runnable task, ListenableFuture<?> future, long delayInMs) {
        if (delayInMs == 0L) {
            this.executeOrQueue(task, future);
        } else {
            this.scheduler.schedule(new DelayedExecutionRunnable(task), delayInMs);
        }
    }

    @Override
    public void schedule(Runnable task, long delayInMs) {
        ArgumentVerifier.assertNotNull(task, "task");
        ArgumentVerifier.assertNotNegative(delayInMs, "delayInMs");
        this.doSchedule(task, null, delayInMs);
    }

    protected void initialRecurringSchedule(RecurringWrapper rw, long initialDelay) {
        ArgumentVerifier.assertNotNegative(initialDelay, "initialDelay");
        if (initialDelay == 0L) {
            this.executeOrQueueWrapper(rw);
        } else {
            this.scheduler.schedule(rw.delayRunnable, initialDelay);
        }
    }

    @Override
    public void scheduleWithFixedDelay(Runnable task, long initialDelay, long recurringDelay) {
        ArgumentVerifier.assertNotNull(task, "task");
        ArgumentVerifier.assertNotNegative(recurringDelay, "recurringDelay");
        this.initialRecurringSchedule(new RecurringDelayWrapper(task, recurringDelay), initialDelay);
    }

    @Override
    public void scheduleAtFixedRate(Runnable task, long initialDelay, long period) {
        ArgumentVerifier.assertNotNull(task, "task");
        ArgumentVerifier.assertGreaterThanZero(period, "period");
        this.initialRecurringSchedule(new RecurringRateWrapper(task, initialDelay, period), initialDelay);
    }

    protected class RecurringRateWrapper
    extends RecurringWrapper {
        protected final long period;
        private long nextRunTime;

        public RecurringRateWrapper(Runnable runnable, long initialDelay, long period) {
            super(runnable);
            this.period = period;
            this.nextRunTime = Clock.accurateForwardProgressingMillis() + initialDelay + period;
        }

        @Override
        protected void doAfterRunTasks() {
            this.nextRunTime += this.period;
            long nextDelay = this.nextRunTime - Clock.accurateForwardProgressingMillis();
            if (nextDelay < 1L) {
                SubmitterSchedulerLimiter.this.executeOrQueueWrapper(this);
            } else {
                SubmitterSchedulerLimiter.this.scheduler.schedule(this.delayRunnable, nextDelay);
            }
        }
    }

    protected class RecurringDelayWrapper
    extends RecurringWrapper {
        protected final long recurringDelay;

        public RecurringDelayWrapper(Runnable runnable, long recurringDelay) {
            super(runnable);
            this.recurringDelay = recurringDelay;
        }

        @Override
        protected void doAfterRunTasks() {
            SubmitterSchedulerLimiter.this.scheduler.schedule(this.delayRunnable, this.recurringDelay);
        }
    }

    protected abstract class RecurringWrapper
    extends ExecutorLimiter.LimiterRunnableWrapper {
        protected final AtomicBoolean valid;
        protected final DelayedExecutionRunnable delayRunnable;

        public RecurringWrapper(Runnable runnable) {
            super(SubmitterSchedulerLimiter.this, runnable);
            this.valid = new AtomicBoolean(true);
            this.delayRunnable = new DelayedExecutionRunnable(this);
        }

        public boolean invalidate() {
            return this.valid.compareAndSet(true, false);
        }

        @Override
        public void run() {
            if (this.valid.get()) {
                super.run();
            }
        }
    }

    protected class DelayedExecutionRunnable
    implements Runnable,
    RunnableContainer {
        private final ExecutorLimiter.LimiterRunnableWrapper lrw;

        protected DelayedExecutionRunnable(Runnable runnable) {
            this(new ExecutorLimiter.LimiterRunnableWrapper(this$0, runnable));
        }

        protected DelayedExecutionRunnable(ExecutorLimiter.LimiterRunnableWrapper lrw) {
            this.lrw = lrw;
        }

        @Override
        public void run() {
            if (SubmitterSchedulerLimiter.this.canRunTask()) {
                this.lrw.run();
            } else {
                SubmitterSchedulerLimiter.this.addToQueue(this.lrw);
            }
        }

        @Override
        public Runnable getContainedRunnable() {
            return this.lrw.getContainedRunnable();
        }
    }
}

