/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.limiter;

import java.util.concurrent.Executor;
import org.threadly.concurrent.AbstractPriorityScheduler;
import org.threadly.concurrent.ReschedulingOperation;
import org.threadly.concurrent.SchedulerService;
import org.threadly.concurrent.TaskPriority;
import org.threadly.util.ExceptionUtils;

public class SingleThreadSchedulerSubPool
extends AbstractPriorityScheduler {
    private final SchedulerService delegateScheduler;
    private final NoThreadScheduler noThreadScheduler;
    private final TickTask tickTask;

    public SingleThreadSchedulerSubPool(SchedulerService delegateScheduler) {
        this(delegateScheduler, TaskPriority.High, 500L);
    }

    public SingleThreadSchedulerSubPool(SchedulerService delegateScheduler, TaskPriority defaultPriority, long maxWaitForLowPriorityInMs) {
        super(defaultPriority);
        this.delegateScheduler = delegateScheduler;
        this.noThreadScheduler = new NoThreadScheduler(defaultPriority, maxWaitForLowPriorityInMs);
        this.tickTask = new TickTask((Executor)delegateScheduler);
    }

    @Override
    public void scheduleWithFixedDelay(Runnable task, long initialDelay, long recurringDelay, TaskPriority priority) {
        this.noThreadScheduler.scheduleWithFixedDelay(task, initialDelay, recurringDelay, priority);
        this.delegateScheduler.scheduleWithFixedDelay(() -> this.tickTask.signalToRunImmediately(true), initialDelay, recurringDelay);
    }

    @Override
    public void scheduleAtFixedRate(Runnable task, long initialDelay, long period, TaskPriority priority) {
        this.noThreadScheduler.scheduleAtFixedRate(task, initialDelay, period, priority);
        this.delegateScheduler.scheduleAtFixedRate(() -> this.tickTask.signalToRunImmediately(true), initialDelay, period);
    }

    @Override
    public int getActiveTaskCount() {
        return this.noThreadScheduler.getActiveTaskCount();
    }

    @Override
    public boolean isShutdown() {
        return this.delegateScheduler.isShutdown();
    }

    @Override
    protected AbstractPriorityScheduler.QueueManager getQueueManager() {
        return this.noThreadScheduler.getQueueManager();
    }

    protected void executeTasks() {
        this.noThreadScheduler.tick(ExceptionUtils::handleException);
    }

    @Override
    protected AbstractPriorityScheduler.OneTimeTaskWrapper doSchedule(Runnable task, long delayInMillis, TaskPriority priority) {
        AbstractPriorityScheduler.OneTimeTaskWrapper result = this.noThreadScheduler.doSchedule(task, delayInMillis, priority);
        if (delayInMillis > 0L) {
            this.delegateScheduler.schedule(() -> this.tickTask.signalToRunImmediately(true), delayInMillis);
        } else {
            this.tickTask.signalToRun();
        }
        return result;
    }

    private static class NoThreadScheduler
    extends org.threadly.concurrent.NoThreadScheduler {
        public NoThreadScheduler(TaskPriority defaultPriority, long maxWaitForLowPriorityInMs) {
            super(defaultPriority, maxWaitForLowPriorityInMs);
        }

        @Override
        protected AbstractPriorityScheduler.OneTimeTaskWrapper doSchedule(Runnable task, long delayInMillis, TaskPriority priority) {
            return super.doSchedule(task, delayInMillis, priority);
        }

        @Override
        protected AbstractPriorityScheduler.QueueManager getQueueManager() {
            return super.getQueueManager();
        }
    }

    private class TickTask
    extends ReschedulingOperation {
        protected TickTask(Executor delegateExecutor) {
            super(Integer.MAX_VALUE, delegateExecutor);
        }

        @Override
        protected void run() {
            SingleThreadSchedulerSubPool.this.executeTasks();
        }
    }
}

