/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.limiter;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.threadly.concurrent.ContainerHelper;
import org.threadly.concurrent.RunnableContainer;
import org.threadly.concurrent.SchedulerService;
import org.threadly.concurrent.wrapper.limiter.SubmitterSchedulerLimiter;

public class SchedulerServiceLimiter
extends SubmitterSchedulerLimiter
implements SchedulerService {
    protected final SchedulerService scheduler;
    private final Collection<WeakReference<SubmitterSchedulerLimiter.RecurringWrapper>> recurringTasks;

    public SchedulerServiceLimiter(SchedulerService scheduler, int maxConcurrency) {
        this(scheduler, maxConcurrency, true);
    }

    public SchedulerServiceLimiter(SchedulerService scheduler, int maxConcurrency, boolean limitFutureListenersExecution) {
        super(scheduler, maxConcurrency, limitFutureListenersExecution);
        this.scheduler = scheduler;
        this.recurringTasks = new ConcurrentLinkedQueue<WeakReference<SubmitterSchedulerLimiter.RecurringWrapper>>();
    }

    @Override
    protected void initialRecurringSchedule(SubmitterSchedulerLimiter.RecurringWrapper rw, long initialDelay) {
        Iterator<WeakReference<SubmitterSchedulerLimiter.RecurringWrapper>> it = this.recurringTasks.iterator();
        while (it.hasNext()) {
            if (it.next().get() != null) continue;
            it.remove();
        }
        this.recurringTasks.add(new WeakReference<SubmitterSchedulerLimiter.RecurringWrapper>(rw));
        super.initialRecurringSchedule(rw, initialDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Runnable task) {
        Iterator<WeakReference<SubmitterSchedulerLimiter.RecurringWrapper>> it = this.recurringTasks.iterator();
        while (it.hasNext()) {
            SubmitterSchedulerLimiter.RecurringWrapper rw = (SubmitterSchedulerLimiter.RecurringWrapper)it.next().get();
            if (rw == null) {
                it.remove();
                continue;
            }
            if (!ContainerHelper.isContained((Runnable)rw, task)) continue;
            it.remove();
            if (!rw.invalidate()) continue;
            this.waitingTasks.remove(rw);
            this.scheduler.remove(rw.delayRunnable);
            this.scheduler.remove(rw);
            return true;
        }
        SchedulerServiceLimiter schedulerServiceLimiter = this;
        synchronized (schedulerServiceLimiter) {
            return ContainerHelper.remove((Collection<? extends RunnableContainer>)this.waitingTasks, task) || this.scheduler.remove(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Callable<?> task) {
        Iterator<WeakReference<SubmitterSchedulerLimiter.RecurringWrapper>> it = this.recurringTasks.iterator();
        while (it.hasNext()) {
            SubmitterSchedulerLimiter.RecurringWrapper rw = (SubmitterSchedulerLimiter.RecurringWrapper)it.next().get();
            if (rw == null) {
                it.remove();
                continue;
            }
            if (!ContainerHelper.isContained((Runnable)rw, task)) continue;
            it.remove();
            if (!rw.invalidate()) continue;
            this.waitingTasks.remove(rw);
            this.scheduler.remove(rw.delayRunnable);
            this.scheduler.remove(rw);
            return true;
        }
        SchedulerServiceLimiter schedulerServiceLimiter = this;
        synchronized (schedulerServiceLimiter) {
            return ContainerHelper.remove((Collection<? extends RunnableContainer>)this.waitingTasks, task) || this.scheduler.remove(task);
        }
    }

    @Override
    public int getActiveTaskCount() {
        return this.scheduler.getActiveTaskCount();
    }

    @Override
    public int getQueuedTaskCount() {
        return this.scheduler.getQueuedTaskCount() + this.waitingTasks.size();
    }

    @Override
    public int getWaitingForExecutionTaskCount() {
        return this.scheduler.getWaitingForExecutionTaskCount() + this.waitingTasks.size();
    }

    @Override
    public boolean isShutdown() {
        return this.scheduler.isShutdown();
    }
}

