/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.limiter;

import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.PriorityBlockingQueue;
import org.threadly.concurrent.ContainerHelper;
import org.threadly.concurrent.RunnableCallableAdapter;
import org.threadly.concurrent.RunnableContainer;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.ListenableFutureTask;
import org.threadly.concurrent.wrapper.limiter.ExecutorLimiter;
import org.threadly.util.ArgumentVerifier;

public class OrderedExecutorLimiter<T extends Runnable> {
    private static final int INITIAL_QUEUE_SIZE = 16;
    protected final ExecutorLimiter limiter;

    public OrderedExecutorLimiter(Executor executor, int maxConcurrency, Comparator<? super T> sorter) {
        this(executor, maxConcurrency, true, sorter);
    }

    public OrderedExecutorLimiter(Executor executor, int maxConcurrency, boolean limitFutureListenersExecution, Comparator<? super T> sorter) {
        ArgumentVerifier.assertNotNull(sorter, "sorter");
        this.limiter = new ExecutorLimiter(executor, maxConcurrency, limitFutureListenersExecution, new PriorityBlockingQueue(16, (rc1, rc2) -> {
            T r1 = this.runnableTypeFromContainer((RunnableContainer)rc1);
            T r2 = this.runnableTypeFromContainer((RunnableContainer)rc2);
            return sorter.compare((T)r1, (T)r2);
        })){

            protected <FT> ListenableFutureTask<FT> makeListenableFutureTask(Callable<FT> task) {
                return new OrderedListenableFutureTask<FT>(OrderedExecutorLimiter.this.limiter.waitingTasks, task, (Executor)this);
            }

            @Override
            protected boolean taskCapacity() {
                OrderedExecutorLimiter.this.checkTaskCapacity();
                return super.taskCapacity();
            }
        };
    }

    private T runnableTypeFromContainer(RunnableContainer rc) {
        Runnable r = rc.getContainedRunnable();
        if (r instanceof OrderedListenableFutureTask) {
            Callable c = ((ListenableFutureTask)r).getContainedCallable();
            if (c instanceof RunnableCallableAdapter) {
                r = ((RunnableCallableAdapter)c).getContainedRunnable();
            } else {
                throw new IllegalStateException("Unexpected callable type: " + (c == null ? "null" : c.getClass().toString()));
            }
        }
        return (T)r;
    }

    public int getMaxConcurrency() {
        return this.limiter.getMaxConcurrency();
    }

    public void setMaxConcurrency(int maxConcurrency) {
        this.limiter.setMaxConcurrency(maxConcurrency);
    }

    public int getUnsubmittedTaskCount() {
        return this.limiter.getUnsubmittedTaskCount();
    }

    public ListenableFuture<?> submit(T task) {
        return this.submit(task, null);
    }

    public <R> ListenableFuture<R> submit(T task, R result) {
        return this.limiter.submit((Runnable)task, result);
    }

    public void execute(T task) {
        this.limiter.execute((Runnable)task);
    }

    protected void checkTaskCapacity() {
    }

    protected static class OrderedListenableFutureTask<FT>
    extends ListenableFutureTask<FT> {
        private Collection<? extends RunnableContainer> taskQueue;
        private Callable<FT> task;

        public OrderedListenableFutureTask(Collection<? extends RunnableContainer> taskQueue, Callable<FT> task, Executor executingExecutor) {
            super(task, executingExecutor);
            this.taskQueue = taskQueue;
            this.task = task;
        }

        @Override
        public Callable<FT> getContainedCallable() {
            return this.task;
        }

        @Override
        protected void handleCompleteState() {
            try {
                if (this.isCancelled()) {
                    ContainerHelper.remove(this.taskQueue, this);
                }
            }
            finally {
                this.taskQueue = null;
                this.task = null;
                super.handleCompleteState();
            }
        }
    }
}

