/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.limiter;

import java.util.concurrent.Callable;
import org.threadly.concurrent.SchedulerService;
import org.threadly.concurrent.wrapper.limiter.AbstractKeyedLimiter;
import org.threadly.concurrent.wrapper.limiter.AbstractKeyedSchedulerLimiter;
import org.threadly.concurrent.wrapper.limiter.SchedulerServiceLimiter;
import org.threadly.concurrent.wrapper.traceability.ThreadRenamingSchedulerService;
import org.threadly.util.StringUtils;

public class KeyedSchedulerServiceLimiter
extends AbstractKeyedSchedulerLimiter<SchedulerServiceLimiter> {
    protected final SchedulerService scheduler;

    public KeyedSchedulerServiceLimiter(SchedulerService scheduler, int maxConcurrency) {
        this(scheduler, maxConcurrency, true);
    }

    public KeyedSchedulerServiceLimiter(SchedulerService scheduler, int maxConcurrency, boolean limitFutureListenersExecution) {
        this(scheduler, maxConcurrency, null, false, limitFutureListenersExecution);
    }

    public KeyedSchedulerServiceLimiter(SchedulerService scheduler, int maxConcurrency, String subPoolName, boolean addKeyToThreadName) {
        this(scheduler, maxConcurrency, subPoolName, addKeyToThreadName, true);
    }

    public KeyedSchedulerServiceLimiter(SchedulerService scheduler, int maxConcurrency, String subPoolName, boolean addKeyToThreadName, boolean limitFutureListenersExecution) {
        super(scheduler, maxConcurrency, subPoolName, addKeyToThreadName, limitFutureListenersExecution);
        this.scheduler = scheduler;
    }

    @Override
    protected SchedulerServiceLimiter makeLimiter(String limiterThreadName) {
        return new SchedulerServiceLimiter(StringUtils.isNullOrEmpty(limiterThreadName) ? this.scheduler : new ThreadRenamingSchedulerService(this.scheduler, limiterThreadName, false), this.getMaxConcurrencyPerKey(), this.limitFutureListenersExecution);
    }

    public boolean remove(Runnable task) {
        for (AbstractKeyedLimiter.LimiterContainer limiter : this.currentLimiters.values()) {
            if (!((SchedulerServiceLimiter)limiter.limiter).remove(task)) continue;
            limiter.handlingTasks.decrementAndGet();
            return true;
        }
        return false;
    }

    public boolean remove(Callable<?> task) {
        for (AbstractKeyedLimiter.LimiterContainer limiter : this.currentLimiters.values()) {
            if (!((SchedulerServiceLimiter)limiter.limiter).remove(task)) continue;
            limiter.handlingTasks.decrementAndGet();
            return true;
        }
        return false;
    }

    public int getActiveTaskCount() {
        return this.scheduler.getActiveTaskCount();
    }

    public int getQueuedTaskCount() {
        int result = 0;
        for (AbstractKeyedLimiter.LimiterContainer limiter : this.currentLimiters.values()) {
            result += ((SchedulerServiceLimiter)limiter.limiter).waitingTasks.size();
        }
        return result + this.scheduler.getQueuedTaskCount();
    }

    public boolean isShutdown() {
        return this.scheduler.isShutdown();
    }
}

