/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.limiter;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.threadly.concurrent.AbstractSubmitterExecutor;
import org.threadly.concurrent.RunnableCallableAdapter;
import org.threadly.concurrent.RunnableContainer;
import org.threadly.concurrent.SubmitterExecutor;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.ListenableFutureTask;
import org.threadly.concurrent.future.ListenableRunnableFuture;
import org.threadly.concurrent.wrapper.limiter.ExecutorLimiter;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.StringUtils;

abstract class AbstractKeyedLimiter<T extends ExecutorLimiter> {
    protected static final short CONCURRENT_HASH_MAP_INITIAL_SIZE = 16;
    protected final Executor executor;
    protected final String subPoolName;
    protected final boolean addKeyToThreadName;
    protected final boolean limitFutureListenersExecution;
    protected final ConcurrentHashMap<Object, LimiterContainer> currentLimiters;
    private volatile int maxConcurrency;

    protected AbstractKeyedLimiter(Executor executor, int maxConcurrency, String subPoolName, boolean addKeyToThreadName, boolean limitFutureListenersExecution) {
        ArgumentVerifier.assertNotNull(executor, "executor");
        ArgumentVerifier.assertGreaterThanZero(maxConcurrency, "maxConcurrency");
        this.executor = executor;
        this.subPoolName = StringUtils.nullToEmpty(subPoolName);
        this.addKeyToThreadName = addKeyToThreadName;
        this.limitFutureListenersExecution = limitFutureListenersExecution;
        this.currentLimiters = new ConcurrentHashMap(16);
        this.maxConcurrency = maxConcurrency;
    }

    public int getMaxConcurrencyPerKey() {
        return this.maxConcurrency;
    }

    public void setMaxConcurrencyPerKey(int maxConcurrency) {
        ArgumentVerifier.assertGreaterThanZero(maxConcurrency, "maxConcurrency");
        this.maxConcurrency = maxConcurrency;
        for (LimiterContainer lc : this.currentLimiters.values()) {
            ((ExecutorLimiter)lc.limiter).setMaxConcurrency(maxConcurrency);
        }
    }

    public int getTrackedKeyCount() {
        return this.currentLimiters.size();
    }

    public int getUnsubmittedTaskCount(Object taskKey) {
        ArgumentVerifier.assertNotNull(taskKey, "taskKey");
        LimiterContainer lc = this.currentLimiters.get(taskKey);
        return lc == null ? 0 : ((ExecutorLimiter)lc.limiter).getUnsubmittedTaskCount();
    }

    public Map<Object, Integer> getUnsubmittedTaskCountMap() {
        HashMap<Object, Integer> result = new HashMap<Object, Integer>();
        for (Map.Entry<Object, LimiterContainer> e : this.currentLimiters.entrySet()) {
            int taskCount = ((ExecutorLimiter)e.getValue().limiter).getUnsubmittedTaskCount();
            if (taskCount <= 0) continue;
            result.put(e.getKey(), taskCount);
        }
        return result;
    }

    public void execute(Object taskKey, Runnable task) {
        ArgumentVerifier.assertNotNull(taskKey, "taskKey");
        ArgumentVerifier.assertNotNull(task, "task");
        this.getLimiterContainer(taskKey).execute(task);
    }

    public ListenableFuture<?> submit(Object taskKey, Runnable task) {
        return this.submit(taskKey, task, null);
    }

    public <TT> ListenableFuture<TT> submit(Object taskKey, Runnable task, TT result) {
        return this.submit(taskKey, RunnableCallableAdapter.adapt(task, result));
    }

    public <TT> ListenableFuture<TT> submit(Object taskKey, Callable<TT> task) {
        ArgumentVerifier.assertNotNull(taskKey, "taskKey");
        ArgumentVerifier.assertNotNull(task, "task");
        LimiterContainer lc = this.getLimiterContainer(taskKey);
        ListenableFutureTask<TT> rf = new ListenableFutureTask<TT>(task, (Executor)lc.limiter);
        lc.submit(rf);
        return rf;
    }

    protected LimiterContainer getLimiterContainer(Object taskKey) {
        return this.currentLimiters.compute(taskKey, (k, v) -> {
            if (v == null) {
                v = new LimiterContainer(this, taskKey, this.makeLimiter(this.subPoolName + (this.addKeyToThreadName ? taskKey.toString() : "")));
            }
            v.handlingTasks.incrementAndGet();
            return v;
        });
    }

    protected abstract T makeLimiter(String var1);

    public SubmitterExecutor getSubmitterExecutorForKey(Object taskKey) {
        ArgumentVerifier.assertNotNull(taskKey, "taskKey");
        return new KeyedSubmitterExecutor(taskKey);
    }

    protected static class LimiterContainer {
        public final Object taskKey;
        public final T limiter;
        public final AtomicInteger handlingTasks;
        final /* synthetic */ AbstractKeyedLimiter this$0;

        public LimiterContainer(Object taskKey, T limiter) {
            this.this$0 = this$0;
            this.taskKey = taskKey;
            this.limiter = limiter;
            this.handlingTasks = new AtomicInteger(0);
        }

        public Runnable wrap(Runnable task) {
            return new LimiterCleaner(task);
        }

        public void execute(Runnable task) {
            ((ExecutorLimiter)this.limiter).executeOrQueue(this.wrap(task), null);
        }

        public void submit(ListenableRunnableFuture<?> rf) {
            ((ExecutorLimiter)this.limiter).executeOrQueue(this.wrap(rf), rf);
        }

        private class LimiterCleaner
        implements Runnable,
        RunnableContainer {
            private final Runnable wrappedTask;

            protected LimiterCleaner(Runnable wrappedTask) {
                this.wrappedTask = wrappedTask;
            }

            @Override
            public void run() {
                try {
                    this.wrappedTask.run();
                }
                finally {
                    if (LimiterContainer.this.handlingTasks.decrementAndGet() == 0) {
                        LimiterContainer.this.this$0.currentLimiters.computeIfPresent(LimiterContainer.this.taskKey, (k, v) -> {
                            if (v.handlingTasks.get() == 0) {
                                return null;
                            }
                            return v;
                        });
                    }
                }
            }

            @Override
            public Runnable getContainedRunnable() {
                return this.wrappedTask;
            }
        }
    }

    protected class KeyedSubmitterExecutor
    extends AbstractSubmitterExecutor {
        protected final Object taskKey;

        protected KeyedSubmitterExecutor(Object taskKey) {
            this.taskKey = taskKey;
        }

        @Override
        protected void doExecute(Runnable task) {
            AbstractKeyedLimiter.this.getLimiterContainer(this.taskKey).execute(task);
        }
    }
}

