/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.compatibility;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.threadly.concurrent.AbstractSubmitterScheduler;
import org.threadly.concurrent.wrapper.ThrowableSuppressingRunnable;
import org.threadly.util.ArgumentVerifier;

public class ScheduledExecutorServiceWrapper
extends AbstractSubmitterScheduler {
    protected final ScheduledExecutorService scheduler;

    public ScheduledExecutorServiceWrapper(ScheduledExecutorService scheduler) {
        ArgumentVerifier.assertNotNull(scheduler, "scheduler");
        this.scheduler = scheduler;
    }

    @Override
    protected void doSchedule(Runnable task, long delayInMillis) {
        this.scheduler.schedule(task, delayInMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void scheduleWithFixedDelay(Runnable task, long initialDelay, long recurringDelay) {
        ArgumentVerifier.assertNotNull(task, "task");
        ArgumentVerifier.assertNotNegative(initialDelay, "initialDelay");
        ArgumentVerifier.assertNotNegative(recurringDelay, "recurringDelay");
        this.scheduler.scheduleWithFixedDelay(new ThrowableSuppressingRunnable(task), initialDelay, recurringDelay, TimeUnit.MILLISECONDS);
    }

    @Override
    public void scheduleAtFixedRate(Runnable task, long initialDelay, long period) {
        ArgumentVerifier.assertNotNull(task, "task");
        ArgumentVerifier.assertNotNegative(initialDelay, "initialDelay");
        ArgumentVerifier.assertNotNegative(period, "period");
        this.scheduler.scheduleAtFixedRate(new ThrowableSuppressingRunnable(task), initialDelay, period, TimeUnit.MILLISECONDS);
    }
}

